// Figure 11 for "A Little CAD with C++"
// Copyright 1988 Bruce Eckel
// Permission required to distribute source

// file: shapelst.hpp
/* Two classes to manage a list of cadshapes.
   A shapelist contains a list of (what else)
   shapelist_elements, which simply hold
   a cadshape and a link to the next
   element.  The usual linked list stuff:
   you can insert, step through, etc. */
#ifndef SHAPELST_HPP
#define SHAPELST_HPP
#include "cadshape.hpp"

// tell the compiler the class exists:
class shapelist;

class shapelist_element {
    cadshape * shp;
    shapelist_element * next;
  public:
    // allow shapelist access to the
    // private elements of this class:
    friend shapelist;
    shapelist_element(cadshape * s, 
      shapelist_element * hd) {
        shp = s;
        next = hd;
    }
};

class shapelist {
    shapelist_element * head, * current;
  public:
    shapelist() { current = head = 
       new shapelist_element(
           (cadshape *)0, (shapelist_element *)0);
    } // end of list marked by null pointers
    void insert(cadshape * s) {
        shapelist_element * p = 
            new shapelist_element(s, head);
        head = p;
    }
    void reset() { current = head; }
    cadshape * next();
    void remove(cadshape * s);
    // hunt through the list and find the 
    // nearest element to x,y:
    cadshape * nearest(unsigned x, unsigned y);
};

#endif SHAPELST_HPP
