// Figure 2 for "A Little CAD with C++"
// Copyright 1988 Bruce Eckel
// Permission required to distribute source

// file: msmenu.hpp
/* A mouse control class with a menu to choose
   from.  This is an example of data 
   encapsulation, since it wouldn't make any
   sense to declare more than one instance of
   an msmenu (you only have one mouse!). */

// note the use of "ifndef" with the modified
// header file name.  You should have one of
// these in every header file to prevent 
// multiple declaration of classes:
#ifndef MSMENU_HPP
#define MSMENU_HPP

#define LINESIZE 11
#define CHARWIDTH 10
struct menu_s { // to hold the a user menu
  char * name; // displayed on screen
  int  item_number;
};

class msmenu {
    // pointer to the user's menu:
    struct menu_s * m;        
    // char size of the menu:
    int height, width;        
    // graphic size of the menu:
    int xsize, ysize;         
    // graphic areas used by the menu:
    int msize;                
    fg_color_t  *color_p,  
                // graphic storage area:
                *blank_p;     
    // graphic box:
    fg_box_t    sizing_box;   
        
    int count;  // for messages
    // private function -- can only be called
    // by member functions:
    void drawmenu(int x, int y);
  public:
    // constructor called for a new object:
    msmenu(struct menu_s *);
    // destructor called when object goes out
    // of scope or delete is used:
    ~msmenu();  
    // bring up the menu and get user's choice:
    int get_selection(unsigned x, unsigned y);
    // translate mouse to flash graphics coords:
    void 
    translate_coords(unsigned * x, unsigned * y) {
       *y *= -1; 
       *y += fg_displaybox[FG_Y2]; 
    }
    // different types of cursors:
    void default_cursor(); // arrow
    void menu_cursor(); // horizontal arrow
    void cross_cursor(); // crosshair

    // wait for buttons to be pressed:
    void 
    wait_left_pressed(unsigned *x, unsigned *y) {
        while (!(msm_getstatus(x,y) & 1))
	   ;  
    }
    void
    wait_right_pressed(unsigned *x, unsigned *y) {
        while (!(msm_getstatus(x,y) & 2))
	   ;  
    }
    // wait for buttons to be pressed:
    void 
    wait_left_released(unsigned *x, unsigned *y) {
        while (msm_getstatus(x,y) & 1)
	   ;  
    }
    void 
    wait_right_released(unsigned *x, unsigned *y){
        while (msm_getstatus(x,y) & 2)
	   ;  
    }
};
#endif MSMENU_HPP
