/*
    MFPDEMO.C

    Written by Jerome G. Kahn 1990

    Produced by Pride Software Advancement Corporation...
*/

#include <stdio.h>
#include <dos.h>
#include <ctype.h>
#include <graph.h>
#include <mfp.h>        /* The MFP1 header */

/*
    internal function prototypes...
*/

void drawscrn( char * );
void nprompts( void );
void cprompts( void );
void mess24( char * );
void clearnio( void );
void clearcio( void );
void signoff( void );
void numeric( void );
void character( void );

/*
	Validation and hot key function prototypes
*/

void help( void );
void ninst( void );
void npost( void );
void cinst( void );
void cpost( void );
void datest( void );
void state( void );

/*
	Data entry variable definition
*/

struct NUM_BLK
{
    char 				name[ 21 ];
    short               binarys;
    int                 rel_lum;
    long                sfc_temp;
    unsigned            abs_lum;
    long                age_yrs;
    float 				magnitd;
    double 				distance;
} nio;

struct CHR_BLK
{
    char                fname[ 21 ];
    char                lname[ 21 ];
    char                street[ 21 ];
    char                city[ 21 ];
    char                state[ 3 ];
    char                zip[ 11 ];
    char                phone1[ 14 ];
    char                phone2[ 14 ];
    char                ssn[ 12 ];
    char                dob[ 9 ];
} cio;

/*

           MFP example_1[] = { buffer, "!!!", 5, 15, BLACK, WHITE, 0, 0 };
                  ^              ^       ^    ^   ^    ^      ^    ^  ^
Field Name -------+              |       |    |   |    |      |    |  |
Pointer to data variable --------+       |    |   |    |      |    |  |
Picture formatting string ---------------+    |   |    |      |    |  |
Row of field location ------------------------+   |    |      |    |  |
Column of field location -------------------------+    |      |    |  |
Foreground color of entry field -----------------------+      |    |  |
Background color of entry field ------------------------------+    |  |
Pre validation function pointer -----------------------------------+  |
Post validation function pointer -------------------------------------+


      One of the main features that makes MFP stand out is it's
      picture or data formatting capability. MFP uses a picture
      string to identify the data type and it's characteristics.
      Numeric variables are identified with a "%" percent symbol
      as the first picture character. Any other symbol in the first
      character position forces MFP to assume the data is a character
      array. Numeric data is always entered as BASE 10 or decimal.

      Character entry is filtered by MFP to not allow control codes into
      an entry field.

      Character formatting symbols are as follows:

        !                   Upper case conversion. ( alphanumeric )
        *                   Security echo. All characters are allowed.
        0 - 9               Numeric characters only, value limited by formatter
        A, a                Alpha only allowed
        H, h                Hexadecimal characters only
        X, x                Any ASCII character
        Y, y                Y or N only
        All others          used as stationary objects

      Numeric formatting requirements are as follows:

        "%nn[.][nn]|[L][l][h]|[d][u][f]"

        *   The first character must be a percent symbol.
        *   A length parameter must be provided. This will represent
            the entire entry field length including decimal points and sign.
        *   If a decimal point is provided a decimal length parameter is
            required to indicate the number of decimal positions. A decimal
            point cannot be used for non-floating point variables.

            NOTE: The length parameter must be at least three greater than
                  the decimal length. ie; "%5.3f" would be illegal, yet "%5.2f"
                  would be okay.

        *   Last is the variable type. MFP allows certain modifiers to the
            standard variable types. The legal types  are as follows:

            hd  --  Short integer.
            d   --  Signed integer.
            ld  --  Signed long integer.
            u   --  Unsigned integer.
            lu  --  Unsigned long integer.
            f   --  Single precision floating point.
            lf  --  Double precision floating point.
        *   Lf  --  Long double precision floating point.

        * Long double is not a standard variable type. Turbo C supports long
          double along with a few other compilers. The other versions of this
          library converts your long double to a double.
*/

/*
    Setup of the numeric entry screen...
*/

MFP ln1[] = { nio.name,"!!!!!!!!!!!!!!!!!!!!", 5,20,BLACK,WHITE,ninst,npost };
MFP ln2[] = { &nio.binarys,  "%2hd",   	 7,20,BLACK,WHITE,ninst,npost };
MFP ln3[] = { &nio.rel_lum,  "%6d",      9,20,BLACK,WHITE,ninst,npost };
MFP ln4[] = { &nio.abs_lum,  "%6u",     11,20,BLACK,WHITE,ninst,npost };
MFP ln5[] = { &nio.sfc_temp, "%9ld",    13,20,BLACK,WHITE,ninst,npost };
MFP ln6[] = { &nio.age_yrs,  "%9lu",    15,20,BLACK,WHITE,ninst,npost };
MFP ln7[] = { &nio.magnitd,  "%9.3f",   17,20,BLACK,WHITE,ninst,npost };
MFP ln8[] = { &nio.distance, "%13.3lf", 19,20,BLACK,WHITE,ninst,npost };

/*
    The MFP list array defines which fields are to be entered
    and in what order. The fields in the MFP list must be defined.

    The MFP list is the first parameter that will be passed to the mfp()
    function.

        MFP *example[] = { example_1, example_2, example_3, 0 };

    The MFP list "example" will tell the mfp() function that fields
    example_1, example_2, and example_3 are to be input and in the order
    that they appear in the list. When the mfp() function has scanned
    and processed all of the defined fields and has read in the zero
    it will exit and return control to the calling program.
*/

/*
    Setup of the entry screen list...
*/

MFP *nlst[] = { ln1, ln2, ln3, ln4, ln5, ln6, ln7, ln8, 0 };

/*
    Setup of the character entry screen...
*/

MFP lc1[] = { cio.fname, "!!!!!!!!!!!!!!!!!!!!", 5, 20, BLACK,WHITE, cinst, cpost };
MFP lc2[] = { cio.lname, "!!!!!!!!!!!!!!!!!!!!", 7, 20, BLACK,WHITE, cinst, cpost };
MFP lc3[] = { cio.street,"!!!!!!!!!!!!!!!!!!!!", 9, 20, BLACK,WHITE, cinst, cpost };
MFP lc4[] = { cio.city,  "!!!!!!!!!!!!!!!!!!!!",11, 20, BLACK,WHITE, cinst, cpost };
MFP lc5[] = { cio.state, "!!",                  13, 20, BLACK,WHITE, cinst, state };
MFP lc6[] = { cio.zip,   "99999-9999",          13, 24, BLACK,WHITE, cinst, cpost };
MFP lc7[] = { cio.phone1,"(999)999-9999",       15, 20, BLACK,WHITE, cinst, cpost };
MFP lc8[] = { cio.phone2,"(999)999-9999",       17, 20, BLACK,WHITE, cinst, cpost };
MFP lc9[] = { cio.ssn,   "999-99-9999",         19, 20, BLACK,WHITE, cinst, cpost };
MFP lc10[] = { cio.dob,  "99/99/99",            21, 20, BLACK,WHITE, cinst, datest };

MFP *clst[] = { lc1, lc2, lc3, lc4, lc5, lc6, lc7, lc8, lc9, lc10, 0 };

/*

                Each menu item is defined using the typedef MENU. This
                simplifies your coding and makes defining a menu a snap.

                An example menu item is defined as follows:

                MENU item1[] = { 10, 20, "Edit", 'E', "Edit the above data." };

                The typedef MENU is followed by an item name which must be
                unique. The item must be declared as an array. The array is
                to be defined by direct assignment using the equals symbol
                followed by an open brace.

                The first parameters in the braces are the row and column
                respectively. This is the row and column where this item will
                appear on the screen.

                The next parameter is the item text that will be displayed.

                Following the item text is the alternate keyboard key that
                can also be used to select this item. If this key is pressed,
                this item will be selected and menu() will return with this
                menu item's value. This parameter MUST be uppercase, because
                the keyboard input will be converted to uppercase for testing.

                Last but not least, is the optional help text that will be
                displayed when this menu item is highlighted. If you do not
                want any help text to be displayed, you must place a zero in
                this parameter.

                Finally the menu declaration must be terminated with a close
                brace and a semicolon.

*/

/*
    Setup the main menu
*/

MENU mm1[] = {  8, 10, "Character Demonstration Screen.", 'C',
               "Execute the character demonstration program..." };

MENU mm2[] = { 10, 10, "Numeric Demonstration Screen...", 'N',
               "Execute the numeric demonstration program..." };

MENU mm3[] = { 12, 10, "Exit to DOS....................", 'E',
               "Terminate the MFP1 demonstration and return to DOS..." };

/*
                The menu list directs menu() to show the menu items in the
                order you established in the list, the return value starting
                from zero indicates the selection the user made, the first item
                in the menu list being zero and the last; N - 1. The menu list
                MUST be terminated with a zero. The menu list must be declared
                with the typedef MENU as an array of pointers.
*/

MENU *mmlist[] = { mm1, mm2, mm3, 0 };

/*
    Setup the numeric  and character menu
*/

MENU mn1[] = { 24, 5, "Edit",    'E', 
              "Go back and edit the above screen..." };
MENU mn2[] = { 24,15, "Save",    'S',
              "Save the above screen..." };
MENU mn3[] = { 24,25, "Delete",  'D',
              "Delete the above data from disk...", };
MENU mn4[] = { 24,35, "Abandon", 'A',
              "Abandon the above data, no deletion will occur..." };
MENU mn5[] = { 24,45, "Recall",  'R',
              "Recall a previously saved data record from disk..." };
MENU mn6[] = { 24,55, "Quit",    'Q',
              "Return to the Main Menu..." };

MENU *mnlist[] = { mn1, mn2, mn3, mn4, mn5, mn6, 0 };

/*
    The second parameter that can be passed to the MFP function is a
    procedure list that sets up a relationship of keyboard keys to
    functions.

    The procedure is called when the defined key is pressed. When the
    procedure is finished MFP regains control from where it left off.

    The typedef PROC defines a structure that is used to define the
    link between key and function. A PROC variable is defined and a
    list of PROC variables is passed to the MFP function.

    The PROC variable needs the integer key value returned by inkey()
    and a pointer to the function.

    Any key that the inkey() function can detect is legal for use
    as a hot key.
*/

/*
    The second parameter that can be passed to the MFP function is a
    procedure list that sets up a relationship of keyboard keys to
    functions.

    The procedure is called when the defined key is pressed. When the
    procedure is finished MFP regains control from where it left off.

    The typedef PROC defines a structure that is used to define the
    link between key and function. A PROC variable is defined and a
    list of PROC variables is passed to the MFP function.

    The PROC variable needs the integer key value returned by inkey()
    and a pointer to the function.

    Any key that the inkey() function can detect is legal for use
    as a hot key.

    The following is an example of hot key definitions:

        void help( void );
        void popup_1( void );
        void popup_2( void );

        PROC  hotkey_1[] = { FN1, help };
        PROC  hotkey_2[] = { FN2, popup_1 };
        PROC  hotkey_3[] = { FN3, popup_2 };

        PROC  *hotkeys[] = { hotkey_1, hotkey_2, hotkey_3, 0 };

    The PROC list "hotkeys" is an array of pointers to variables of type PROC.

    The order in which the hot keys are listed does not affect operation.

    The "hotkeys" variable would be passed as the second parameter in the
    mfp() function call. Any time F1, F2, or F3 were pressed when mfp() was
    executed the functions help(), popup_1(), or popup_2() would execute
    then return control to mfp().

    NOTE: The PROC list, like the MFP list, must be terminated with a
          zero.
*/

/*
	Setup the hot key procedures
*/

PROC p1[] = { FN1, help };

/*
                Fast() is primarily designed to operate as a function key
                procedure used in a MFP edit session. It is assigned a
                function key within a PROC declaration.

                A global edit list called "ed_list" must be intialized.

                Fast() uses this "ed_list" to know the fields that can
                be edited. Commonly the ed_list is made equal to the
                mfp list that you pass to MFP. This allows fast() to
                access all fields on the screen.

                In some cases you may want certain fields excluded or
                extra fields included. You should set up a seperate edit
                list for these occasions.

                The ed_list is defined in the MFP library. This means
                you can make up several fast edit lists and before calling
                mfp() you can make "ed_list" equal to that list.

                In the example program described in the MFP section you
                will notice the fast() function being assigned to function
                key two. You should also notice that the "ed_list" is made
                equal to the mfp list in line 49. This makes all fields
                defined in that mfp list accessable to the fast() function.

                Any function that uses the PROC list for function key
                procedures may use fast() to allow field editing.
*/
PROC p2[] = { FN2, fast };

PROC *plist[] = { p1, p2, 0 };

FILE *fp;

/*
    The following text is used for the numeric entry fields...
*/

char *name_txt[] = { 	"Please enter the name",
						"of the stellar system.",
						"",
						"The name can be any",
						"combination of letters",
						"or numbers up to twenty",
						"characters long.",
						0
					};
char *size_txt[] = 	{	"Please enter the number",
						"of stellar mass bodies",
						"in this system.",
						"",
						"A binary system would",
						"have two stellar masses.",
						"",
						"A system like our sun's",
						"would have only one.",
						0
					};
char *lux_txt[] =	{	"Please enter the relative",
						"intensity of the stellar",
						"system in units of lux.",
						"",
						"This must be the relative",
						"value not the absolute.",
						"",
						"This value may be positive",
						"or negative with limits to",
						"+/- 32000.",
						"",
						"It also must be a whole",
						"number.",
						0
					};
char *alux_txt[] =	{	"Please enter the absolute",
						"intensity of the stellar",
						"system in units of lux.",
						"",
						"This must be the absolute",
						"value and not the relative.",
						"",
						"This value must be positive.",
						"Largest value cannot exceed",
						"65,535. It must also be a",
						"whole number.",
						0
					};
char *sftp_txt[] =	{
						"Please enter the surface",
						"temparature in degrees",
						"Kelvin.",
						"",
						"The measured temparature",
						"must be in whole degrees",
						"and may be positive or",
						"negative.",
						"",
						"In the case of a multiple",
						"unit system, please enter",
						"the average temparature.",
						0
					};
char *age_txt[] =	{
						"Please enter the age of",
						"he system in years.",
						"",
						"The age can be approximated",
						"by the apparent luminosity",
						"and the surface temp.",
						"",
						"The age cannot exceed 32",
						"billion years.",
						0
					};
char *magn_txt[] =	{
						"Please enter the magnitude",
						"of the largest body in this",
						"system.",
						"",
						"The magnitude of this system",
						"can be entered as a floating",
						"point value.",
						0
					};
char *ltyr_txt[] =	{
						"Please enter the distance",
						"from gravitaional center of",
						"our solar system to the",
						"gravitational center of",
						"this system.",
						"",
						"This value must be entered",
						"in light years. Fractional",
						"light years are permitted.",
						0
					};
char *mass_txt[] =	{
						"Please enter the systems",
						"total mass in grams.",
						"",
						"This includes all masses",
						"that rotate around the",
						"the center of mass of this",
						"system.",
						"",
						"Planetary bodies can be",
						"ommitted if no data is",
						"present.",
						0
					};
char **num_txt[] =	{
						name_txt,
						size_txt,
						lux_txt,
						alux_txt,
						sftp_txt,
						age_txt,
						magn_txt,
						ltyr_txt,
						mass_txt
					};

/*
    Character entry instructional text...
*/

char *fname_txt[] = {
                        "Please enter the first name.",
                        "",
                        "The entry will be capital-",
                        "ized for you.",
                        "",
                        "This is a twenty character",
                        "field.",
                        0
                    };
char *lname_txt[] = {
                        "Please enter the last name.",
                        "",
                        "The entry will be capital-",
                        "ized for you.",
                        "",
                        "This is a twenty character",
                        "field.",
                        0
                    };
char *strt_txt[]  = {
                        "Please enter the street",
                        "address.",
                        "",
                        "The entry will be capital-",
                        "ized for you.",
                        "",
                        "This is a twenty character",
                        "field.",
                        0
                    };
char *city_txt[]  = {
                        "Please enter the city name.",
                        "",
                        "The entry will be capital-",
                        "ized for you.",
                        "",
                        "This is a twenty character",
                        "field.",
                        0
                    };
char *state_txt[] = {
                        "Please enter the last name.",
                        "",
                        "The entry will be capital-",
                        "ized for you.",
                        "",
                        "This is a two character",
                        "field.",
                        "",
                        "Your entry will be tested",
                        "for a proper state",
                        "abbreviation",
                        0
                    };
char *zip_txt[]   = {
                        "Please enter the zip code.",
                        "",
                        "Only numeric zip codes will",
                        "be accepted for input.",
                        "",
                        "This is a ten character",
                        "field.",
                        0
                    };
char *phon1_txt[] = {
                        "Please enter the home phone.",
                        "",
                        "The commas and dashes will",
                        "be entered for you.",
                        "",
                        "You just enter the numbers.",
                        0
                    };
char *phon2_txt[] = {
                        "Please enter the work phone.",
                        "",
                        "The commas and dashes will",
                        "be entered for you.",
                        "",
                        "You just enter the numbers.",
                        0
                    };
char *ssn_txt[]   = {
                        "Please enter the social",
                        "security number",
                        "",
                        "The dashes will be entered",
                        "for you.",
                        "",
                        "You just enter the numbers.",
                        0
                    };
char *dob_txt[]   = {
                        "Please enter the date",
                        "of birth for this person.",
                        "",
                        "The date entered will be",
                        "checked for validity.",
                        0
                    };
char **char_txt[] = {
                        fname_txt,
                        lname_txt,
                        strt_txt,
                        city_txt,
                        state_txt,
                        zip_txt,
                        phon1_txt,
                        phon2_txt,
                        ssn_txt,
                        dob_txt
                    };

/*============================== Executable code ===========================*/

void main()
{
    int yorn;

    /*
                The scrsave() function requires an integer value representing
                the time in tenths of a second, to wait before blanking the
                display. The purpose for this function is to increase the
                amount of time before your main menu makes a permanent im-
                pression on the phosphors of the users monitor. It accomplishes
                this task by waiting the required time after each keypress
                until the time expires. It then stores the attribute bytes in
                screen memory to a 2k buffer and then writes out a BLACK on
                BLACK attribute in the originals place. This makes the screen
                look like it has been turned off and it effectively will pre-
                vent screen burn. When a subsequent keypress occurs, this func-
                tion will write the stored attributes back out into screen
                memory effectively restoring the original screen.

                The nosave() function is used to disengage the scrsave()
                function. THIS FUNCTION MUST BE CALLED PRIOR TO RETURNING TO
                DOS IF scrsave() IS USED.

                The scrsave() function intercepts interrupt vectors 9 and 1CH.
    */
    scrsave( 3000 );

    /*
                The showclok() function requires the row, column, foreground
                attribute, and background attribute. It will display the
                time continuously until you disengage it. It is a background
                task that will not interfere or measurably affect your app-
                lication. It provides a nice eight character digital presen-
                tation, HH:MM:SS.

                The noclok() function is used to disengage the showclok()
                function. THIS FUNCTION MUST BE CALLED PRIOR TO RETURNING TO
                DOS IF showclok() IS USED.

                The showclok() function intercepts interrupt vector 1CH.
    */
    showclok( 1, 71, RED, WHITE );

    do
    {
        drawscrn("MFP1 Demonstration Software -- Main Menu");

        MENNORMFG = WHITE;  /* Menu normal foreground color */
        MENNORMBG = BLUE;   /* Menu normal background color */
        MENLITEFG = BLUE;   /* Menu highlighted foreground color */
        MENLITEBG = WHITE;  /* Menu highlighted background color */
        MENHLPFG  = WHITE;  /* Menu help text foreground color */
        MENHLPBG  = BLUE;   /* Menu help text background color */

        /*
            Execute the menu defined by the menu list -- mmlist
        */

        yorn = menu( mmlist, 0 );

        switch( yorn )
        {
            case 0:
                character();
                break;
            case 1:
                numeric();
                break;
            default:
                break;
        }

    } while( yorn != 2 );

    /*
        Turn off the clock display and driver...
    */
    noclok();

    /*
        Turn off the screen saver...
    */
    nosave();

    /*
        Make the color normal white on black..
    */
    color( LIGHTGRAY, BLACK );

    /*
        Clear the screen...
    */
    clrscr();

    color( REMOVE );

    /*
        Display our going-away message...
    */
    signoff();
}

/*
    This is the numeric entry module.

    Numeric entry is demonstrated here...
*/

void numeric()
{
    int yorn;

    MENNORMFG = RED;        /* Red menu foreground */
    MENNORMBG = WHITE;      /* White menu background */
    MENLITEFG = WHITE;      /* White menu highlight foreground */
    MENLITEBG = BLUE;       /* Blue menu highlight background */
    MENHLPFG  = WHITE;      /* White help text foreground */
    MENHLPBG  = BLUE;       /* Blue help text background */

    /*
        Clear the numeric entry variables...
    */
    clearnio();

    /*
        Perform the data entry loop...
    */
    do
    {
        drawscrn("MFP1 Numeric Entry Demonstration");

        /*
            Display the entry prompts...
        */
        nprompts();
        mess24("Please enter above data...");

        /*
            Setup the FAST() edit list to be the same as the MFP entry list...
        */
        ed_list = nlst;

        /*
            Perform the data entry now using the numeric entry list and a
            procedure list.
        */
        mfp( nlst, plist  );

        mess24("");

        /*
            Provide a menu of options for the user, the menu is defined
            with the mnlist, also a procedure list is provided for HOT key
            support...
        */
		yorn = menu( mnlist, plist );

        switch( yorn )
        {
            case 1:
                    mess24("Please standby, Saving data to disk...");
                    fp = fopen("MFPNDEMO.DAT","wb");
                    if( fp != NULL )
                    {
                        if( !fwrite((char *)&nio,sizeof(struct NUM_BLK),1,fp) )
                        {
                            mess24("Write error, press any key...");
                            pause();
                        }
                        fclose( fp );
                    }
                    else
                    {
                        mess24("Error opening MFPNDEMO.DAT, press any key");
                        pause();
                    }
                    break;
            case 2:
                    if( unlink("MFPNDEMO.DAT") )
                    {
                        mess24("Error deleting MFPNDEMO.DAT, press any key");
                        pause();
                    }
                    else
                        clearnio();
                    break;
            case 3:
                    clearnio();
                    break;
            case 4:
                    mess24("Please standby, retrieving data from disk...");
                    fp = fopen("MFPNDEMO.DAT","rb");
                    if( fp != NULL )
                    {
                        if( !fread((char *)&nio,sizeof(struct NUM_BLK),1,fp) )
                        {
                            clearnio();
                            mess24("Read error, press any key...");
                            pause();
                        }
                        fclose( fp );
                    }
                    else
                    {
                        mess24("Error opening MFPNDEMO.DAT, press any key");
                        pause();
                    }
                    break;
            default:
                    break;
        }

    } while( yorn != 5 );

}

/*
    Here we perform a character entry demonstration for the user...
*/

void character()
{
    int yorn;

    MENNORMFG = RED;
    MENNORMBG = WHITE;
    MENLITEFG = WHITE;
    MENLITEBG = BLUE;
    MENHLPFG  = WHITE;
    MENHLPBG  = BLUE;

    clearcio();

    do
    {
        drawscrn("MFP1 Character Entry Demonstration");
        cprompts();
        mess24("Please enter above data...");

        ed_list = clst;

        mfp( clst, plist  );

        mess24("");
		yorn = menu( mnlist, plist );

        switch( yorn )
        {
            case 1:
                    mess24("Please standby, Saving data to disk...");
                    fp = fopen("MFPCDEMO.DAT","wb");
                    if( fp != NULL )
                    {
                        if( !fwrite((char *)&cio,sizeof(struct CHR_BLK),1,fp) )
                        {
                            mess24("Write error, press any key...");
                            pause();
                        }
                        fclose( fp );
                    }
                    else
                    {
                        mess24("Error opening MFPCDEMO.DAT, press any key");
                        pause();
                    }
                    break;
            case 2:
                    if( unlink("MFPCDEMO.DAT") )
                    {
                        mess24("Error deleting MFPCDEMO.DAT, press any key");
                        pause();
                    }
                    else
                        clearcio();
                    break;
            case 3:
                    clearcio();
                    break;
            case 4:
                    mess24("Please standby, retrieving data from disk...");
                    fp = fopen("MFPCDEMO.DAT","rb");
                    if( fp != NULL )
                    {
                        if( !fread((char *)&cio,sizeof(struct CHR_BLK),1,fp) )
                        {
                            clearcio();
                            mess24("Read error, press any key...");
                            pause();
                        }
                        fclose( fp );
                    }
                    else
                    {
                        mess24("Error opening MFPCDEMO.DAT, press any key");
                        pause();
                    }
                    break;
            default:
                    break;
        }

    } while( yorn != 5 );

}

void drawscrn( header )
char *header;
{
    static char buf[ 11 ];
    int x;

    color( WHITE, BLUE );
    clrscr();
    color( RED, WHITE );

    /*
        Clear an area defined by the upper left and lower right
        corners. Handy for simple windows or clearing screen
        sections.
    */
    wcls( 1,1, 2,80 );

    color( LIGHTGRAY, BLUE );
    for( x = 3 ; x < 25 ; x++ )
    {
        cup( x,1 );                     /* Cursur position, Row, Column */
        bioputc((unsigned char)186);    /* High performance character output */
        cup( x,48 );
        bioputc((unsigned char)179);
        cup( x,80 );
        bioputc((unsigned char)186);
    }
    color( RED, WHITE );
    wcls( 24,1, 24,80 );
    cup( 1, 2 );
    print( ldate( buf ) ); /* High performance string output */
    x = strlen( header );
    cup( 2, (80-x)/2 );
    print(header);
    color( WHITE, BLUE );
    wcls( 25,1, 25,80 );
    cup( 25,2 );
    print(
    "F1 Help | F2 Jump | F3      | F4      | F5      | F6      | F7      | F8"
        );
}

void nprompts()
{
    color( WHITE, BLUE );

    cup( 5,4 );
    print("Stellar Ident:");

    cup( 7,4 );
    print("  System Size:");

    cup( 9,4);
    print(" Relative Lux:");

    cup( 11,4 );
    print(" Absolute Lux:");

    cup( 13,4 );
    print(" Surface Temp:");

    cup( 15,4 );
    print("  Stellar Age:");

    cup( 17,4 );
    print("    Magnitude:");

    cup( 19,4 );
    print("  Light Years:");
}

void cprompts()
{
    color( WHITE, BLUE );

    cup( 5,4 );
    print("   First Name:");

    cup( 7,4 );
    print("    Last Name:");

    cup( 9,4);
    print("       Street:");

    cup( 11,4 );
    print("         City:");

    cup( 13,4 );
    print("  State / Zip:");

    cup( 15,4 );
    print("   Home Phone:");

    cup( 17,4 );
    print("   Work Phone:");

    cup( 19,4 );
    print("        SSN #:");

    cup( 21,4 );
    print("    Birthdate:");
}

void clearnio()
{
    zero(nio.name,21);
    nio.binarys     = 0;
    nio.rel_lum     = 0;
    nio.sfc_temp    = 0L;
    nio.abs_lum	    = 0;
    nio.age_yrs	    = 0L;
    nio.magnitd	    = 0.0;
    nio.distance    = 0.0;
}

void clearcio()
{
    /*
        zero( char *buf, int length );

        Handy function to initialize a buffer before or after use.

        Be careful with the length parameter - if it's too long,
        it may wipe out other data because you will make it initial-
        ize data after the array.
    */
    zero( cio.fname, sizeof( struct CHR_BLK ) );
}

void mess24( mess )
char *mess;
{
    color( RED, WHITE );
    wcls( 24,2,24,76 );
    cup( 24,2 );
    print( mess );
}

void ninst()
{
    /*
        This function is called in the prevalidation test of each entry field.

        Instead of prevalidation this function displays text on the right hand
        side of the display.
    */

    auto int x = 0;

    /*
        The instructional text will be white on blue...
    */

    color( WHITE, BLUE );

    /*
        Clear the right hand side of the screen for a new display of text...
    */

    wcls( 5,50, 21,79 );

    /*
        Display the text for the particular field.
        The field selection is done by the value of mfp_field.
    */

    while( num_txt[ mfp_field ][ x ] )
    {
        cup( 7+x,50 );
        print( num_txt[ mfp_field ][ x++ ] );
    }
}

void cinst()
{
    /*
        This function is called in the prevalidation test of each entry field.

        Instead of prevalidation this function displays text on the right hand
        side of the display.
    */

    auto int x = 0;

    color( WHITE, BLUE );
    wcls( 5,50, 21,79 );

    while( char_txt[ mfp_field ][ x ] )
    {
        cup( 7+x,50 );
        print( char_txt[ mfp_field ][ x++ ] );
    }
}

void help()
{
    /*
        This function provides general level help.
        It is selected by the user pressing the F1 key.
    */

    static char buf[ 4096 ];

    /*
        Save the entire screen to buf...
    */

    scrswp( buf, 0 );

    /*
        The help will be red on white...
    */

    color( RED, WHITE );

    /*
        Clear rows 24 and 25 on the screen...
    */

    wcls( 24,1,25,80 );

    /*
        Display the requested help message...
    */

    mess24("Your outta luck: no help available, press any key...");

    /*
        Wait until the user presses a key...
    */

    pause();

    /*
        Restore the entire screen to its original state...
    */

    scrswp( buf, 1 );
}

void npost()
{
    /*
        General post validation function for numeric entry section...
    */

    static int r, c, yorn;

    /*
        Buffer for screen storage and retrieval
    */
    static char buf[ 410 ];

    /*
        Was the field changed ?
    */

    if( !mfp_update )
        return;

    /*
        Determine the position for the message box...
    */

    r = mfp_row + 1;
    c = mfp_col + 1;

    /*
        Save the area of screen memory that will be used by the message
        box to our buffer for later screen restoration...
    */

    w_swap( r, c, r + 4, c + 40, 0, buf );

    /*
        Make the box red on white...
    */

    color( RED, WHITE );

    /*
        Clear the area for the box...
    */

    wcls( r, c, r + 4, c + 40 );

    /*
        Draw the box outline with a double line...
    */

    box( r, c, r + 4, c + 40, 1 );

    /*
        Place the cursor in position for the message...
    */

    cup( r + 2, c + 2 );

    /*
        Display the approriate query based upon, the field we are at...
    */

    switch( mfp_field )
    {
        case 0:
            print("Stellar name correct ? (Y/N) ");
            break;
        case 1:
            print("System size correct ? (Y/N) ");
            break;
        case 2:
            print("Relative lux correct ? (Y/N) ");
            break;
        case 3:
            print("Absolute lux correct ? (Y/N) ");
            break;
        case 4:
            print("Surface temp correct ? (Y/N) ");
            break;
        case 5:
            print("Stellar age correct ? (Y/N) ");
            break;
        case 6:
            print("Magnitude correct ? (Y/N) ");
            break;
        default:
            print("Light years correct ? (Y/N) ");
            break;
    }

    /*
        Remove any pending keystrokes...
    */

    flush();

    /*
        Await a users reponse
    */

    do
    {
        yorn = inkey();

    } while( !yorn );

    /*
        Put the original screen contents back...
    */

    w_swap( r, c, r + 4, c + 40, 1, buf );

    /*
        Return with the desired validation result...
    */

    if( yorn == 'Y' || yorn == 'y' )
        mfp_valid = TRUE;
    else
        mfp_valid = FALSE;
}

void cpost()
{
    /*
        Generic post validation for our character entry screen...
    */

    static int r, c, yorn;

    /*
        Buffer for screen storage and retrieval
    */
    static char buf[ 410 ];

    /*
        Was the field changed ?
    */

    if( !mfp_update )
        return;

    /*
        Determine the position for the message box...
    */

    r = mfp_row + 1;
    c = mfp_col + 1;

    /*
        Save the area of screen memory that will be used by the message
        box to our buffer for later screen restoration...
    */

    w_swap( r, c, r + 4, c + 40, 0, buf );

    /*
        Make the box red on white...
    */

    color( RED, WHITE );

    /*
        Clear the area for the box...
    */

    wcls( r, c, r + 4, c + 40 );

    /*
        Draw the box outline with a double line...
    */

    box( r, c, r + 4, c + 40, 1 );

    /*
        Place the cursor in position for the message...
    */

    cup( r + 2, c + 2 );

    /*
        Display the approriate query based upon, the field we are at...
    */

    switch( mfp_field )
    {
        case 0:
            print("First name correct ? (Y/N) ");
            break;
        case 1:
            print("Last name correct ? (Y/N) ");
            break;
        case 2:
            print("Street correct ? (Y/N) ");
            break;
        case 3:
            print("City correct ? (Y/N) ");
            break;
        case 5:
            print("Zip code correct ? (Y/N) ");
            break;
        case 6:
            print("Home phone correct ? (Y/N) ");
            break;
        case 7:
            print("Work phone correct ? (Y/N) ");
            break;
        case 8:
            print("SSN correct ? (Y/N) ");
            break;
    }

    /*
        Remove any pending keystrokes...
    */

    flush();

    /*
        Await a users reponse
    */

    do
    {
        yorn = inkey();

    } while( !yorn );

    /*
        Put the original screen contents back...
    */

    w_swap( r, c, r + 4, c + 40, 1, buf );

    /*
        Return with the desired validation result...
    */

    if( yorn == 'Y' || yorn == 'y' )
        mfp_valid = TRUE;
    else
        mfp_valid = FALSE;
}

void state()
{
    /*
        Validate a state entry...
    */

    static int r, c;

    /*
        List of correct state initials...
    */

    static char *starray = "ALAKAZARCACZCOCTDEDCFLGAGUHIIDILINIAKSKYLAMEMD\
MAMIMNMSMOMTNENVNHNJNMNYNCNDOHOKORPAPRRISCSDTNTXUTVTVIVAWAWVWIWY  \0\0";

    char *ste;
    static char buf[ 410 ];

    ste = mfp_data;

    /*
        Is there data in this field ?
    */

    if( !ste[ 0 ] )
        return;

    /*
        Parse the state array for a match
    */

    for( r = 0 ; starray[ r ] ; r += 2 )
        if( ste[ 0 ] == starray[ r ] )
            if( ste[ 1 ] == starray[ r + 1 ] )
                break;

    if( !starray[ r ] )
    {
        /*
            No match was found, so we have an incorrect state entry...
        */

        /*
            Determine our position on the screen for our message box...
        */

        r = mfp_row + 1;
        c = mfp_col + 1;

        /*
            Save the area for the box to a buffer so we can restore the
            original contents of the screen.
        */

        w_swap( r, c, r + 4, c + 40, 0, buf );

        /*
            Draw our message box...
        */

        color( RED, WHITE );
        wcls( r, c, r + 4, c + 40 );
        box( r, c, r + 4, c + 40, 1 );

        /*
            Let the user know he screwed-up!
        */

        cup( r + 2, c + 4 );
        print("Invalid State, press any key.\007");
        pause();

        /*
            Put the screen back to it's original state...
        */

        w_swap( r, c, r + 4, c + 40, 1, buf );

        /*
            Mark the validation as failed...
        */

        mfp_valid = FALSE;
    }
}

void datest()
{
    /*
        Perform a date verfication
    */

    static char buf[ 410 ];
    static char cdte[ 11 ], tdte[ 11 ];
    int r, c;
    char *dte;

    mfp_valid = TRUE;

    /*
        Setup a pointer to the field data...
    */

    dte = mfp_data;

    /*
        Is there data in the field ?
    */

    if( !dte[ 0 ] )
        return;

    /*
        Convert the short date to a long date by placing a "19" in front
        of the year...
    */

    cdte[ 0 ] = dte[ 0 ];
    cdte[ 1 ] = dte[ 1 ];
    cdte[ 2 ] = dte[ 2 ];
    cdte[ 3 ] = dte[ 3 ];
    cdte[ 4 ] = dte[ 4 ];
    cdte[ 5 ] = dte[ 5 ];
    cdte[ 6 ] = '1';
    cdte[ 7 ] = '9';
    cdte[ 8 ] = dte[ 6 ];
    cdte[ 9 ] = dte[ 7 ];
    cdte[ 10 ] = '\0';

    /*
        Convert the date to a numeric then convert the numeric back into
        a date.

        cdte -- input date.
        tdte -- output date created by converting the numeric result of
                cdte back into a character date.

        The idea is, if the date is illegal the conversion process will fail
        and produce a different date string.
    */

    jul_str( str_jul( cdte ), tdte );

    /*
        Test the date strings...
    */

    if( strcmp( tdte, cdte ) )
    {
        /*
            Determine our location...
        */

        r = mfp_row;
        c = mfp_col + 10;

        /*
            Save a small piece of screen memory to buf...
        */

        w_swap( r, c, r + 4, c + 40, 0, buf );

        /*
            Clear the area of screen memory and draw a box...
        */

        color( RED, WHITE );
        wcls( r, c, r + 4, c + 40 );
        box( r, c, r + 4, c + 40, 1 );

        /*
            Put our nasty-gramm in the box...
        */

        cup( r + 2, c + 4 );
        print("Invalid Date, press any key.\007");
        pause();

        /*
            Restore the screen back to it's original state...
        */

        w_swap( r, c, r + 4, c + 40, 1, buf );

        /*
            Mark the validation as failed, so the user can correct the entry...
        */

        mfp_valid = FALSE;
    }
}

void signoff()
{
    cup( 2,1 );
    puts("Thank you, for giving the MFP1 demo a test-drive!\n");
    puts("The source code to this demo was supplied to give you the");
    puts("opportunity to see the MFP1 library in use.\n");
    puts("The MFP1 library of data entry, menuing, and screen control");
    puts("is available directly from Pride Software Advancement Corp.,");
    puts("users groups, and distributers.\n");
    puts("If you have any questions or comments about the MFP1 library,");
    puts("please contact us at Pride, (305)731-1085, (800)940-2333. If you");
    puts("prefer to write, 3575 N.W. 31 Avenue Oakland Park, FL 33309.\n");
    puts("================================================================\n");
    puts("This demonstration software is released to the public domain for");
    puts("the sole purpose of informing the programming community about the");
    puts("MFP1 library of programming tools.\n");
    puts("You may distribute this software, at no charge, with all the");
    puts("files contained on the original distribution diskette.");
}
