/*
 *  MFP.H
 *
 *  Full screen editor and business library header file.
 *
 */

/*
 *  Function Key definitions
 */

#define FN1         0x0F3B
#define FN2         0x0F3C
#define FN3         0x0F3D
#define FN4         0x0F3E
#define FN5         0x0F3F
#define FN6         0x0F40
#define FN7         0x0F41
#define FN8         0x0F42
#define FN9         0x0F43
#define FN10        0x0F44
#define S_FN1       0x0F54
#define S_FN2       0x0F55
#define S_FN3       0x0F56
#define S_FN4       0x0F57
#define S_FN5       0x0F58
#define S_FN6       0x0F59
#define S_FN7       0x0F5A
#define S_FN8       0x0F5B
#define S_FN9       0x0F5C
#define S_FN10      0x0F5D
#define C_FN1       0x0F5E
#define C_FN2       0x0F5F
#define C_FN3       0x0F60
#define C_FN4       0x0F61
#define C_FN5       0x0F62
#define C_FN6       0x0F63
#define C_FN7       0x0F64
#define C_FN8       0x0F65
#define C_FN9       0x0F66
#define C_FN10      0x0F67
#define A_FN1       0x0F68
#define A_FN2       0x0F69
#define A_FN3       0x0F6A
#define A_FN4       0x0F6B
#define A_FN5       0x0F6C
#define A_FN6       0x0F6D
#define A_FN7       0x0F6E
#define A_FN8       0x0F6F
#define A_FN9       0x0F70
#define A_FN10      0x0F71
#define UPARROW     0x0F48
#define DNARROW     0x0F50
#define LFARROW     0x0F4B
#define RTARROW     0x0F4D
#define C_LFARROW   0x0F73
#define C_RTARROW   0x0F74
#define INSERT      0x0F52
#define DELETE      0x0F53
#define HOME        0x0F47
#define END         0x0F4F
#define PAGEUP      0x0F49
#define PAGEDN      0x0F51
#define C_HOME      0x0F77
#define C_END       0x0F75
#define C_PAGEUP    0x0F84
#define C_PAGEDN    0x0F76
#define ESCAPE      0x001B
#define BACKSPACE   0x0008
#define C_BACKSPACE 0x007F
#define TAB         0x0009
#define S_TAB       0x0F0F
#define ENTER       0x000D
#define C_ENTER     0x000A
#define C_MINUS     0x001F
#define A_MINUS     0x0F82
#define A_EQUAL     0x0F83
#define CTL_A       0x0001
#define CTL_B       0x0002
#define CTL_C       0x0003
#define CTL_D       0x0004
#define CTL_E       0x0005
#define CTL_F       0x0006
#define CTL_G       0x0007
#define CTL_H       0x0008
#define CTL_I       0x0009
#define CTL_J       0x000A
#define CTL_K       0x000B
#define CTL_L       0x000C
#define CTL_M       0x000D
#define CTL_N       0x000E
#define CTL_O       0x000F
#define CTL_P       0x0010
#define CTL_Q       0x0011
#define CTL_R       0x0012
#define CTL_S       0x0013
#define CTL_T       0x0014
#define CTL_U       0x0015
#define CTL_V       0x0016
#define CTL_W       0x0017
#define CTL_X       0x0018
#define CTL_Y       0x0019
#define CTL_Z       0x001A
#define CTL_2       0x0F03
#define CTL_6       0x001E
#define ALT_A       0x0F1E
#define ALT_B       0x0F30
#define ALT_C       0x0F2E
#define ALT_D       0x0F20
#define ALT_E       0x0F12
#define ALT_F       0x0F21
#define ALT_G       0x0F22
#define ALT_H       0x0F23
#define ALT_I       0x0F17
#define ALT_J       0x0F24
#define ALT_K       0x0F25
#define ALT_L       0x0F26
#define ALT_M       0x0F32
#define ALT_N       0x0F31
#define ALT_O       0x0F18
#define ALT_P       0x0F19
#define ALT_Q       0x0F10
#define ALT_R       0x0F13
#define ALT_S       0x0F1F
#define ALT_T       0x0F14
#define ALT_U       0x0F16
#define ALT_V       0x0F2F
#define ALT_W       0x0F11
#define ALT_X       0x0F2D
#define ALT_Y       0x0F15
#define ALT_Z       0x0F26
#define ALT_0       0x0F81
#define ALT_1       0x0F78
#define ALT_2       0x0F79
#define ALT_3       0x0F7A
#define ALT_4       0x0F7B
#define ALT_5       0x0F7C
#define ALT_6       0x0F7D
#define ALT_7       0x0F7E
#define ALT_8       0x0F7F
#define ALT_9       0x0F80

#define	BLACK       0   /* dark colors */
#define	BLUE        1
#define	GREEN       2
#define	CYAN        3
#define	RED         4
#define	MAGENTA     5
#define	BROWN       6
#define	LIGHTGRAY   7
#define	DARKGRAY    8   /* light colors */
#define	LIGHTBLUE   9
#define	LIGHTGREEN  10
#define	LIGHTCYAN   11
#define	LIGHTRED    12
#define	LIGHTMAGENTA 13
#define	YELLOW      14
#define	WHITE       15
#define BLINK		16	/* blink bit */
#define REMOVE      -1,-1
#define FALSE	0
#define TRUE	!FALSE
#define BELL()  putch('\007')

typedef struct proc
{
    int     keyval;             /* Selection key value          */
    void    (*process)(void);   /* Pointer to process function. */

} PROC;

typedef struct
{
	void    *variable;      /* Pointer to variable          */
    char    *picture;       /* Picture filter               */
    int     row;            /* row position                 */
    int     column;         /* column position              */
    int     fg;             /* foreground color of field    */
    int     bg;             /* backround color of field     */
    void    (*pre)(void);   /* pointer to pre-process       */
    void    (*post)(void);  /* pointer to post process      */

} MFP;

typedef struct
{
    int     row;            /* row position                 */
    int     column;         /* column position              */
    char    *text;          /* menu text to display         */
    char    alternate;      /* alternate key selection      */
    char    *help;          /* menu help text line          */

} MENU;

typedef struct
{
    unsigned ur;
    unsigned uc;
    unsigned lr;
    unsigned lc;
    unsigned char *buffer;

} WINDOW;

/* Function prototype declarations */

void clrscr( void );
void bioputc( char );
void cup( int, int );
void fast(void);
void mfp( MFP **, PROC ** );
void eshow( MFP ** );
void scrswp( char *screenbuff, int mode );
void zero( char *string, int strlen );
void fill( char *buf, int len, char data );
void print( char *string );
void wcls( int leftrow, int leftcol, int rightrow, int rightcol );
void color( int foreground, int background );
void pause(void);
void flush( void );
void brkoff( void );
void brkon( void );
void c_on( void );
void c_off( void );
void c_big( void );
void box( int ulr, int ulc, int lrr, int lrc, int type );
void scrsave( int ticks );
void nosave( void );
void showclok( int row, int col, int fg, int bg );
void noclok( void );
void w_swap( int ulr, int ulc, int lrr, int lrc, int mode, char *buf );
void say( int r, int c, char *s );
void delay( unsigned clicks );

char *pic( char *field, char *picture );
char *jul_str( long julian, char *date );
char *ldate( char *date );
char getkey( void );

int scrn( char *, char *, PROC ** );
int inkey( void );
int jul_cal(long julian,char *param);
int menu( MENU **, PROC ** );

unsigned crc( char *buf, unsigned len );
unsigned getcup( void );

long cal_jul(int month,int day,int year);
long time_num( char *time );
long str_jul( char *date );

unsigned long crc32( char *buf, unsigned len );

WINDOW *window_create( unsigned ur, unsigned uc, unsigned lr, unsigned lc );
void window_kill( WINDOW *window );

/* Global Variable Declarations */

extern MFP **ed_list;
extern unsigned int editpos;
extern int mfp_update, mfp_valid, mfp_field, mfp_row, mfp_col, mfp_fg, mfp_bg;
extern void *mfp_data;
extern char *mfp_picture;
extern int MENNORMFG;
extern int MENNORMBG;
extern int MENLITEFG;
extern int MENLITEBG;
extern int MENHLPROW;
extern int MENHLPCOL;
extern int MENHLPLEN;
extern int MENHLPFG;
extern int MENHLPBG;
extern int MENSELPOS;
