.AUTODEPEND

#
# Uncomment and define the following macros if your setup differs
# from the defaults ( C:\BORLANDC and C:\MSVC\MFC for BCPATH and
# MFCPATH respectively )
#
#BCPATH=
#MFCPATH=
#


!if !$d(MODEL)                  #Memory Model of Library & Example
MODEL=l
!endif

!if !$d(MFC_LIBNAME)            #Base name of MFC library built using BC++
MFC_LIBNAME=BCMFC_$(MODEL)
!endif

!if !$d(BCPATH)                 #Root directory of Borland C++
BCPATH=C:\BORLANDC
!endif

!if !$d(MFCPATH)                #Root directory of MFC
MFCPATH=C:\MSVC\MFC
!endif

!if !$d(INCPATH)                #Include paths for compiler
INCPATH=$(BCPATH)\INCLUDE;$(MFCPATH)\INCLUDE
!endif

!if !$d(OBJDIR)                 #Directory for .OBJs
OBJDIR=.\OBJS_$(MODEL)
!endif

!if !$d(LIBDIR)                 #Directory for .LIBs
LIBDIR=$(MFCPATH)\LIB
!endif

!if !$d(LIBFLAGS)
LIBFLAGS = /0 /P128
!endif


!if !$d(NODEBUG)
DBGFLAGS=-D_DEBUG -v
!else
DBGFLAGS=-v-
!endif

!if $d(OBJDIR)
O_DIR=-n$(OBJDIR)
!endif

!if !$d(CFLAGS)
CFLAGS = -c -w-hid -m$(MODEL) $(O_DIR) -WS \
          $(DBGFLAGS) -G -H=$(OBJDIR)\$(MFC_LIBNAME).sym
!endif

TLIB   =  TLIB
CC     =  BCC +$(OBJDIR)\$(MFC_LIBNAME).cfg


.PATH.OBJ=$(OBJDIR)

.cpp.obj: 
    $(CC) -m$(MODEL) {$< }


OBJ_LIST1= afxabort.obj     \
           afxasert.obj     \
           afxinl1.obj      \
           afxinl2.obj      \
           afxmem.obj       \
           afxtrace.obj     \
           afxver.obj       \
           appcore.obj      \
           appdlg.obj       \
           appgray.obj      \
           apphelp.obj      \
           apphelpx.obj     \
           appprnt.obj      \
           appui.obj        \
           arccore.obj      \
           arcex.obj        \
           arcobj.obj       \
           array_b.obj      \
           array_d.obj      \
           array_o.obj      \
           array_p.obj      \
           array_s.obj      \
           array_u.obj      \
           array_w.obj      \
           auxdata.obj      \
           barcore.obj      \
           bardlg.obj       \
           bartool.obj      \
           cmdtarg.obj      

OBJ_LIST2= dcmeta.obj       \
           dcprev.obj       \
           dlgclr.obj       \
           dlgcore.obj      \
           dlgdata.obj      \
           dlgfile.obj      \
           dlgfloat.obj     \
           dlgfnt.obj       \
           dlgfr.obj        \
           dlgprnt.obj      \
           doccore.obj      \
           docmulti.obj     \
           docsingl.obj     \
           doctempl.obj     \
           dumpcont.obj     \
           dumpflt.obj      \
           dumpinit.obj     \
           dumpout.obj      \
           except.obj       \
           filecore.obj     \
           filemem.obj      \
           filest.obj       \
           filetxt.obj      \
           filex.obj        \
           list_o.obj       \
           list_p.obj       \
           list_s.obj       \
           map_pp.obj       \
           map_pw.obj       \
           map_so.obj       \
           map_sp.obj       \
           map_ss.obj       \
           map_wo.obj       \
           map_wp.obj       \
           objcore.obj      \
           olecli.obj       \
           oledoc.obj       \
           olefile.obj      \
           olemisc.obj      \
           olesvr.obj       

OBJ_LIST3= oletsvr.obj      \
           oleui.obj        \
           oleui2.obj       \
           penctrl.obj      \
           plex.obj         \
           strcore.obj      \
           strex.obj        \
           timecore.obj     \
           validadd.obj     \
           viewcore.obj     \
           viewedit.obj     \
           viewform.obj     \
           viewprev.obj     \
           viewprnt.obj     \
           viewscrl.obj     \
           winbtn.obj       \
           wincore.obj      \
           winctrl.obj      \
           winfrm.obj       \
           wingdi.obj       \
           winhand.obj      \
           winmain.obj      \
           winmdi.obj       \
           winmenu.obj      \
           winsplit.obj     \
           winstr.obj


ALL: $(OBJDIR)\$(MFC_LIBNAME).CFG  \
     $(LIBDIR)\$(MFC_LIBNAME)1.LIB \
     $(LIBDIR)\$(MFC_LIBNAME)2.LIB \
     $(LIBDIR)\$(MFC_LIBNAME)3.LIB

    
$(LIBDIR)\$(MFC_LIBNAME)1.LIB : $(OBJ_LIST1) 
    &TLIB $(LIBFLAGS) $< {-+$? }


$(LIBDIR)\$(MFC_LIBNAME)2.LIB : $(OBJ_LIST2) 
    &TLIB $(LIBFLAGS) $< {-+$? }


$(LIBDIR)\$(MFC_LIBNAME)3.LIB : $(OBJ_LIST3) 
    &TLIB $(LIBFLAGS) $< {-+$? }


$(OBJ_LIST1) $(OBJ_LIST2) $(OBJ_LIST3): $(OBJDIR)\$(MFC_LIBNAME).cfg


$(OBJDIR)\$(MFC_LIBNAME).cfg : BCMFC.MAK
    if not exist $(OBJDIR)\NUL md $(OBJDIR)
    echo   -I$(INCPATH)                    >  $<
    echo    $(CFLAGS)                      >> $<
        


