/* AVAILMEM.C
 * By Marc Simkin
 * Neuberger and Berman
 * February 14, 1988
 *
 * USAGE:
 *		status = Get_Available_Memory(available_memory);
 *		unsigned long available_memory;
 *		BYTE			  status;
 *
 * DESCRIPTION:
 *		Get_Available_Memory will return the total amount of memory that is
 *		currently available to be assigned.  The number returned is in bytes.
 *		This routine is based on the Minimum Memory Checker by Noel J. Bergman.
 *
 *		You can ask the function to return just the memory available with the
 *		amount of memory that is being used by the program not included OR
 *		all available system memory.  To get all available system memory, just
 *		initialize available_memory to 0 before calling Get_Available_Memory.
 *		Any other value in Get_Available_Memory will return the currently free
 *		memory that can be assigned with out program termination.
 *
 *		NOTE: This function will most probably NOT function correctly under
 *				OS/2.  This is because it use DOS function 48h under INT 21h,
 *				which is Allocate Memory.
 *
 * Return Value:
 *		This function will return the number of bytes of available memory.
 *
 */

#include <dos.h>
#include <stdio.h>

#define	DOS_SERVICE				0x21	/* DOS Interrupt Request 						*/
#define	Avail_Mem_INT		 0x4800	/* DOS Function to Allocate Memory			*/
#define	Release_Mem_INT	 0x4900	/* DOS Function to Release alloc. memory	*/
#define	BAD_ADDRESS		 	 0xffff	/* Bad Memory address							*/
#define	NOT_ENOUGH_MEMORY	      8
#define	CTL_BK_ERROR				7	/* Memory Control Blocks destoryed			*/
#define	ALL							0	/* Get all the free memory, including the */
												/* memory occupied by the program.			*/

/******************************************************************************/

unsigned long Get_Available_Memory(mem_avail)
long *mem_avail;
{	/***** BEGIN Get_Available_Memory *****/
	union 	REGS 	cpu_regs;     			/* CPU registers 								*/
	struct	SREGS	segment_registers; 	/* CPU segment registers					*/
	int		far	*PSP;						/* far pointer to PSP						*/
	long		avail;							/* number of bytes free						*/

	extern	unsigned _psp;					/* segment address of PSP					*/

	avail = 0;									/* initialize avail to 0					*/

	if (*mem_avail == ALL)
		{	/**** BEGIN ALL ****/
			FP_SEG(PSP) = _psp;						/* _psp is the segment address of psp  */
			FP_OFF(PSP) = 0;							/* offset of the psp is zero				*/
			avail = *(PSP+1) - _psp + 1;			/* number of segments used by program  */
		}	/**** END ALL ****/

	cpu_regs.x.ax = Avail_Mem_INT;
	cpu_regs.x.bx = BAD_ADDRESS;	/* Mamimum amount of memory for request		*/

	/* Call DOS to get the information desired */
	int86(DOS_SERVICE, &cpu_regs, &cpu_regs);
	
	/*
	 * Check to see what was returned in AX, if it is not 7 or 8, function
	 * was success in allocating memory.  Therefore, call function 0x49 to
	 * release the allocated memory and then return 0.
	 */

	if (cpu_regs.x.ax == NOT_ENOUGH_MEMORY)
			avail += cpu_regs.x.bx;
	else if (cpu_regs.x.ax == CTL_BK_ERROR)
		avail = 0;
	else
		{	/**** BEGIN else ****/

			/* Place segment of Allocated Block (AX) into ES. */
			segment_registers.es = cpu_regs.x.ax;
			cpu_regs.x.ax = Release_Mem_INT;
			cpu_regs.x.bx = 0;
			
			/* Call DOS to free the block */
			int86x(DOS_SERVICE, &cpu_regs, &cpu_regs, &segment_registers);

			/* the number of bytes of free memory equal to 0 */
			avail = 0;
		}	/**** END Else ****/

	avail *= 16L;	/* There are 16 bytes in a paragraph (segment) */
	*mem_avail = avail;
}	/***** END Get_Available_Memory *****/

/*
 * END of Get_Available_Memory
 */
