/*  Project test
    
    Copyright  1994. All Rights Reserved.

    SUBSYSTEM:    test.exe Application
    FILE:         tstmdicl.cpp
    AUTHOR:       


    OVERVIEW
    ========
    Source file for implementation of testMDIClient (TMDIClient).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <dir.h>

#include "testapp.h"
#include "tstmdicl.h"
#include "tstmdich.h"
#include "apxprint.h"
#include "apxprev.h"
#include "amdichld.h"
#include "bmdichld.h"
#include "cmdichld.h"


//{{testMDIClient Implementation}}


//
// Build a response table for all messages/commands handled
// by testMDIClient derived from TMDIClient.
//
DEFINE_RESPONSE_TABLE1(testMDIClient, TMDIClient)
//{{testMDIClientRSP_TBL_BEGIN}}
    EV_COMMAND(CM_MDIFILENEW, CmFileNew),
    EV_COMMAND(CM_MDIFILEOPEN, CmFileOpen),
    EV_COMMAND(CM_FILEPRINT, CmFilePrint),
    EV_COMMAND(CM_FILEPRINTERSETUP, CmFilePrintSetup),
    EV_COMMAND(CM_FILEPRINTPREVIEW, CmFilePrintPreview),
    EV_COMMAND_ENABLE(CM_FILEPRINT, CmPrintEnable),
    EV_COMMAND_ENABLE(CM_FILEPRINTERSETUP, CmPrintEnable),
    EV_COMMAND_ENABLE(CM_FILEPRINTPREVIEW, CmPrintEnable),
    EV_WM_DROPFILES,
    EV_COMMAND(CM_CREATEMDIA, CmCreateMdiA),
    EV_COMMAND(CM_CREATEMDIB, CmCreateMdiB),
    EV_COMMAND(CM_CREATEMDIC, CmCreateMdiC),
    EV_COMMAND(CM_AAA, CmAAA),
    EV_COMMAND(CM_BBB, CmBBB),
    EV_COMMAND(CM_CCC, CmCCC),
//{{testMDIClientRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// testMDIClient
// ===========
// Construction/Destruction handling.
 testMDIClient::testMDIClient ()
 : TMDIClient ()
{
    ChildCount = 0;

    // INSERT>> Your constructor code here.

}


 testMDIClient::~testMDIClient ()
{
    Destroy();

    // INSERT>> Your destructor code here.

}


//////////////////////////////////////////////////////////
// testMDIClient
// ===========
// MDIClient site initialization.
void testMDIClient::SetupWindow ()
{
    // Default SetUpWindow processing.
    TMDIClient::SetupWindow ();

    // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
    // computed in the member functions CmFileOpen, and CmFileSaveAs.
    FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
    FileData.SetFilter("All Files (*.*)|*.*|");

    // Accept files via drag/drop in the client window.
    DragAcceptFiles(TRUE);
}


//////////////////////////////////////////////////////////
// testMDIClient
// ===========
// Menu File New command
void testMDIClient::CmFileNew ()
{
    char    title[255];

    // Generate a title for the MDI child window.
    wsprintf(title, "%d", ChildCount++);

    testMDIChild* child = new testMDIChild(*this, title, 0);

    // Associate ICON w/ this child window.
    child->SetIcon(GetApplication(), IDI_DOC);

    // If the current active MDI child is maximize then this one should be also.
    testMDIChild *curChild = (testMDIChild *)GetActiveMDIChild();
    if (curChild && (curChild->GetWindowLong(GWL_STYLE) & WS_MAXIMIZE))
        child->Attr.Style |= WS_MAXIMIZE;

    // NOTE: The 'IDM_MDIA' parameter is just a "dummy" value. I could have
    // used ANY menu resource ID here since I'm really not merging anything
    // from the specified menu resource into the exisiting menu; I'm just
    // removing the current "object" group menu with the "-1" parameter.
    child->SetMenuDescr(TMenuDescr(IDM_MDIA, 0,0,0,-1,0,0));

    child->Create();
}


void testMDIClient::OpenFile (const char *fileName)
{
    if (fileName)
        lstrcpy(FileData.FileName, fileName);

    //
    // Create a MDIChild window whose client is TEditFile.
    //
    testMDIChild* child = new testMDIChild(*this, "", new TEditFile(0, 0, 0, 0, 0, 0, 0, FileData.FileName));

    // Associate ICON w/ this child window.
    child->SetIcon(GetApplication(), IDI_DOC);

    // If the current active MDI child is maximize then this one should be also.
    testMDIChild *curChild = (testMDIChild *)GetActiveMDIChild();
    if (curChild && (curChild->GetWindowLong(GWL_STYLE) & WS_MAXIMIZE))
        child->Attr.Style |= WS_MAXIMIZE;

    child->Create();

    LoadTextFile();
}


//////////////////////////////////////////////////////////
// testMDIClient
// ===========
// Menu File Open command
void testMDIClient::CmFileOpen ()
{
    //
    // Display standard Open dialog box to select a file name.
    //
    *FileData.FileName = 0;
    if (TFileOpenDialog(this, FileData).Execute() == IDOK)
        OpenFile();
}


// Used by ListBox client to read a text file into the list box.
void testMDIClient::LoadTextFile ()
{
    char            buf[255+1];
    ifstream        *inStream;

    testMDIChild  *curChild = (testMDIChild *)GetActiveMDIChild();
    TListBox        *client = TYPESAFE_DOWNCAST(curChild->GetClientWindow(), TListBox);

    // Only work if the client class is a TListBox.
    if (client) {
        client->ClearList();
        inStream = new ifstream(FileData.FileName);
        while (inStream->good()) {
            inStream->getline(buf, sizeof(buf) - 1);
            if (inStream->good())
                client->AddString(buf);
        }

        // Return an error message if we had a stream error and it wasn't the eof.
        if (inStream->bad() && !inStream->eof()) {
            string msgTemplate(*GetModule(), IDS_UNABLEREAD);
            char*  msg = new char[MAXPATH + msgTemplate.length()];
            wsprintf(msg, msgTemplate.c_str(), *FileData.FileName);
            MessageBox(msg, GetApplication()->GetName(), MB_ICONEXCLAMATION | MB_OK);
            delete msg;
        }

        delete inStream;
    }
}


//////////////////////////////////////////////////////////
// testMDIClient
// ==========
// Menu File Print command
void testMDIClient::CmFilePrint ()
{
    //
    // Create Printer object if not already created.
    // 
    testApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), testApp);
    if (theApp) {
        if (!theApp->Printer)
            theApp->Printer = new TPrinter;

        //
        // Create Printout window and set characteristics.
        //
        APXPrintOut printout(theApp->Printer, Title, GetActiveMDIChild(), TRUE);

        theApp->Printing++;

        //
        // Bring up the Print dialog and print the document.
        //
        theApp->Printer->Print(GetActiveMDIChild()->GetClientWindow(), printout, TRUE);

        theApp->Printing--;
    }
}


//////////////////////////////////////////////////////////
// testMDIClient
// ==========
// Menu File Print Setup command
void testMDIClient::CmFilePrintSetup ()
{
    testApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), testApp);
    if (theApp) {
        if (!theApp->Printer)
            theApp->Printer = new TPrinter;

        //
        // Bring up the Print Setup dialog.
        //
        theApp->Printer->Setup(this);
    }
}


//////////////////////////////////////////////////////////
// testMDIClient
// ==========
// Menu File Print Preview command
void testMDIClient::CmFilePrintPreview ()
{
    testApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), testApp);
    if (theApp) {
        if (!theApp->Printer)
            theApp->Printer = new TPrinter;

        theApp->Printing++;

        PreviewWindow *prevW = new PreviewWindow(Parent, theApp->Printer, GetActiveMDIChild(), "Print Preview", new TLayoutWindow(0));
        prevW->Create();

        GetApplication()->BeginModal(GetApplication()->GetMainWindow());

        // We must destroy the preview window explicitly.  Otherwise, the window will not be destroyed until
        // it's parent the MainWindow is destroyed.
        prevW->Destroy();
        delete prevW;

        theApp->Printing--;
    }
}


//////////////////////////////////////////////////////////
// testMDIClient
// ==========
// Menu enabler used by Print, Print Setup and Print Preview.
void testMDIClient::CmPrintEnable (TCommandEnabler &tce)
{
    if (GetActiveMDIChild()) {
        testApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), testApp);
        if (theApp) {
            // If we have a Printer already created just test if all is okay.
            // Otherwise create a Printer object and make sure the printer
            // really exists and then delete the Printer object.
            if (!theApp->Printer) {
                theApp->Printer = new TPrinter;
                
                tce.Enable(theApp->Printer->GetSetup().Error == 0);
            } else
                tce.Enable(theApp->Printer->GetSetup().Error == 0);
        }
    } else
        tce.Enable(FALSE);
}


void testMDIClient::EvDropFiles (TDropInfo)
{
    Parent->ForwardMessage();
}

void testMDIClient::CmCreateMdiA ()
{
    // Generate a title for the MDI child window.
    ChildCount++;

    AMDIChild* child = new AMDIChild(*this, "MDI Child A", 0);

    // Associate ICON w/ this child window.
    child->SetIcon(GetApplication(), IDI_DOC);

    // If the current active MDI child is maximize then this one should be also.
    AMDIChild *curChild = (AMDIChild *)GetActiveMDIChild();
    if (curChild && (curChild->GetWindowLong(GWL_STYLE) & WS_MAXIMIZE))
        child->Attr.Style |= WS_MAXIMIZE;

    child->SetMenuDescr(TMenuDescr(IDM_MDIA, 0,0,0,1,0,0));

    child->Create();
}


void testMDIClient::CmCreateMdiB ()
{
    // Generate a title for the MDI child window.
    ChildCount++;

    BMDIChild* child = new BMDIChild(*this, "MDI Child B", 0);

    // Associate ICON w/ this child window.
    child->SetIcon(GetApplication(), IDI_DOC);

    // If the current active MDI child is maximize then this one should be also.
    BMDIChild *curChild = (BMDIChild *)GetActiveMDIChild();
    if (curChild && (curChild->GetWindowLong(GWL_STYLE) & WS_MAXIMIZE))
        child->Attr.Style |= WS_MAXIMIZE;

    child->SetMenuDescr(TMenuDescr(IDM_MDIB, 0,0,0,1,0,0));

    child->Create();
}


void testMDIClient::CmCreateMdiC ()
{
    // Generate a title for the MDI child window.
    ChildCount++;

    CMDIChild* child = new CMDIChild(*this, "MDI Child C", 0);

    // Associate ICON w/ this child window.
    child->SetIcon(GetApplication(), IDI_DOC);

    // If the current active MDI child is maximize then this one should be also.
    CMDIChild *curChild = (CMDIChild *)GetActiveMDIChild();
    if (curChild && (curChild->GetWindowLong(GWL_STYLE) & WS_MAXIMIZE))
        child->Attr.Style |= WS_MAXIMIZE;

    child->SetMenuDescr(TMenuDescr(IDM_MDIC, 0,0,0,1,0,0));

    child->Create();
}


void testMDIClient::CmAAA ()
{
    MessageBox("CmAAA");
}


void testMDIClient::CmBBB ()
{
    MessageBox("CmBBB");
}


void testMDIClient::CmCCC ()
{
    MessageBox("CmCCC");
}

