#if !defined(__testapp_h)              // Sentry, use file only if it's not already included.
#define __testapp_h

/*  Project test
    
    Copyright  1994. All Rights Reserved.

    SUBSYSTEM:    test.exe Application
    FILE:         testapp.h
    AUTHOR:       


    OVERVIEW
    ========
    Class definition for testApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\statusba.h>
#include <owl\controlb.h>
#include <owl\buttonga.h>
#include <owl\printer.h>

#include <classlib\bags.h>


#include "tstmdicl.h"

#include "testapp.rh"            // Definition of all resources.


// TFileDrop class Maintains information about a dropped file, its name, where it was dropped,
// and whether or not it was in the client area
class TFileDrop {
public:
    operator == (const TFileDrop& other) const {return this == &other;}

    char*   FileName;
    TPoint  Point;
    BOOL    InClientArea;

    TFileDrop (char*, TPoint&, BOOL, TModule*);
    ~TFileDrop ();

    const char* WhoAmI ();
private:
    //
    // hidden to prevent accidental copying or assignment
    //
    TFileDrop (const TFileDrop&);
    TFileDrop & operator = (const TFileDrop&);
};

typedef TIBagAsVector<TFileDrop> TFileList;
typedef TIBagAsVectorIterator<TFileDrop> TFileListIter;


//{{TApplication = testApp}}
class testApp : public TApplication {
private:

private:
    void SetupSpeedBar (TDecoratedMDIFrame *frame);
    void AddFiles (TFileList* files);

public:
    testApp ();
    virtual ~testApp ();

    testMDIClient  *mdiClient;

    // Public data members used by the print menu commands and Paint routine in MDIChild.
    TPrinter        *Printer;                           // Printer support.
    int             Printing;                           // Printing in progress.

//{{testAppVIRTUAL_BEGIN}}
public:
    virtual void InitMainWindow();
    virtual void InitInstance();
//{{testAppVIRTUAL_END}}
//{{testAppRSP_TBL_BEGIN}}
protected:
    void CmHelpAbout ();
    void EvDropFiles (TDropInfo drop);
    void EvWinIniChange (char far* section);
//{{testAppRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(testApp);
};    //{{testApp}}


#endif                                      // __testapp_h sentry.
