// *************************************************************** //
// Filename:    app.cpp                                            //
//                                                                 //
// Date:        11-Feb-94                                          //
//                                                                 //
// Description:                                                    //
//  Class definition for TMdiDvApp                                 //
// *************************************************************** //
#include "MdiDv.h"

// --------------------------------------------------------------- //
// Application constructor                                         //
// --------------------------------------------------------------- //
TMdiDvApp::TMdiDvApp() : 
  TApplication() 
{
}

// --------------------------------------------------------------- //
// Application destructor                                          //
// --------------------------------------------------------------- //
TMdiDvApp::~TMdiDvApp()
{
}

// --------------------------------------------------------------- //
// InitInstance                                                    //
// --------------------------------------------------------------- //
void TMdiDvApp::InitInstance()
{
  TApplication::InitInstance();
  GetMainWindow()->DragAcceptFiles(TRUE);
}

// --------------------------------------------------------------- //
// InitMainWindow                                                  //
// --------------------------------------------------------------- //
void TMdiDvApp::InitMainWindow()
{
  Client = new TMDIClient;
  TDecoratedFrame *frame = new TDecoratedMDIFrame(NULL, 
    "MdiDv application", *Client);
  SetMainWindow(frame);

//  TStatusBar* statusBar = new TStatusBar(frame, TGadget::Recessed);
//  frame->Insert(*statusBar, TDecoratedFrame::Bottom);
  GetMainWindow()->SetMenuDescr(TMenuDescr("MainMenu",1,1,0,0,1,0));
  SetDocManager(new TDocManager(dmMDI | dmMenu));
}

// --------------------------------------------------------------- //
// OwlMain                                                         //
// --------------------------------------------------------------- //
int OwlMain(int /*argc*/, char* /*argv*/ [])
{
  TMdiDvApp app;
  return app.Run();
}


// --------------------------------------------------------------- //
// ResponseTable                                                   //
// --------------------------------------------------------------- //
DEFINE_RESPONSE_TABLE1(TMdiDvApp, TApplication)
  EV_OWLVIEW(dnCreate, EvNewView),
  EV_OWLVIEW(dnClose,  EvCloseView),
  EV_WM_DROPFILES,
END_RESPONSE_TABLE;


// --------------------------------------------------------------- //
// EvDropFiles                                                     //
// --------------------------------------------------------------- //
void TMdiDvApp::EvDropFiles(TDropInfo dropInfo)
{
  int fileCount = dropInfo.DragQueryFileCount();
  for (int index = 0; index < fileCount; index++) 
  {
    int fileLength = dropInfo.DragQueryFileNameLen(index)+1;
    char* filePath = new char [fileLength];
    dropInfo.DragQueryFile(index, filePath, fileLength);
    TDocTemplate* tpl = GetDocManager()->MatchTemplate(filePath);
    if (tpl)
      tpl->CreateDoc(filePath);
    delete filePath;
  }
  dropInfo.DragFinish();
}

// --------------------------------------------------------------- //
// EvNewView                                                       //
// --------------------------------------------------------------- //
void TMdiDvApp::EvNewView(TView &view)
{
  TMDIChild* child = new TMDIChild(*Client, 0, view.GetWindow());
  if (view.GetViewMenu())
    child->SetMenuDescr(*view.GetViewMenu());
  child->Create();
}

void TMdiDvApp::EvCloseView(TView &/*view*/)
{
  // nothing needs to be done here for MDI
}

