// *************************************************************** //
// Filename:    doc.cpp                                            //
//                                                                 //
// Date:        11-Feb-94                                          //
//                                                                 //
// Description:                                                    //
//  Class definition for TMdiDvDocument                          //
// *************************************************************** //
#include "MdiDv.h"

// --------------------------------------------------------------- //
// Document definition                                             //
// --------------------------------------------------------------- //
DEFINE_DOC_TEMPLATE_CLASS(TMdiDvDocument, TMdiDvView, 
  MdiDvTemplate);

MdiDvTemplate MdiDvTpl("MdiDv files (*.gen)", "*.gen", 
  0, "GEN", dtAutoDelete|dtUpdateDir);


// --------------------------------------------------------------- //
// Constructor                                                     //
// --------------------------------------------------------------- //
TMdiDvDocument::TMdiDvDocument(TDocument *parent) : 
  TFileDocument(parent) 
{
  IsDocOpen = FALSE;
}

// --------------------------------------------------------------- //
// Destructor                                                      //
// --------------------------------------------------------------- //
TMdiDvDocument::~TMdiDvDocument()
{
}

// --------------------------------------------------------------- //
// IsOpen                                                          //
// --------------------------------------------------------------- //
BOOL TMdiDvDocument::IsOpen()
{
  return IsDocOpen; 
}

// --------------------------------------------------------------- //
// Open                                                            //
// --------------------------------------------------------------- //
BOOL TMdiDvDocument::Open(int /*mode*/, const char far *path)
{
  IsDocOpen = TRUE;
  if (path)
    SetDocPath(path);
  if (GetDocPath()) 
  {
    TInStream* is = InStream(ofRead);
    if (!is)
      return FALSE;

    delete is;
  }
  SetDirty(FALSE);
  return TRUE;
}

// --------------------------------------------------------------- //
// Close                                                           //
// --------------------------------------------------------------- //
BOOL TMdiDvDocument::Close()
{
  IsDocOpen = FALSE;
  return TRUE;
}

// --------------------------------------------------------------- //
// Revert                                                          //
// --------------------------------------------------------------- //
BOOL TMdiDvDocument::Revert(BOOL clear)
{
  if (!TFileDocument::Revert(clear))
    return FALSE;
  if (!clear)
    Open(0);
  return TRUE;
}

// --------------------------------------------------------------- //
// Commit                                                          //
// --------------------------------------------------------------- //
BOOL TMdiDvDocument::Commit(BOOL force)
{
  if (!IsDirty() && !force)
    return TRUE;

  TOutStream* os = OutStream(ofWrite);
  if (!os)
    return FALSE;

  delete os;
  SetDirty(FALSE);
  return TRUE;
}


