// *************************************************************** //
// Filename:    MdiDv.h                                            //
//                                                                 //
// Date:        11-Feb-94                                          //
//                                                                 //
// Description:                                                    //
//  Class declaration for                                          //
//    TMdiDvApplication                                            //
//    TMdiDvDocument                                               //
//    TMdiDvView                                                   //
// *************************************************************** //

#ifndef MdiDv_H
#define MdiDv_H
#include <owl\owlcore.h>
#include <owl\docmanag.h>
#include <owl\filedoc.h>
#include <owl\statusba.h>
#pragma hdrstop
#include "MdiDv.rh"

// --------------------------------------------------------------- //
// TMdiDvDocument                                                  //
// --------------------------------------------------------------- //
class _DOCVIEWCLASS TMdiDvDocument : public TFileDocument
{
  public:
    TMdiDvDocument(TDocument *parent = 0);
   ~TMdiDvDocument();

    // implement virtual methods of TDocument
    BOOL   IsOpen();
    BOOL   Open(int mode, const char far *path=0);
    BOOL   Close();
    BOOL   Commit(BOOL force = FALSE);
    BOOL   Revert(BOOL clear = FALSE);

  protected:
    BOOL IsDocOpen;
};

// --------------------------------------------------------------- //
// TMdiDvView                                                      //
// --------------------------------------------------------------- //
class _DOCVIEWCLASS TMdiDvView : public TWindowView
{
  public:
    TMdiDvView(TMdiDvDocument &doc, TWindow *parent = 0);
   ~TMdiDvView();
    static const char far *StaticName();
    const char far *GetViewName()
      {return StaticName();}

  protected:
    TMdiDvDocument *MdiDvDoc;  // same as Doc member, but cast to derived class

    // Document notifications
    BOOL VnCommit(BOOL force);
    BOOL VnRevert(BOOL clear);

    void CmItem();

    DECLARE_RESPONSE_TABLE(TMdiDvView);
};

// --------------------------------------------------------------- //
// MdiDvApplication                                                //
// --------------------------------------------------------------- //
class TMdiDvApp : public TApplication 
{
  public:
    TMDIClient* Client;

    TMdiDvApp();
   ~TMdiDvApp();

    void InitInstance();
    void InitMainWindow();

    // Event handlers
    void EvNewView  (TView &view);
    void EvDropFiles(TDropInfo dropInfo);
    void EvCloseView(TView &/*view*/);
    DECLARE_RESPONSE_TABLE(TMdiDvApp);
};

#endif



