/********************************************************************/
/*             tbmdidlg.h - MDI Dialog Window Class                 */
/*                 Written by Benjamin Cooley                       */
/********************************************************************/

// Note: this class is not yet directly streamable

#ifndef _TBMDIDLG_H
#define _TBMDIDLG_H

#ifndef __OWL_H
#include <owl.h>
#endif

#ifndef __WINDOWS_H
#include <windows.h>
#endif

#ifndef BWCCVERSION
#include <bwcc.h>
#endif

#ifndef __BWINDOW_H
#include <bwindow.h>
#endif

_CLASSDEF(TBMDIDialog)
class TBMDIDialog : public TBWindow
{
  public:
	TBMDIDialog(PTWindowsObject AParent, int ResourceId, PTModule AModule = NULL);
	TBMDIDialog(PTWindowsObject AParent, Pchar AName, PTModule AModule = NULL);
	TBMDIDialog(PTWindowsObject AParent, Pvoid ATemplate, PTModule AModule = NULL);
	TBMDIDialog(StreamableInit s) : TBWindow(s) {}
	~TBMDIDialog();
	virtual void CloseWindow();
	virtual void CloseWindow(int ARetValue);

	Pchar Name;    // Hold name of dlg (NULL if Id used)
	int Id;        // Holds Id of dlg

  protected:
	virtual BOOL Create();
	virtual void SetupWindow();
	virtual void GetWindowClass(WNDCLASS & AWndClass);
	virtual void ControlColor(RTMessage Msg) = [WM_FIRST + WM_CTLCOLOR];

	virtual void WMNCPaint(RTMessage Msg) = [WM_FIRST + WM_NCPAINT];
	virtual void WMNCCalcSize(RTMessage Msg) = [WM_FIRST + WM_NCCALCSIZE];
	virtual void WMCommand(RTMessage Msg) = [WM_FIRST + WM_COMMAND];
	virtual void WMClose(RTMessage Msg) = [WM_FIRST + WM_CLOSE];

  private:
	HFONT font;					// Font for this dialog
	int fontwidth, fontheight;	// Width and height of the font (for units)
	Pchar templatebfr;          // Resource template buffer
	BOOL ownstemplate;			// Does dialog object own template buffer
	BOOL visible;				// Should window be visible

	static int users;	 		// Number of users of this class
	static HBITMAP bgbitmap;	// Background bitmap
	static HBRUSH bgbrush;		// Background brush
	static HBRUSH graybrush;	// Solid control background brush

	void LoadWindowAttr();
	void CreateWindowControls();

	int DialogX(int x);			// Converts dialog X units to screen units
	int DialogY(int y);			// Converts dialog Y units to screen units
};

#endif

