/********************************************************************/
/*                   MDI Dialog Sample Program                      */
/*                      by Benjamin Cooley                          */
/*                           7-2-1992                               */
/********************************************************************/

// !! NOTE !!  !! NOTE !! !! NOTE !! !! NOTE !! !! NOTE !! !! NOTE !!
// Note: Change the directories in the Options|Directories.. menu
// to your include and library directories before compiling.
// !! NOTE !!  !! NOTE !! !! NOTE !! !! NOTE !! !! NOTE !! !! NOTE !!

#include <windows.h>
#include <owl.h>
#include <edit.h>
#include <combobox.h>
#include <listbox.h>
#include <bradio.h>
#include <bchkbox.h>
#include <bwcc.h>
#include "tbmdidlg.h"
#pragma hdrstop

#include "samplerc.h"

// Some other information:
//
// See the TBMDIDLG.CPP file for information on using the class.
//
// If your like me, you don't exactly like the way borland did its
// transfer buffers.  The problem is that often times the structures
// you need to edit are not in the same order as the controls in
// the dialog.
//
// There is an easy work around though.  Try redefining the TransferData()
// function using the code below..

#if 0

// This dummy class allows us to get at the protected buffer functions from
// our new TransferData function.

_CLASSDEF(WinObj)
class WinObj : public TWindowsObject
{
  friend class TMyDialog;
};

// Transfers the data for each child

void TMyDialog::TransferDataChild(void *AChild, void *Direction)
{

	if ( ((PWinObj)AChild)->IsFlagSet(WB_TRANSFER)
	  && ((PWinObj)AChild)->TransferBuffer )
	{
		((PWinObj)AChild)->Transfer(
			((PWinObj)AChild)->TransferBuffer, *(WORD *)Direction);
	}
}

// Our new TransferData function

void TResourceEdit::TransferData(WORD Direction)
{
	if ( IsFlagSet(WB_TRANSFER) )
	{
		ForEach(TransferDataChild, &Direction);
	}
}

#endif

// This little bit of code makes the TransferData function call each
// of the controls TransferData function for their own individual
// buffers.  Just set each control individually to their own buffer
// and they will edit and update that buffer.  To set a control to
// a buffer, call the SetBuffer function for that control..

// char mystring[21];
// PTEdit edit = new TEdit(dialog, 101, 21);
// edit->SetBuffer(mystring);

// And the control will then edit mystring.  Works great!

/********************************************************************/
/*                            Control Stuff                         */
/********************************************************************/

_CLASSDEF(TSampleComboBox)
class TSampleComboBox : public TComboBox
{

  public:
	TSampleComboBox(PTWindowsObject AParent, int ResourceId, WORD ATextLen, PTModule ATModule = NULL) :
	  TComboBox(AParent, ResourceId, ATextLen, ATModule) {}

  protected:
	virtual void SetupWindow();
};

void TSampleComboBox::SetupWindow()
{
	TComboBox::SetupWindow();

    char buf[40];
	for (int c = 1; c <= 20; c++)
    { 
		wsprintf(buf, "Selection Number (%d)", c);
		AddString(buf);
	}
}

_CLASSDEF(TSampleListBox)
class TSampleListBox : public TListBox
{

  public:
	TSampleListBox(PTWindowsObject AParent, int ResourceId, PTModule ATModule = NULL) :
	  TListBox(AParent, ResourceId, ATModule) {}

  protected:
	virtual void SetupWindow();
};

void TSampleListBox::SetupWindow()
{
	TListBox::SetupWindow();

    char buf[40];
	for (int c = 1; c <= 20; c++)
    { 
		wsprintf(buf, "Selection Number (%d)", c);
		AddString(buf);
	}
}

/********************************************************************/
/*                         Main Window Stuff                        */
/********************************************************************/

_CLASSDEF(TSampleWindow)
class _CLASSTYPE TSampleWindow : public TMDIFrame
{

public:
	TSampleWindow();

protected:
	virtual void FileNew(RTMessage Msg) = [CM_FIRST + CM_FileNew];
    virtual void CloseAll(RTMessage Msg) = [CM_FIRST + CM_CloseAll];

};

TSampleWindow::TSampleWindow()
  : TMDIFrame("Sample Window", MNU_Sample)
{
  /* Set child menu pos */
	ChildMenuPos = 1;
}

#pragma argsused
void TSampleWindow::FileNew(RTMessage Msg)
{
	PTBMDIDialog dialog = new TBMDIDialog(this, DLG_Sample);

	new TEdit(dialog, 101, 20);
	new TSampleComboBox(dialog, 102, 30);
	new TBRadioButton(dialog, 103, NULL);
	new TBCheckBox(dialog, 104, NULL);
	new TSampleListBox(dialog, 105);

	if (dialog)
	  GetModule()->MakeWindow(dialog);
}

#pragma argsused
void TSampleWindow::CloseAll(RTMessage Msg)
{
    CloseChildren();
}

/********************************************************************/
/*                   TSampleApp Application Class                   */
/********************************************************************/

_CLASSDEF(TSampleApp)
class TSampleApp : public TApplication
{

  public:
	TSampleApp(LPSTR AName, HANDLE AnInstance, HANDLE APrevInstance,
	  LPSTR ACmdLine, int ACmdShow) :
		TApplication(AName, AnInstance, APrevInstance, ACmdLine, ACmdShow)
		  {}

    virtual void InitMainWindow();
    virtual void InitInstance();

};

void TSampleApp::InitMainWindow()
{
	MainWindow = new TSampleWindow();
}

void TSampleApp::InitInstance()
{
	TApplication::InitInstance();

  /* Force loading of Custom Control .DLL */
	BWCCGetVersion();
}

/********************************************************************/
/*                           Main Program                           */
/********************************************************************/

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
	TSampleApp SampleApp("Sample Program", hInstance, hPrevInstance,
			   lpCmdLine, nCmdShow);
	SampleApp.Run();
	return SampleApp.Status;
}
