// ----------- //
// MDITBAR.CPP //
// ----------- //

#define   STRICT

#include <owl.h>
#include <dialog.h>
#include <bwcc.h>
#include <mdi.h>
#include <window.h>


_CLASSDEF( TMyMDIApp )
_CLASSDEF( TMyMDIFrame )
_CLASSDEF( TBarDialog )



class TMDIApp : public TApplication
{
    public:
        TMDIApp( LPSTR name,
                 HINSTANCE hInstance,
                 HINSTANCE hPrevInstance,
                 LPSTR lpCmd,
                 int nCmdShow ) :
        TApplication( name, hInstance, 
                      hPrevInstance, lpCmd, nCmdShow )
        {};
        virtual void InitMainWindow();
};



class TBarDialog : public TDialog
{
    public:
        TBarDialog( PTWindowsObject AParent, LPSTR AResource,
                    PTModule AModule = NULL ) :
        TDialog( AParent, AResource, AModule )
        {}

        virtual void IDYes( RTMessage )   = [ ID_FIRST + IDYES ];
};



void TBarDialog::IDYes( RTMessage )
{
    if ( (( PTMDIFrame )Parent)->ActiveChild )
    {
        HDC  hDC;
        HWND hWnd;

        hWnd  = (( PTMDIFrame )Parent )->ActiveChild->HWindow;
        hDC   = GetDC( hWnd );

        if ( hDC )
        {
            char szMsg[] = "YES - Bar Button pressed";

            TextOut( hDC, 10, 10, szMsg, lstrlen( szMsg ));
            ReleaseDC( hWnd, hDC );
        }
    }
    MessageBeep( 0 );
}



class TMyMDIFrame : public TMDIFrame
{
        int nTBarHeight;
        PTBarDialog pToolBar;
    public:
        TMyMDIFrame( LPSTR ATitle, LPSTR MenuName ) :
        TMDIFrame( ATitle, MenuName )
        {}
        virtual void SetupWindow();
        virtual void WMSize( RTMessage msg ) =
                   [ WM_FIRST + WM_SIZE ];
};



void TMyMDIFrame::SetupWindow()
{
    RECT  rc;

    TMDIFrame::SetupWindow();

    pToolBar = new TBarDialog( this, "BARDIALOG" );
    GetApplication()->MakeWindow( pToolBar );
    GetWindowRect( pToolBar->HWindow, &rc  );
    pToolBar->Show( SW_SHOWNORMAL );
    nTBarHeight = rc.bottom - rc.top;
}



void TMyMDIFrame::WMSize( RTMessage msg )
{
    TMDIFrame::WMSize( msg );

    MoveWindow( ClientWnd->HWindow,
                0, nTBarHeight,
                LOWORD( msg.LParam ),
                HIWORD( msg.LParam ) - nTBarHeight, TRUE );

    MoveWindow( pToolBar->HWindow, 0, 0, 
                LOWORD( msg.LParam ),
                nTBarHeight, FALSE );
}



void TMDIApp::InitMainWindow()
{
    MainWindow = new TMyMDIFrame( "MDI App.", "MDIMenu");
}



int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow )
{
    TMDIApp MDIApp ( "MDI App.",
                      hInstance,
                      hPrevInstance,
                      lpszCmdLine,
                      nCmdShow );
    BWCCGetVersion();
    MDIApp.Run();
    return ( MDIApp.Status );
}






