/*^^**************************************************************************
NAME:       M$DEBUG.H
PURPOSE:    Aid in Debugging Memory Allocation Errors
CREATED:    December 4, 1991
AUTHOR:     Todd S. Crook
UPDATED:
SYNOPSIS:  M$DeBug provides an aid in debugging memory allocations and
    manipulations performed through stdio.h, stdlib and alloc.h type
    functions. By creating fence posts and storing allocation lengths
    as part of the allocation protection against memory overwrites can
    be detected and/or guarded against.

^****************************************************************************/
#ifndef _MDEBUG_HEADER
    #define _MDEBUG_HEADER "M$DeBug.H"

    #if !defined( _BOOLEAN_DEFINED ) && !defined( BOOLEAN )
        typedef short BOOLEAN;
        #define _BOOLEAN_DEFINED
        #ifndef TRUE
            #define TRUE  ( 1 == 1 )
        #endif
        #ifndef FALSE
            #define FALSE   !( 1 == 1 )
        #endif
    #endif

    #define MERR_OUT_RANGE       -900
    #define MERR_OUT_MEMORY      -901
    #define MERR_ADD_PNODE       -902
    #define MERR_DEL_PNODE       -903
    #define MERR_SIGNITURE       -904

    extern void  Show_Current_MDeBugAllocations( void );
    extern void  mdebug_error_logging_off( void );
    extern void  mdebug_error_logging_on( void );

    /* redefine normal library memory calls */
    #if defined( DEBUG_MALLOC )
        #define malloc(x)               (void *)MDbgAlloc(((unsigned int)x))
        #define calloc(x,y)             (void *)CMDbgAlloc(((unsigned int)x),((unsigned int)y))
        #define realloc(x,y)            (void *)MDbgReAlloc(((void *)x),((unsigned int)y))
        #define free(x)                 (void)Free_MDbgAlloc(((void *)x))
        #define memccpy(x,y,c,z)        (void *)CCopy_MDbgAlloc(((void *)(x)),((const void *)(y)),((int)c),((unsigned int)z))
        #define memchr(x,c,z)           (void *)SrchCh_MDbgAlloc(((const void *)(x)),((int)c),((unsigned int)z))
        #define memcmp(x,y,z)           (int)Compare_MDbgAlloc(((const void *)(x)),((const void *)(y)),((BOOLEAN)FALSE),((unsigned int)z))
        #define memcpy(x,y,z)           (void *)Copy_MDbgAlloc(((void *)(x)),((const void *)(y)),((unsigned int)z))
        #define memicmp(x,y,z)          (int)Compare_MDbgAlloc(((const void *)(x)),((const void *)(y)),((BOOLEAN)FALSE),((unsigned int)z))
        #define memmove(x,y,z)          (void *)Copy_MDbgAlloc(((void *)(x)),((const void *)(y)),((unsigned int)z))
        #define memset(x,c,z)           (void *)Set_MDbgAlloc(((void *)(x)),((int)c),((BOOLEAN)FALSE),((unsigned int)z))
        #define movedata(ss,so,ds,do,z) (void *)Copy_MDbgAlloc(MK_FP(ds,do),MK_FP(ss,so),((unsigned int)z))
        #define movemem(x,y,z)          (void *)Copy_MDbgAlloc(((void *)(y)),((const void *)(x)),((unsigned int)z))
        #define setmem(x,z,c)           (void *)Set_MDbgAlloc(((void *)(x)),((int)c),((BOOLEAN)FALSE),((unsigned int)z))
        #define stpcpy(x,y)             (char *)CCopy_MDbgAlloc(((char *)(x)),((const char *)(y)),((int)'\0'),((unsigned int)strlen(y)))
        #define strcat(x,y)             (char *)CCat_MDbgAlloc(((char *)(x)),((const char *)(y)),((int)'\0'),((unsigned int)strlen(y)+1))
        #define strchr(x,c)             (char *)SrchCh_MDbgAlloc(((const char *)(x)),((int)(c)),((unsigned int)strlen(x)))
        #define strcmp(x,y)             (int)Compare_MDbgAlloc(((const char *)(x)),((const char *)(y)),((BOOLEAN)TRUE), \
                                                ((unsigned int)((strlen(x) < strlen(y) ? strlen(x) : strlen(y)))))
        #undef  strcmpi
        #define strcmpi(x,y)            (int)ICompare_MDbgAlloc(((const char *)(x)),((const char *)(y)),((BOOLEAN)TRUE), \
                                                ((unsigned int)((strlen(x) < strlen(y) ? strlen(x) : strlen(y)))))
        #define strcoll(x,y)            (int)Compare_MDbgAlloc(((const char *)(x)),((const char *)(y)),((BOOLEAN)TRUE),((unsigned int)strlen(y)))
        #define strcpy(x,y)             (char *)Copy_MDbgAlloc(((const char *)(x)),((const char *)(y)),((unsigned int)strlen(y)+1))
        #define strdup(x)               (char *)CDuplicate_MDbgAlloc(((char *)(x)),((int)'\0'),((unsigned int)strlen(x)+1))
        #define stricmp(x,y)            (int)ICompare_MDbgAlloc(((const char *)(x)),((const char *)(y)),((BOOLEAN)TRUE),(strlen(x) < strlen(y) ? strlen(x) : strlen(y)))
        #define strlen(x)               (unsigned int)Len_MDbgAlloc(((const char far *)x))
        #define strlwr(x)               (char *)Change_MDbgAlloc(((char *)(x)),((BOOLEAN)TRUE),((unsigned int)strlen(x)))
        #define strncat(x,y,z)          (char *)CCat_MDbgAlloc(((char *)(x)),((const char *)(y)),((int)'\0'),((unsigned int)z))
        #define strncmp(x,y,z)          (int)Compare_MDbgAlloc(((const char *)(x)),((const char *)(y)),((BOOLEAN)TRUE),((unsigned int)z))
        #undef  strncmpi
        #define strncmpi(x,y,z)         (int)ICompare_MDbgAlloc(((const char *)(x)),((const char *)(y)),((BOOLEAN)TRUE),((unsigned int)z))
        #define strncpy(x,y,z)          (char *)CCopy_MDbgAlloc(((char *)(x)),((const char *)(y)),((int)'\0'),((unsigned int)z))
        #define strnicmp(x,y,z)         (int)ICompare_MDbgAlloc(((const char *)(x)),((const char *)(y)),((BOOLEAN)TRUE),((unsigned int)z))
        #define strnset(x,c,z)          (char *)Set_MDbgAlloc(((char *)(x)),((int)c),((BOOLEAN)TRUE),((unsigned int)z))
        #define strset(x,c)             (char *)Set_MDbgAlloc(((char *)(x)),((int)c),((BOOLEAN)TRUE),((unsigned int)strlen(x)))
        #define strupr(x)               (char *)Change_MDbgAlloc(((char *)(x)),((BOOLEAN)FALSE),((unsigned int)strlen(x)))

        #define farmalloc(x)            (void far *)MDbgAlloc(((unsigned long)x))
        #define farcalloc(x,y)          (void far *)CMDbgAlloc(((unsigned long)x),((unsigned long)y))
        #define farrealloc(x,y)         (void far *)MDbgReAlloc(((void far *)x),((unsigned long)y))
        #define farfree(x)              (void far)Free_MDbgAlloc(((void far *)x))
        #define _fmemccpy(x,y,c,z)      (void far *)CCopy_MDbgAlloc(((void far *)(x)),((const void far *)(y)),((int)c),((unsigned long)z))
        #define _fmemchr(x,c,z)         (void far *)SrchCh_MDbgAlloc(((const void far *)(x)),((int)c),((unsigned long)z))
        #define _fmemcmp(x,y,z)         (int)Compare_MDbgAlloc(((const void far *)(x)),((const void far *)(y)),((BOOLEAN)FALSE),((unsigned long)z))
        #define _fmemcpy(x,y,z)         (void far *)Copy_MDbgAlloc(((void far *)(x)),((const void far *)(y)),((unsigned long)z))
        #define _fmemicmp(x,y,z)        (int)Compare_MDbgAlloc(((const void far *)(x)),((const void far *)(y)),((BOOLEAN)FALSE),((unsigned long)z))
        #define _fmemset(x,c,z)         (void far *)Set_MDbgAlloc(((void far *)(x)),((int)c),((BOOLEAN)FALSE),((unsigned long)z))
        #define _fstrcat(x,y)           (char far *)CCat_MDbgAlloc(((char far *)(x)),((const char far *)(y)),((int)'\0'),((unsigned long)strlen(y)+1))
        #define _fstrchr(x,c)           (char far *)SrchCh_MDbgAlloc(((const char far *)(x)),((int)(c)),((unsigned long)strlen(x)))
        #define _fstrdup(x)             (char far *)CDuplicate_MDbgAlloc(((char far *)(x)),((int)'\0'),((unsigned long)strlen(x)+1))
        #define _fstricmp(x,y)          (int)ICompare_MDbgAlloc(((const char far *)(x)),((const char far *)(y)),((BOOLEAN)TRUE),(strlen(x) < strlen(y) ? strlen(x) : strlen(y)))
        #define _fstrlen(x)             (unsigned long)Len_MDbgAlloc(((const char far *)x))
        #define _fstrlwr(x)             (char far *)Change_MDbgAlloc(((char far *)(x)),((BOOLEAN)TRUE),((unsigned long)strlen(x)))
        #define _fstrncat(x,y,z)        (char far *)CCat_MDbgAlloc(((char far *)(x)),((const char far *)(y)),((int)'\0'),((unsigned long)z))
        #define _fstrncmp(x,y,z)        (int)Compare_MDbgAlloc(((const char far *)(x)),((const char far *)(y)),((BOOLEAN)TRUE),((unsigned long)z))
        #define _fstrncpy(x,y,z)        (char far *)CCopy_MDbgAlloc(((char far *)(x)),((const char far *)(y)),((int)'\0'),((unsigned long)z))
        #define _fstrnicmp(x,y,z)       (int)ICompare_MDbgAlloc(((const char far *)(x)),((const char far *)(y)),((BOOLEAN)TRUE),((unsigned long)z))
        #define _fstrnset(x,c,z)        (char far *)Set_MDbgAlloc(((char far *)(x)),((int)c),((BOOLEAN)TRUE),((unsigned long)z))
        #define _fstrset(x,c)           (char far *)Set_MDbgAlloc(((char far *)(x)),((int)c),((BOOLEAN)TRUE),((unsigned long)strlen(x)))
        #define _fstrupr(x)             (char far *)Change_MDbgAlloc(((char far *)(x)),((BOOLEAN)FALSE),((unsigned long)strlen(x)))

    #endif


    #define Len_MDbgAlloc(x)            (unsigned long)_mdbgalloc_length_(((const void far *)(x)),__FILE__,__LINE__)
    #define MDbgAlloc(x)                (void far *)_mdbgalloc_(((unsigned long)x),__FILE__,__LINE__)
    #define Free_MDbgAlloc(x)           (void far)  _mdbgalloc_free_(((void far *)&(x)),__FILE__,__LINE__)
    #define MDbgReAlloc(x,y)            (void far *)_mdbgalloc_resize_(((void far *)(x)),((unsigned long)y),__FILE__,__LINE__)
    #define CMDbgAlloc(x,y)             (void far *)_mdbgalloc_nelements_(((unsigned long)x),((unsigned long)y), \
                                                __FILE__,__LINE__)

    #define Copy_MDbgAlloc(x,y,z)       (void far *)_mdbgalloc_ccopy_(((void far *)(x)),((const void far *)(y)),((int)0), \
                                                FALSE,((unsigned long)z),__FILE__,__LINE__)

    #define CCopy_MDbgAlloc(x,y,c,z)    (void far *)_mdbgalloc_ccopy_(((void far *)(x)),((void far *)(y)),((int)c),TRUE, \
                                                ((unsigned long)z),__FILE__,__LINE__)

    #define CCat_MDbgAlloc(x,y,c,z)     (void far *)_mdbgalloc_ccat_(((void far *)(x)),((void far *)(y)),((int)c),TRUE, \
                                                ((unsigned long)z),__FILE__,__LINE__)

    #define Compare_MDbgAlloc(x,y,s,z)  (int far)_mdbgalloc_icompare_(((void far *)(x)),((void far *)(y)),FALSE,((BOOLEAN)(s)), \
                                                ((unsigned long)z),__FILE__,__LINE__)

    #define ICompare_MDbgAlloc(x,y,s,z) (int far)_mdbgalloc_icompare_(((void far *)(x)),((void far *)(y)),TRUE,((BOOLEAN)(s)), \
                                                ((unsigned long)z),__FILE__,__LINE__)

    #define Set_MDbgAlloc(x,c,s,z)      (void far *)_mdbgalloc_set_(((void far *)(x)),((int)c),((BOOLEAN)(s)), \
                                                ((unsigned long)z),__FILE__,__LINE__)

    #define SrchCh_MDbgAlloc(x,c,z)     (void far *)_mdbgalloc_ichsearch_(((void far *)(x)),((int)c), FALSE, \
                                                ((unsigned long)z), __FILE__, __LINE__ )

    #define Duplicate_MDbgAlloc(x,z)    (void far *)_mdbgalloc_cduplicate_(((void far *)(x)),((int)0),FALSE, \
                                                ((unsigned long)z),__FILE__,__LINE__)

    #define CDuplicate_MDbgAlloc(x,c,z) (void far *)_mdbgalloc_cduplicate_(((void far *)(x)),((int)c),TRUE, \
                                                ((unsigned long)z),__FILE__,__LINE__)

    #define Change_MDbgAlloc(x,l,z)     (void far *)_mdbgalloc_change_(((void far *)(x)),((BOOLEAN)l), \
                                                ((unsigned long)z),__FILE__,__LINE__)

    #ifdef __cplusplus
        extern "C" {
    #endif
    unsigned long  _mdbgalloc_length_( const void far *srcc, char *module, int line );

    void far      *_mdbgalloc_( unsigned long nbytes, char *module, int line );

    void far      *_mdbgalloc_nelements_( unsigned long nele, unsigned long nbytes, char *module, int line );

    void far      *_mdbgalloc_resize_( void far *rptr, unsigned long nbytes, char *module, int line );

    void           _mdbgalloc_free_( void far **ptr, char *module, int line );

    void far      *_mdbgalloc_ccopy_( void far *dest, const void far *src, int ch, BOOLEAN chkch,
                                 unsigned long nbytes, char *module, int line );

    int  far       _mdbgalloc_icompare_( const void far *mem1, const void far *mem2, BOOLEAN igncase,BOOLEAN string,
                                 unsigned long nbytes,char *module,int line);

    void far      *_mdbgalloc_set_( void far *src, int ch, BOOLEAN string, \
                                 unsigned long nbytes, char *module, int line );

    void far      *_mdbgalloc_ichsearch_( const void far *src, int ch, BOOLEAN igncase, \
                                 unsigned long nbytes, char *module, int line );

    void far      *_mdbgalloc_ccat_( void far *dest, const void far *src, int ch, BOOLEAN chkch, \
                                 unsigned long nbytes, char *module, int line );

    void far      *_mdbgalloc_cduplicate_( const void far *src, int ch, BOOLEAN chkch, \
                                 unsigned long nbytes, char *module, int line );

    void far      *_mdbgalloc_change_( void far *src, BOOLEAN lower, \
                                 unsigned long nbytes, char *module, int line );
    #ifdef __cplusplus
        }
    #endif

#endif

