//*                               MDATES.H                                 *
//*                                                                        *
//*     C++ Date Class for Various Date Oriented Routines                  *
//*                                                                        *
//*    Written By   : Matthew Rhoades                                      *
//*    Last Update  : February, 1994                                       *
//*                                                                        *
//**************************************************************************

#ifndef MDATES_H
#define MDATES_H

#include <stdlib.h>
#include <string.h>

//*****************************************************************
//*                     GENERAL DEFINES                           *
//*****************************************************************


#define STANDARD     100            //  Standard is MM/DD/YY
#define MMDDYY       200            //
#define YYMMDD       300            //
#define SLASH        0x2F           //  '/'
#define SPACE        0x20           //  ' '


//*****************************************************************
//*                     CLASS DEFINITION                          *
//*****************************************************************

class MDates
{
public:

    int test, Day, Month, Year;
    long Julian, NewDate, lTestDate, Lowdate, Highdate, Days;
    char *cDay, *cMonth, *cYear, *cChk, *cTestDate, *Buffer;

MDates();
~MDates();
void SystemDate(char *date);                    // returns CCYYMMDD Format
void PrintDate(char *date);                     // returns MMM DD, YYYY
long SubMonths(long date, int x);               // returns CCYYMMDD Long
long SubDays(long date, int x);                 // returns CCYYMMDD Long
long Date2Long(char *date);                     // CCYYMMDD Format
int  Date2String(long date, char *newdate);     // pass CCYYMMDD Format
int  DaysBetween(char *dateone, char *datetwo); // CCYYMMDD Format
void DateFormat(char *dt, char *result, int format);
void InitDate(char *dt, char *result, int format);
int  IsValidDate( char *s );                    // pass CCYYMMDD Format

long Date2Julian(char *date);                   // CCYYMMDD Format
long Julian2Long(long Julian);                  // CCYYMMDD Format returned
void Julian2String(long Julian, char *string);  // returns CCYYMMDD Format
long DMYtoJulian(int Day, int Month, int Year); // Low Level Julian Converter
int  Valid_Date( char *s );                     // MMDDYY Format (Low Level)
};

#endif
