//*                               MDATES.CPP                               *
//*                                                                        *
//*     C++ Date Class for Various Date Oriented Routines                  *
//*                                                                        *
//*    Written By   : Matthew Rhoades                                      *
//*    Last Update  : February, 1994                                       *
//*                                                                        *
//**************************************************************************
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <dos.h>
#include <string.h>
#include <iostream.h>
#include <alloc.h>
#include <process.h>
#include "mdates.h"


//**************************************************************************
//                        MDates Constructor                               *
//**************************************************************************
MDates::MDates()
{
     Day        =  0;                  //  Initialize the
     Month      =  0;                  //  Class Variables
     Year       =  0;
     Julian     =  0;
     NewDate    =  0;
     lTestDate  =  0;
     Lowdate    =  0;
     Highdate   =  0;
     Days       =  0;
     cDay       = new char[3];
     cMonth     = new char[3];
     cYear      = new char[3];
     cChk       = new char[9];
     cTestDate  = new char[9];
     Buffer     = new char[35];

     memset(cDay, '\0', 3);
     memset(cMonth, '\0', 3);
     memset(cYear, '\0', 3);
     memset(cChk, '\0', 9);
     memset(cTestDate, '\0', 9);
     memset(Buffer, '\0', 35);
}

//**************************************************************************
//                        MDates Destructor                                *
//**************************************************************************
MDates::~MDates()
{
   if(cDay)       delete cDay;               // Destroy the
   if(cMonth)     delete cMonth;             // Class Variables
   if(cYear)      delete cYear;              // Freeing Memory
   if(cChk)       delete cChk;
   if(cTestDate)  delete cTestDate;
   if(Buffer)     delete Buffer;
}

//**************************************************************************
//                        DateFormat Function                              *
//                                                                         *
//   Pass it  : char * CCYYMMDD                                            *
//   Support formats are:                                                  *
//                           STANDARD   :  MM/DD/YY                        *
//                           MMDDYY     :  same                            *
//                           YYMMDD     :  same                            *
//                                                                         *
//    EX:   DateFormat( "19940101", result, STANDARD);                     *
//          result  = 01/01/94                                             *
//**************************************************************************
void MDates::DateFormat(char *dt, char *result, int format)
{
    cYear[0]  = dt[2];  cYear[1]  = dt[3];  cYear[2]  = '\0';
    cMonth[0] = dt[4];  cMonth[1] = dt[5];  cMonth[2] = '\0';
    cDay[0]   = dt[6];  cDay[1]   = dt[7];  cDay[2]   = '\0';

    memset( result, '\0', sizeof(result));

    switch(format)
    {
        case STANDARD :
             {
                  result[0] = cMonth[0];
                  result[1] = cMonth[1];
                  result[2] = SLASH;
                  result[3] = cDay[0];
                  result[4] = cDay[1];
                  result[5] = SLASH;
                  result[6] = cYear[0];
                  result[7] = cYear[1];
                  result[8] = '\0';
                  break;
             }
        case MMDDYY:
             {
                  result[0] = cMonth[0];
                  result[1] = cMonth[1];
                  result[2] = cDay[0];
                  result[3] = cDay[1];
                  result[4] = cYear[0];
                  result[5] = cYear[1];
                  result[6] = '\0';
                  break;
             }
        case YYMMDD:
             {
                  result[0] = cYear[0];
                  result[1] = cYear[1];
                  result[2] = cMonth[0];
                  result[3] = cMonth[1];
                  result[4] = cDay[0];
                  result[5] = cDay[1];
                  result[6] = '\0';
                  break;
             }
    }
}

//**************************************************************************
//                        InitDate Function                                *
//                  (Opposite of DateFormat Function)                      *
//                                                                         *
//   Pass it  : STANDARD, MMDDYY, YYMMDD                                   *
//   Support formats are:                                                  *
//                           STANDARD   :  MM/DD/YY                        *
//                           MMDDYY     :  same                            *
//                           YYMMDD     :  same                            *
//                                                                         *
//    EX:   DateFormat( "01/01/94", result, STANDARD);                     *
//          result = "19940101"                                            *
//**************************************************************************
void MDates::InitDate(char *dt, char *result, int format)
{
    memset( result, '\0', sizeof(result));

    switch(format)
    {
        case STANDARD :
             {
                 cYear[0]  = dt[6];  cYear[1]  = dt[7];  cYear[2]  = '\0';
                 cMonth[0] = dt[0];  cMonth[1] = dt[1];  cMonth[2] = '\0';
                 cDay[0]   = dt[3];  cDay[1]   = dt[4];  cDay[2]   = '\0';

                 result[0]  = '1';
                 result[1]  = '9';
                 result[2]  = cYear[0];
                 result[3]  = cYear[1];
                 result[4]  = cMonth[0];
                 result[5]  = cMonth[1];
                 result[6]  = cDay[0];
                 result[7]  = cDay[1];
                 result[8]  = '\0';
                 break;
             }
        case MMDDYY:
             {
                 cYear[0]  = dt[4];  cYear[1]  = dt[5];  cYear[2]  = '\0';
                 cMonth[0] = dt[0];  cMonth[1] = dt[1];  cMonth[2] = '\0';
                 cDay[0]   = dt[2];  cDay[1]   = dt[3];  cDay[2]   = '\0';

                 result[0]  = '1';
                 result[1]  = '9';
                 result[2]  = cYear[0];
                 result[3]  = cYear[1];
                 result[4]  = cMonth[0];
                 result[5]  = cMonth[1];
                 result[6]  = cDay[0];
                 result[7]  = cDay[1];
                 result[8]  = '\0';
                 break;
             }
        case YYMMDD:
             {
                 cYear[0]  = dt[0];  cYear[1]  = dt[1];  cYear[2]  = '\0';
                 cMonth[0] = dt[2];  cMonth[1] = dt[3];  cMonth[2] = '\0';
                 cDay[0]   = dt[4];  cDay[1]   = dt[5];  cDay[2]   = '\0';

                 result[0]  = '1';
                 result[1]  = '9';
                 result[2]  = cYear[0];
                 result[3]  = cYear[1];
                 result[4]  = cMonth[0];
                 result[5]  = cMonth[1];
                 result[6]  = cDay[0];
                 result[7]  = cDay[1];
                 result[8]  = '\0';
                 break;
             }
    }
}

//**************************************************************************
//                          Date2Long Function                             *
//**************************************************************************
long MDates::Date2Long(char *date)            // Date must be in CCYYMMDD
{                                             // Format
    DateFormat( date, cChk, MMDDYY);

    if ( !Valid_Date(cChk) )
    {
	return(-1);
    }

return( atol(date) );
}

//**************************************************************************
//                          Date2String Function                           *
//**************************************************************************
int MDates::Date2String(long date, char *newdate)  // Date must be in CCYYMMDD
{                                                  // Format
    ltoa( date, Buffer, 10);
    DateFormat(Buffer, cChk, MMDDYY);

    if( !Valid_Date( cChk ) )
          return -256;

    strcpy(newdate, Buffer);
return 1;
}


//**************************************************************************
//                        Date2Julian Function                             *
//**************************************************************************
long MDates::Date2Julian(char *date)            // Date must be in YYYYMMDD
{                                               // Format
    cDay[0]   = date[6];
    cDay[1]   = date[7];       // Parse the date
    cDay[2]   = '\0';
    cMonth[0] = date[4];
    cMonth[1] = date[5];
    cMonth[2] = '\0';
    cYear[0]  = date[2];
    cYear[1]  = date[3];
    cYear[2]  = '\0';

    Day   = atoi(cDay);
    Month = atoi(cMonth);
    Year  = atoi(cYear);


return( DMYtoJulian( Day, Month, Year ) );
}

//**************************************************************************
//                DMYtoJulian Function -  Low Level                        *
//**************************************************************************
long MDates::DMYtoJulian( int day, int month, int year )
{
   int a, b;
   float year_corr;

   itoa(year, Buffer, 10);
   if(year < 10)
   {
      cYear[0] = '0';
      cYear[1] = Buffer[0];
      cYear[2] = '\0';
   }
   else { strcpy(cYear, Buffer); }
     itoa(month, Buffer, 10);
     if(month < 10)
     {
        cMonth[0] = '0';
        cMonth[1] = Buffer[0];
        cMonth[2] = '\0';
     }
     else { strcpy(cMonth, Buffer); }
       itoa(day, Buffer, 10);
       if(day < 10)
       {
          cDay[0] = '0';
          cDay[1] = Buffer[0];
          cDay[2] = '\0';
       }
       else { strcpy(cDay, Buffer); }

    Buffer[0] =  '\0';
    strcpy(Buffer, cMonth);
    strcat(Buffer, cDay);
    strcat(Buffer, cYear);

       if( !Valid_Date( Buffer ) )
             return -1;

        year_corr = (year > 0 ? 0.0 : 0.75 );
        if(month <= 2)
        {
           year--;
           month += 12;
        }

   b = 0;

   if( year * 10000.0 + month * 100.0 + day >= 15821015.0 )
   {
      a = year / 100;
      b = (2 - a) + (a / 4);
   }

   Julian = (long) (365.25 * year - year_corr) + (long)(30.6001 * (month + 1)) +
            day + 1720994L + b;

return( Julian );
}

//**************************************************************************
//                      Julian2String Function
//**************************************************************************
void MDates::Julian2String(long Julian, char *string)
{
   NewDate = Julian2Long( Julian );         // returns CCYYMMDD Format char*
   ltoa(NewDate, Buffer, 10);
   strcpy(string, Buffer);
}


//**************************************************************************
//                        Julian2Long Function
//**************************************************************************
long MDates::Julian2Long(long Julian)
{
   long a, b, c, d, e, z, alpha;
                                        // returns CCYYMMDD Format long
    z = Julian + 1;

     if(z < 2299161L)
        a = z;
     else
     {
        alpha = (long) ((z - 1867216.25) / 36524.25);
        a = z + 1 + alpha - (alpha / 4);
     }

   b = a + 1524;
   c = (long) ((b - 122.1) / 365.25);
   d = (long) ( 365.25 * c );
   e = (long) (( b - d) / 30.6001);

   Day     = (int) b - d - (long)(30.6001 * e);
   Month   = (int) (e < 13.5) ? e - 1 : e - 13;
   Year    = (int) (Month > 2.5) ? (c - 4716) : c - 4715;

   memset( cTestDate, '\0', sizeof(cTestDate));
   cTestDate[0] = '1';
   cTestDate[1] = '9';
   itoa(Year, Buffer, 10);
   if(Year < 10)
   {
      cTestDate[2] = '0';
      cTestDate[3] = Buffer[0];
   }
   else { strcat(cTestDate, Buffer); }
     itoa(Month, Buffer, 10);
     if(Month < 10)
     {
        cTestDate[4] = '0';
        cTestDate[5] = Buffer[0];
     }
     else { strcat(cTestDate, Buffer); }
       itoa(Day, Buffer, 10);
       if(Day < 10)
       {
          cTestDate[6] = '0';
          cTestDate[7] = Buffer[0];
       }
       else { strcat(cTestDate, Buffer); }
       cTestDate[8] = '\0';

   NewDate = atol(cTestDate);

return(NewDate);
}

//**************************************************************************
//          IsValidDate Function  --  Checks Date Validity
//**************************************************************************
int MDates::IsValidDate( char *s )     // CCYYMMDD Format
{
    DateFormat(s, cTestDate, MMDDYY);
    test = Valid_Date( cTestDate );
    if(test)
    {
        return 1;
    }
    else
       {
           return -1;
       }
}

//**************************************************************************
//                        Valid_Date Function
//
//   I Didn't write this function.... Downloaded it from Compuserve.....
//   So I give the author full credit for this function....
//
//**************************************************************************
int MDates::Valid_Date( char *s )     // MMDDYY Format
{
    int days[] = { 31,28,31,30,31,30,31,31,30,31,30,31 };
    char date[7];
    int mo;
    int da;
    int yr;
    int eo;

    strcpy(date, s);
    if (date == NULL)
            return 1;

    yr = atoi(date + 5);
    *(date + 5) = '\0';
    eo = atoi(date + 4);
    if (eo == 0 || eo == 2 || eo == 6 || eo == 8)
    {
            if (yr == 0 || yr == 4 || yr == 8)
                    days[1]++;
    }
    if (eo == 1 || eo == 3 || eo == 5 || eo == 7 || eo == 9)
    {
            if (yr == 2 || yr == 6)
                    days[1]++;
    }

    *(date + 4) = '\0';
    da = atoi(date + 2);
    *(date + 2) = '\0';
    mo = atoi(date);

    if (mo && mo < 13 && da && da <= days [mo - 1])
            return 1;

return 0;
}

//**************************************************************************
//        DaysBetween Function   --  Computes the Days Between Two Dates
//**************************************************************************
int MDates::DaysBetween(char *dateone, char *datetwo)
{
        Lowdate  = Date2Julian(dateone);
        Highdate = Date2Julian(datetwo);

        if((Lowdate <= 0) || (Highdate <= 0))
        {
            return -1;    // One or Both dates invalid!
        }

       Days = Highdate - Lowdate;

return( abs(Days) );
}

//******************************************************************
//*****  Date Function for getting Sys Date   **********************
//******************************************************************
void MDates::SystemDate(char *date)
{
   char TYear[5];                    //  returns CCYYMMDD char *

   struct dosdate_t dt;
   _dos_getdate(&dt);

   itoa(dt.day, Buffer, 10);
   if(dt.day < 10)
   {
      cDay[0] = '0';
      cDay[1] = Buffer[0];
      cDay[2] = '\0';
   }
   else { strcpy(cDay, Buffer); }
     itoa(dt.month, Buffer, 10);
     if(dt.month < 10)
     {
        cMonth[0] = '0';
        cMonth[1] = Buffer[0];
        cMonth[2] = '\0';
     }
     else { strcpy(cMonth, Buffer); }

     itoa(dt.year, Buffer, 10);
     strcpy(TYear, Buffer);

     strcpy(date, TYear);
     date[4] = cMonth[0];
     date[5] = cMonth[1];
     date[6] = cDay[0];
     date[7] = cDay[1];
     date[8] = '\0';
}

//***************************************************************************
//   PrintDate Function For Getting Formatted Date for Reports and Output   *
//***************************************************************************
void MDates::PrintDate(char *date)
{
   char day[3];                             // This Function gets the system
   char year[5];                            // Date and returns it in char *
   char month[4];                           // form... i.e.  PrintDate();
                                            // returns ->  Mar 5, 1994
   const char *months[12] =
   {
     "Jan", "Feb", "Mar", "Apr", "May", "Jun",
     "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
   };

      struct dosdate_t dt;
      _dos_getdate(&dt);

      itoa(dt.day, day, 10);
      itoa(dt.year, year, 10);
      strcpy(date,months[dt.month - 1]);
      strcat(date, " ");
      strcat(date, day);
      strcat(date, ", ");
      strcat(date, year);
}



//****************************************************************************
//***** The Function to Subtract x Months from a Given Date  *****************
//****************************************************************************
long MDates::SubMonths(long date, int x)
{
    int nMonth;                    //  new month
    int nYear;                     //  new year
    int nDay;                      //  new day

    memset( cChk, '\0', sizeof(cChk));
    memset( cTestDate, '\0', sizeof(cTestDate));

    ltoa (date, Buffer, 10);     //  Convert date to String

    cYear [0] = Buffer [2];      //  Parse out d,m,y from string into
    cYear [1] = Buffer [3];      //  sub strings...
    cYear [2] = '\0';
    cMonth [0] = Buffer [4];
    cMonth [1] = Buffer [5];
    cMonth [2] = '\0';
    cDay [0] = Buffer [6];
    cDay [1] = Buffer [7];
    cDay [2] = '\0';

    Year = atoi (cYear);           // Convert substrings to integers
    Month = atoi (cMonth);         // for mathematical computations...
    Day = atoi (cDay);

    nMonth = Month - x;            // Subtract x Months from Month;

    if (nMonth < 1)                // if new month is less than 1
    {                              //
        nMonth += 12;              // add 12 to new month
        Year = Year--;             // subtract one from the year
    }

    cTestDate[0] = '1';            // Build the cTestDate Var
    cTestDate[1] = '9';            // to check for Date Validity
    itoa (Year, Buffer, 10);
     if(Year < 10)
     {
        cTestDate[2] = '0';
        cTestDate[3] = Buffer[0];
        cTestDate[4] = '\0';
     }
     else { strcat(cTestDate, Buffer); }
     itoa (nMonth, Buffer,10);
     if(nMonth < 10)
     {
        cTestDate[4] = '0';
        cTestDate[5] = Buffer[0];
        cTestDate[6] = '\0';
     }
     else { strcat(cTestDate, Buffer); }
     itoa (Day, Buffer, 10);
       if(Day < 10)
       {
           cTestDate[6] = '0';
           cTestDate[7] = Buffer[0];
       }
       else { strcat(cTestDate, Buffer); }
       cTestDate[8] = '\0';

    DateFormat(cTestDate, cChk, MMDDYY);

    while( !Valid_Date(cChk) )  // Test for date validity
    {
        cDay [0] = cTestDate [6];       // Get the Day of the month
        cDay [1] = cTestDate [7];       // and Subtract one
        cDay [2] = '\0';
        Day = atoi (cDay);
        Day--;

        itoa (Day, Buffer, 10);      // must use the larger Buffer
                                        // var. for conversions, or
                                        // you have memory problems
        if (Day < 10)
        {
            cTestDate [6] = '0';
            cTestDate [7] = Buffer [0];
            cTestDate [8] = '\0';
        }
        else
        {
            cTestDate [6] = Buffer [0];         // Put the day back into
            cTestDate [7] = Buffer [1];         // cTestDate....
            cTestDate [8] = '\0';
        }
      DateFormat(cTestDate, cChk, MMDDYY);        // Format cChk and loop
    }                                             // to retest date

    NewDate = atol (cTestDate);         // Convert to Long and return

    return (NewDate);
}


//****************************************************************************
//***** The Function to Subtract x Days from a Given Date  *******************
//****************************************************************************
long MDates::SubDays(long date, int x)
{
    memset( cChk, '\0', sizeof(cChk));
    memset( cTestDate, '\0', sizeof(cTestDate));
    ltoa( date, Buffer, 10);

    lTestDate = Date2Julian( Buffer );
    lTestDate = lTestDate - x;

    Julian2String( lTestDate, cTestDate );
    DateFormat( cTestDate, cChk, MMDDYY);

    while( !Valid_Date(cChk) )  // Test for date validity
    {
        lTestDate--;
        Julian2String( lTestDate, cTestDate );
        DateFormat( cTestDate, cChk, MMDDYY);
    }

    NewDate = atol( cTestDate );

return( NewDate );
}

