// Original YAMP test driver

// Version: 2.0
// Author: Mark Von Tress, Ph.D.
// Date: 09/17/94

// Copyright(c) Mark Von Tress 1994


// DISCLAIMER: THIS PROGRAM IS PROVIDED AS IS, WITHOUT ANY
// WARRANTY, EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO FITNESS FOR A PARTICULAR PURPOSE. THE AUTHOR DISCLAIMS
// ALL LIABILITY FOR DIRECT OR CONSEQUENTIAL DAMAGES RESULTING
// FROM USE OF THIS PROGRAM.


#include "matv.h"


Matrix function1(Matrix &a, Matrix &b)
{
	 // This function tests the freind functions and returns a value

	 a.Garbage("function1"); 	// check a and b
	 b.Garbage("function1");

	 Matrix c( 1, 1); 	// create a local matrix

	 c = a + b + a + b; 	// check a repeated matrix addition
	 c.show(); 	// print c
	 c = 431.2 + Tran(a) *b + 2.134; 	// check commutivity of scalar addition
	 c.show(); 	// print c
	 c = -c; 	        // check uniary minus
	 c.show(); 	// print c
	 c = a - b; 	        // matrix subraction
	 c.show(); 	// print c
	 c = 5 - a - 5; 	// check commutivity of scalar subtraction
	 c.show(); 	// print c
	 c = 5*a*5; 	        // check commutivity of scalar multiplication
	 c.show(); 	// print c
	 c = a % a; 	        // check elementwise multiplication
	 c.show(); 	// print c
	c = a / 1234; 	    // check scalar division
	c.show(); 	// print c
	c = a / b; 	        // check elementwise division
	c.show(); 	// print c

	return c;
}

Matrix function0(void)
{
	// test some of the output functions and raw matrix functions

	Matrix d = Matrix( 1, 1);
	Matrix a, c, H, hilb;

	a = Reada("catchv.dat"); 	// read an ascii matrix
	a.show(); 	        // display a
	Writea("junk.dat", a); 	    // write ascii matrix
	a.show(); 	        // display a
	d = Submat(a, 1, 2, a.r, 4); 	// take a submatrix of a
	d.show(); 	        // display it
	c = Ch(d, d); 	            // horizontal concatenation
	c.show();
	c = Cv(d, d); 	            // vertical contatenation
	c.show();
	c = Kron(Ident(3), d); 	    // Kroniker's product
	Setdec(1); 	                // set number of decimals to print
	Setwid(5); 	                // set print width
	c.show();
	H = Helm(4); 	            // make a helmert matrix
	H.show(); 	        // show() that it is orthonormal
	d = Tran(H) *H;
	d.show();
	d = H*Tran(H);
	d.show();

	a = Ident(4) + Fill(4, 4, 0.5); 	// redefine a
	a.show(); 	                // print a
	c = Tran(Helm(4)) *a*H; 	        // diagonalize a
	c.show(); 	                // display c
	c = Inv(a); 	                    // invert a
	c.show(); 	                // display c
	Matrix b; 	                        // create b
	b = c*a; 	                        // redefine b
	b.show();  	                // display b
	c = function1(a, a); 	            // call a function
	c.show(); 	                // display c
	return c;
}

Matrix regression(void) 	// do a multiple linear regression
{
	Matrix a, xy, reg;
	a = Reada("catchv.dat"); 	            // read data
	Matrix b = Matrix(a.r, a.c); 	//simplify indexes
	int N = a.r; 	                        // N
	int p = 3; 	                            // params
	xy = Ch(Fill(N, 1, 1), Submat(a, 1, 2, N, 4 )); 	// make x y
	reg = Sweep(1, p, Tran(xy) *xy); 	    // solve regression
											// using sweep
	reg(p + 1, p + 1) = reg(p + 1, p + 1) / ((double) (N - p));
	// divide to get mse

	Matrix x = Submat(xy, 1, 1, N, 3);
	Matrix y = Submat(xy, 1, 4, N, 4);
	Matrix betahat = Inv(Tran(x) *x) *Tran(x) *y;
											//solve regression using
											//normal equations
	betahat.show();
	reg.show();
	return reg;
}

void altermatrix(Matrix &t) 	// alter a matrix element
{
	t(1, 1) = 2525.0;
	Matrix temp = MSort(t, 1);
	temp.show();
}

void testhuge(void)
{
		cout <<  "Making a big matrix \n";
		Matrix VeryBig = Helm(300);
		cout << "finished allocating a 300x300: "
			  << VeryBig.r << " " << VeryBig.c << endl;
		for( int i=1; i<=VeryBig.r; i++) cout << VeryBig(i,1) << " ";
		cout << endl;
}

void version1p1(void)
{
	//
	// testreg.cpp for test of regression functions.
	//
	Matrix A = Fill(6, 6, 1.0);
	Matrix B = Fill(6, 1, 2.0);

	(Vec(A)).show();
	(Vecdiag(A)).show();
	(Diag(B)).show();
	(Shape(A, 3)).show();
	(Sum(A, ROWS)).show();
	(Sumsq(A, COLUMNS)).show();
	(Cusum(A)).show();
	(Mmin(B)).show();
	(Mmax(B, ROWS)).show();

	Matrix C = Ch(A, Diag(B));
	Setwid(5);
	Setdec(2);
	C.show();
	Crow(C, 1, 0.6);
	C.show();
	Srow(C, 1, 6);
	C.show();
	Lrow(C, 2, 3,.5);
	C.show();
	Ccol(C, 1, 0.6);
	C.show();
	Scol(C, 1, 6);
	C.show();
	Lcol(C, 2, 3,.5);
	C.show();
}

main()
{
		 // ios::sync_with_stdio();
	Matrix testit;

	printf("%d\n", sizeof (testit));

	testit = regression();
	testit.show();

	Matrix b = testit;
	Matrix a = 2*testit;

	Matrix c = a + b + a + b;
	c.show();

	Matrix t = function0() + function0();
	t.show();

	altermatrix(testit);
	testit.show();

	version1p1();


#ifdef USE_EXTENDER
	testhuge();
#endif
	return 0;
}
