/*
  Quick directory maintenance program.
  Written by Jeffrey C. Moxon  CIS:  73561, 14331
  Aristech Chemical Corporation

  Designed for quick clean-up of unwanted files from directories.
  Can be fairly dangerous if used improperly.


  Compile in Huge model.
*/

#include <alloc.h>
#include <conio.h>
#include <ctype.h>
#include <dir.h>
#include <direct.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define UP              72
#define CTRL_PGUP       0x84
#define CTRL_PGDN       0x76
#define DOWN            80
#define HOME            71
#define END             79
#define INS             82
#define DEL             83
#define PGUP            73
#define PGDN            81
#define ENTER           '\r'
#define ESC             0x1B
#define ALT_D           0x20
#define ALT_U           0x16

#define MARKED          0x40

//extern unsigned _stklen = 0x4000;

struct ffblk huge *block;
int num_files = 0, sort = 0;
char far *vid_mem = MK_FP(0xB800, 0);
char search[80];

union key_val
            {
             char ch[2];
             int i;
            };

int sort_function(const void *a, const void *b);
void re_load(void);
void menu(char far *path);
void draw_border(int x1, int y1, int x2, int y2, int attrib, char *path);
int readkey(void);
void update_bar(int pos);

void main(int argc, char *argv[])
{
 char cur_dir[80];
 int complete = 0;
 struct ffblk c_block;
 int x, y;


 strupr(argv[1]);

 if (strcmp(argv[1], "__JCM__") == 0)
 {
  printf("\nTime:  %s\nDate:  %s\nFile:  %s\n", __TIME__, __DATE__, __FILE__);
  return;
 }

 if (strcmp(argv[1], "-H") == 0)
 {
  printf("Usage:\n-h display this screen\n-d sort by date\n-s sort by size\nExample:\nCLEAN -d c:\\dos");
  return;
 }

 if (strcmp(argv[1], "-D") == 0) sort = 1;
 if (strcmp(argv[1], "-S") == 0) sort = 2;

 _setcursortype(_NOCURSOR);

 printf("\nMemory available:  %ld bytes\n", farcoreleft());
 printf("Maximum number of files:  %i\n", (int)(farcoreleft()/sizeof(struct ffblk)));

 getcwd(cur_dir, 80);

 if ((argc == 2 && sort == 0) || (argc > 2 && sort != 0))
 {
   argc--;
  _chdrive(argv[argc][0] - 'A' + 1);
  chdir(argv[argc]);
  strcpy(search, argv[argc]);
 }
 else
  strcpy(search, cur_dir);

 strcat(search, "\\*.*\0");

 printf("Counting files...\nTotal files:     %04i", 0);

 complete = findfirst(search, &c_block, FA_NORMAL);

 while(1)
 {
  complete = findnext(&c_block);
  if (complete)break;

  num_files++;
 // if (num_files == 1476) break;

  x = wherex();
  y = wherey();
  gotoxy(x - 4, y);
  printf("%04i", num_files);
  delay(5);
 }

 if (num_files > 1475)
 {
  printf("\n\nCannot sort more than 1475 files.\nPress any key...");
  getch();
 }

 if (num_files == 0)
 {
  printf("\nNo files found.\n");
  goto done;
 }

 block = farcalloc(num_files, sizeof(struct ffblk));

 if (block == NULL)
 {
  printf("\nInsufficient memory.\n");
  goto done;
 }

 printf("\nLoading files...");

 printf("\nSorting...");

 re_load();

 printf("\n");

 menu(strupr(search));

 window(1, 1, 80, 25);
 clrscr();

 done:
 if (block != NULL) farfree(block);

 _chdrive(cur_dir[0] - 'A' + 1);
 chdir(cur_dir);
 _setcursortype(_NORMALCURSOR);

 textattr(7);

 printf("\n\nUsage:\n-h display this screen\n-d sort by date\n-s sort by size\nExample:\nCLEAN -d c:\\dos");

 printf("\n\n");
return;
}

void re_load(void)
{
 int complete;
 struct ffblk c_block;

 complete = num_files = 0;
 complete = findfirst(search, &c_block, FA_NORMAL);

 while(!complete)
 {
  complete = findnext(&c_block);
  if (!complete)
  block[num_files++] = c_block;
 }

 if (num_files < 1475)
  qsort((void huge *)block, num_files, sizeof(struct ffblk), sort_function);

return;
}

int sort_function(const void *a, const void *b)
{
 struct ffblk huge *ptra, huge *ptrb;
 int ret_val;

 ptra = (struct ffblk *)a;
 ptrb = (struct ffblk *)b;

 switch(sort)
 {
  case 0:
   ret_val = strcmp((char *)ptra->ff_name,(char *)ptrb->ff_name);
  break;
  case 1:
   if (ptra->ff_fdate > ptrb->ff_fdate) ret_val = 1;
   if (ptra->ff_fdate == ptrb->ff_fdate)
   {
    if (ptra->ff_ftime >= ptrb->ff_ftime) ret_val = 1;
    else ret_val = -1;
   }
   if (ptra->ff_fdate < ptrb->ff_fdate) ret_val = -1;
  break;
  case 2:
   if (ptra->ff_fsize > ptrb->ff_fsize) ret_val = 1;
   if (ptra->ff_fsize == ptrb->ff_fsize) ret_val = 0;
   if (ptra->ff_fsize < ptrb->ff_fsize) ret_val = -1;
  break;
 }

return(ret_val);
}

void menu(char *path)
{
 int row, pos, sel, complete;
 static char   h_buff[77];
 long   f_size;
 int    mon, day, year, hour, min, am = 0;
 union key_val key;
 char   *months[] =
		   {
		    "Jan ", "Feb ",  "Mar ",
		    "Apr ", "May ",  "Jun ",
		    "Jul ", "Aug ",  "Sep ",
		    "Oct ", "Nov ",  "Dec "
		   };
 char  *time_s[] =
		  {
		   " AM",
		   " PM"
		  };

 clrscr();

 textattr(4);
 gotoxy(3, 23);
 cprintf(" M, [Space] or [Enter] (");
 textattr(9);
 cprintf("Mark");
 textattr(4);
 cprintf(")  U or [INS] (");
 textattr(15);
 cprintf("Unmark");
 textattr(4);
 cprintf(")");
 textattr(8);
 cprintf("  GRAY");
 textattr(4);
 cprintf(" - Not backed up.");

 gotoxy(10, 24);
 textattr(15);
 cprintf("Hit ALT-D to delete marked files, and ALT-U to unmark all.");

 textattr(4);
 gotoxy(5, 25);
 cprintf("DEL delete current file,  ESC exit, PGUP, PGDN, Up, Down, Home, End");

 draw_border(6, 0, 71, 21, 9, path);
 directvideo = 1;

 window(8, 2, 71, 21);

 key.i = pos = sel = 0;
 textattr(15);

 while(1)
 {

  for(row = 0;row < ((num_files > 20) ? 20: num_files);row++)
  {
    if (num_files == 0) return;

    h_buff[0] = '\0';
    f_size = block[row + pos].ff_fsize;
    mon = ((block[row + pos].ff_fdate >> 5) & 15) - 1;
    day = (block[row + pos].ff_fdate & 31);
    year = (block[row + pos].ff_fdate >> 9) + 1980;
    hour =  (block[row + pos].ff_ftime >> 11);
    if (hour >= 12)
    {
     if (hour != 12)
     {
      am = 1;
      hour -= 12;
     }
    }
    else am = 0;

    min = ((block[row + pos].ff_ftime >> 5) & 63);

    sprintf(h_buff, "%12s   %10ld bytes    %3s %2i, %4i  %2i:%02i %s",
             block[row + pos].ff_name, (long) f_size,
              months[mon], day, year, hour, min, time_s[am]);

    gotoxy(3, row + 1);

    if (block[row + pos].ff_attrib & MARKED) textattr(9);
    else
    {
     if (block[row + pos].ff_attrib & FA_ARCH) textattr(8);
     else textattr(15);
    }

    if (row == sel) textattr(79);
     if (row + pos != num_files) cprintf(h_buff);
     else
     {
      cprintf("%-59s", "***LAST FILE***");
      row = 20;
     }
    textattr(7);
  }

  update_bar(pos + sel);
  key.i = readkey();

  switch(key.ch[0])
  {
   case 0:
           switch(key.ch[1])
           {
            case DOWN:
             sel++;
            break;
            case UP:
             sel--;
            break;
            case PGDN:
             sel += 20;
            break;
            case PGUP:
             sel -= 20;
            break;
            case HOME: case CTRL_PGUP:
             sel = 0;
             pos = 0;
             clrscr();
            break;
            case INS:
             if (block[sel + pos].ff_attrib & MARKED)
              block[sel + pos].ff_attrib ^= MARKED;
            break;
            case DEL:
             unlink(block[sel + pos].ff_name);
             clrscr();
             re_load();
             draw_border(6, 0, 71, 21, 9, path);
            break;
            case END: case CTRL_PGDN:
             pos = num_files - 19;
             sel = num_files - pos - 1;
             clrscr();
            break;
            case ALT_U:
             for(complete = 0;complete < num_files;complete++)
               if (block[complete].ff_attrib & MARKED)
                  block[complete].ff_attrib ^= MARKED;
            break;
            case ALT_D:
             for(complete = 0; complete < num_files;complete++)
             {
              if (!(block[complete].ff_attrib & FA_ARCH) && (block[complete].ff_attrib & MARKED))
                    unlink(block[complete].ff_name);
             }
             clrscr();
             re_load();
             draw_border(6, 0, 71, 21, 9, path);
            break;
           }
   break;
   case 'm': case 'M': case 32: case '\r':
     block[sel + pos].ff_attrib |= MARKED;
//     clrscr();
     sel++;
   break;
   case 'u': case 'U':
     if (block[sel + pos].ff_attrib & MARKED)
            block[sel + pos].ff_attrib ^= MARKED;
//     clrscr();
     sel++;
   break;
   case ESC:
   return;
   }

   if (sel > 19 || sel > num_files - 1)
   {
    if (num_files > 19)
    {
     sel = 0;
     pos += 19;
    }
    else
     sel = 0;
   }
   if (sel < 0)
   {
    if (num_files > 19)
    {
     sel = 19;
     pos -= 19;
    }
    else
     sel = num_files - 1;
   }

   if (num_files > 19)
   {
    if (pos > num_files - 19) pos = num_files - 19;
    if (pos < 0) pos = num_files - 19;
   }
 }

}

void draw_border(int x1, int y1, int x2, int y2, int attrib, char *path)
{
 register unsigned char ul, ur, ll, lr, hor, vert, x, y;
 register int offset;
 char h_buff[20];

   ul = 201;
   ur = 187;
   ll = 200;
   lr = 188;
   hor =  205;
   vert = 186;


     for(x = x1;x < x2;x++)     // Draw horizontal lines
     {
      offset = y1 * 160 + x + x;
      *(vid_mem + offset) = hor;
      *(vid_mem + offset + 1) = attrib;
      offset = y2 * 160 + x + x;
      *(vid_mem + offset) = hor;
      *(vid_mem + offset + 1) = attrib;
     }
     for(y = y1;y < y2;y++)    // Draw vertical lines
     {
      offset = y * 160;
      *(vid_mem + offset + x1 + x1) = vert;
      *(vid_mem + offset + x1 + x1 + 1) = attrib;
      *(vid_mem + offset + x2 + x2) = vert;
      *(vid_mem + offset + x2 + x2 + 1) = attrib;
     }


     offset = y1 * 160;
     *(vid_mem + offset + x1 + x1) = ul;        /* Draw corners */
     *(vid_mem + offset + x1 + x1 + 1) = attrib;
     *(vid_mem + offset + x2 + x2) = ur;
     *(vid_mem + offset + x2 + x2 + 1) = attrib;
     offset = y2 * 160;
     *(vid_mem + offset + x1 + x1) = ll;
     *(vid_mem + offset + x1 + x1 + 1) = attrib;
     *(vid_mem + offset + x2 + x2) = lr;
     *(vid_mem + offset + x2 + x2 + 1) = attrib;

 window(1, 1, 80, 25);

 sprintf(h_buff, "[Total files:  %i]", num_files);
 gotoxy(69 - strlen(h_buff), 22);
 cprintf(h_buff);

 offset = 40 - strlen(path)/2;

 gotoxy(offset + 1, 1);
 textattr(31);
 cprintf(" %s ", path);

 window(8, 2, 71, 21);

return;
}

int readkey(void)
{
 register int ret_val;

  _asm {
        mov ah, 0
        int 0x16
        mov ret_val, ax
       }

return(ret_val);
}

void update_bar(int pos)
{
 register int i;

 window(1, 1, 80, 25);

 textattr(4);
 gotoxy(72, 2);
 cprintf("%c", 30);
 gotoxy(72, 21);
 cprintf("%c", 31);

 for(i = 3;i < 21;i++)
 {
  gotoxy(72, i);
  cprintf("%c", 176);
 }

 i = 18 * pos/num_files + 3;

 if (pos == num_files - 1) i = 20;

 if (i > 20) i = 20;

 gotoxy(72, i);
 cprintf("%c", 254);

 window(8, 2, 71, 21);

return;
}

