#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <lzw.h>

char infile_pathmask[80] = "*.*";

void main(int argc, char **argv)
{
   char lzw_pathfile[80];
   int i;
   unsigned long options = 0L;

   argc--;
   argv++;
   if (!argc){
     puts("USAGE: lzwin <lzw_pathfile> [infile_pathmask] [-p] ");
     puts("       Where -p = save input path");
     exit(1);
   }
   strcpy(lzw_pathfile,*argv);

   argc--;
   argv++;
   for (i=0 ; i < argc ; i++)
     switch(argv[i][0]){
       case '-': if (tolower(argv[i][1]) == 'p')
		   options |= PATHNAMES;
                 break;
        default: strcpy(infile_pathmask,argv[i]);
     }


   //  LZW INITIALIZATION
   //
   puts("LZW Initialization...");
   lzw_init();


   // COMPRESSION
   //
   puts("Encoding...");
   if (lzw(lzw_pathfile,options,infile_pathmask)){
     puts("Encoding error");
     exit(1);
   }
   puts("End encoding...");

   //  DEINITIALIZATION
   //
   puts("Deinitialization");
   lzw_deinit();

   exit(0);
}
