/*
 *            LVS Windows
 *      The Window Class System
 *
 *        Copyright 1991, 1992 (c), Lake View Software
 *                                  4321 Harborough Rd.
 *                                  Columbus, OH 43220
 *        All rights reserved.
 *
 * DEMO.CPP
 */

#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <dos.h>
#ifdef __TURBOC__
    #include <alloc.h>
#else
    /*
     * Zortech
     */
    #define random(num)     (int)(((long)rand()*(num))/(0x7FFFU + 1))
    #define delay           usleep
    #define coreleft        farcoreleft
#endif
#include <conio.h>
#include <ctype.h>
#include <stdio.h>
#include "LVSwin.HPP"       // LVS Windows main header
#include "LVS_prn.hpp"	    // printer class
#include "LVSmenu.hpp"      // Menu class header file
#include "LVSpick.HPP"

// extern unsigned _stklen = 10000;   // makes no difference.

/*
 * Declare internal functions
 */

int v_socialsecurity(void *num) ;
void rand_open (WinObj &w), show_time (), move_windows (struct time t),
     data_entry (), paradox_entry (), moving_windows (),
     random_windows (), scroll_demo (), scroll_window (),
     menu_demo (), menu_demo2 (), pick_demo (), help (),
     logo ();
void Parse_Command_Line (int argc, char **argv);

/*
 * Some global data
 */
int VGA = 0;                // has vga flag
int Use_VGA = 1;            // try to use vga graphics/colors by default
int mouse_mode = M_FULL;    // Default mouse mode

void main (int argc, char **argv)
{

    Parse_Command_Line (argc, argv);

    // Turn clock on
    Win_setbkloop (show_time);          // Set background keyboard loop
                                        // This will run the clock and move
                                        // the global windows

    Win_setonkey (F1,help);             // Set F1 to function help
	Win_setonkey (F10, Win_Calculator);
	Win_setonkey (F5, Win_Calendar);

    /*
     * If desqview is present this will allow LVS to give time
     * back when waiting for user input
     */
    Win_DesqView_Aware ();

    /*
     * Display the logo & open the main screen
     */
    logo ();

    /*
     * Open the main menu
     */
    WinMenu m;  					                // create Main menu object

    int bkground_color = _RED;

    if (VGA)
        bkground_color = _LBLUE;

    m.open (4, 26, 15, 52, W_DOUSIN, bkground_color|WHITE, 
            bkground_color|BLACK);             // Open the window
	m.shadow ();                               // make a shadow for the window
    m.set_keyattr (bkground_color|YELLOW);     // change the hot key attribute

    bkground_color = _LGREY;
    if (VGA)
        bkground_color = _WHITE;
    m.title (" Demo Menu ");                 // Give the window a title

    /*
     * Define the menu selections
     */
    m.prompt (1, 2, 1, " 1. Data entry       ", "", '1');
    m.prompt (2, 2, 2, " 2. Moving windows   ", "", '2');
    m.prompt (3, 2, 3, " 3. Random windows   ", "", '3');
    m.prompt (4, 2, 4, " 4. Lotus style menu ", "", '4');
    m.prompt (5, 2, 5, " 5. Pick-List demo   ", "", '5');
	m.prompt (6, 2, 6, " 6. Scrolling demo   ", "", '6');
    #ifdef __TURBOC__
        m.prompt (7, 2, 7, " 7. Paradox entry    ", "", '7');
    #else
        m.printf (7, 2, " 7. Paradox entry    ");
    #endif
	m.prompt (8, 2, 0, " 0. Quit             ", "", '0');

    /*
     * Init the mouse driver
     */

    Win_mouse_mode (mouse_mode);

    
    int choice = 1;                 // start with menu selection ret_val = 1

    while (choice != 0) 
        {                           // loop till Quit is selected

        choice = m.read (choice);   // get menu selection from user

        switch (choice) 
            {
            case 1: 
                data_entry ();
                break;
            case 2: 
                moving_windows ();
                break;
            case 3: 
                random_windows ();
                break;
            case 4: 
                m.hide ();
                menu_demo ();
                break;
            case 5: 
                pick_demo ();
                break;
			case 6: 
                scroll_demo ();
				break;
            case 7:
                #ifdef __TURBOC__
                    paradox_entry ();
                #endif
                break;
            }
        }

    // all windows will close automatically with there destructors
}

void Parse_Command_Line (int argc, char **argv)
{
    int arg = 0;

    while (++arg < argc) 
        {
        if (argv[arg][0] == '-' || argv[arg][0] == '/') 
            {
            switch (toupper (argv[arg][1])) 
                {
                case 'B': 
                    Win_bios(W_ON);     // Turn on use of bios writes
                    break;

                case 'S': 
                    Win_snow(W_ON);     // Turn on use of snow suppression
                    break;

                case 'M': 
                    switch (toupper (argv[arg][2]))
                        {
                        case 'N':                 // Mouse off
                            mouse_mode = M_NONE;
                            break;

                        case 'S':                 // Mouse full support
                            mouse_mode = M_SIMPLE;
                            break;

                        default:
                            Win_mono(W_ON);     // Force black & white only
                            break;
                        }
                        break;
                case '5': 
                    VGA_setlines (50);
                    break;
                case '4':
                    VGA_setlines (43);
                    break;
                case '2':
                    VGA_setlines (28);
                    break;
                case 'V':
                    Use_VGA = 0;
                    break;
                }  // switch
            }  // if argv[0]
        }   // while
}

//*********************Pick-List Demo************************

static char *list[] = { "January",   "February",
                        "March",     "April",
                        "May",       "June",
                        "July",      "August",
                        "September", "October",
                        "November",  "December",  0 };

void pick_demo()
{
    WinPick pl;

    int bk = _BLUE;
    if (VGA)
        bk = _DGREY;

    pl.open (3, 33, 9, 45, W_DOUSIN, bk|WHITE, bk|GREEN);  // open pick window
    pl.shadow();
    pl.title ("Pick-List");
    pl.prompt (list);           // assign a list
    int choice = pl.read();     // get user selection, closes window when finished

    // Display the results of the pick.
    if (choice != W_ESCAPE) 
        {
        WinObj w;
        w.open (6, 23, 11, 53, W_DOUSIN, bk|GREEN, bk|WHITE);
        w.title (" Answer ");
        w.shadow ();
        w.printf (1, 1, "You picked ");
        w.set_attr (bk|YELLOW);
        w.printf ("%s.", list[choice]);
        w.set_attr (bk|LGREY);
        w.printf (3, 1, "Press any key to continue.");
        w.get_key ();
        }
}

//**********************Menu Demo****************************
// First level of a lotus style menu
void menu_demo ()
{
    WinMenu m;                                      // Create a menu object
    m.open (1, 0, 1, 79, W_NOBORDER, _BLUE|WHITE);  // init the window
    m.message_line (2);                             // Set message line to 2
    m.set_keyattr (_BLUE|YELLOW);                   // hot key attribute
    m.set_barattr (_RED|WHITE);                     // make bar white on red

    // Declare some menu selections
    m.prompt (0,  0, 1, " Worksheet ", "Global, Column, Status, Delete", 'W');
    m.prompt (0, 12, 2, " Range ", "Format, Label, Erase, Name, Justify, Prot", 'R');
    m.prompt (0, 20, 3, " Copy ",  "Copy a cell or range of cells", 'C');
    m.prompt (0, 27, 4, " mOve ",  "Move a cell or range of cells", 'O');
    m.prompt (0, 34, 5, " File ",  "Retrieve, Save, Combine, Xtract...", 'F');
    m.prompt (0, 41, 6, " Print ", "Print a worksheet to a printer or file", 'P');
    m.prompt (0, 49, 0, " Quit ",  "Quit the menu demo", 'Q');
                    
    int choice=1;
    while (choice != 0) 
        {
        choice = m.read(choice);        // Get a menu selection
		if (choice == W_ESCAPE)
			break;
        switch (choice) 
            {
            case 1:
                menu_demo2();           // Goto next menu level
                break;
            case 2:
                break;
            }
        }
    // Menu object will destruct and close automatically.
}

void menu_demo2()       // Second level of a lotus style menu
{
    WinMenu m;
    m.open (1, 0, 1, 79, W_NOBORDER, _BLUE|WHITE);
    m.message_line (2);                             // Set message line to 1
    m.set_keyattr (_BLUE|YELLOW);                   // make hot key yellow
    m.set_barattr (_RED|WHITE);                     // make bar white on red

    m.prompt (0,  0, 1, " Global ", "Global functions", 'G');
    m.prompt (0,  9, 2, " Column ", "Delete, Insert", 'C');
    m.prompt (0, 18, 3, " Status ", "Display worksheet status", 'S');
    m.prompt (0, 27, 4, " Delete ", "Delete the entire worksheet", 'D');
    m.prompt (0, 36, 5, " sYstem ", "Shell to DOS", 'Y');
    m.prompt (0, 45, 0, " Quit ", "Quit to the main menu", 'Q');
    int choice=1;
    while (choice != 0) 
        {
        choice = m.read(choice);
		if (choice == W_ESCAPE)
			break;

        switch (choice) 
            {
            case 1:
                break;
            case 2:
                break;
            case 5:
                Win_clrscr ();
                puts ("Type 'EXIT' to return to demo.\n\n\n");
                system ("");
                m.update_all ();
                break;
            }
        }
}

//*************************Moving windows Demo*************************
WinObj Global_Win[2];   // Some global window objects to move

void moving_windows()
/*
 * Open the moving windows
 */
{
	// Windows will open or close with each call
    if (!Global_Win[0].is_open()) 
        {
        Global_Win[0].open (1, 1, 10, 25, W_DOUBLE, _MAGENTA|BLACK, _MAGENTA|BLUE);
        Global_Win[0].shadow ();
        Global_Win[0].title (" Moving Window 1 ");
        Global_Win[0] << "Here is some text in a moving window.";

        Global_Win[1].open (1, 54, 10, 79, W_DOUSIN, _GREEN|BLACK, _GREEN|WHITE);
        Global_Win[1].shadow ();
        Global_Win[1].title (" Moving Window 2 ");
        Global_Win[1] << "Here is some text in the second moving window.";
        }
    else 
        {
        Global_Win[0].close ();
        Global_Win[1].close ();
        }
}

// Function to move the random windows every second
// This function is called by the clock function with the current time
void move_windows (struct Win_time_s t)
{
    static int x = 1, y = 1, sec_hold = 0;

    if (!Global_Win[0].is_open())
        return;

    if (sec_hold != t.sec)       // only move once a second
        {
        sec_hold = t.sec;
        x += 6;
        y += 2;
        if ( x > 60 || y > 18)
            {
            x = 0;
            y = 0;
            }
        Global_Win[0].move (y, x);

        // randomly move the second window
        Global_Win[1].move (random(Win_Max_y () - 11), random(54));
        }
}

//***********************Scroll Demo**********************************
WinObj Scroll;	        // Scrolling text demo window object
WinObj Scroll2;

void scroll_demo ()
{
    // Open window once the first time
    if (!Scroll.is_open()) 
        {
        int bkground = _CYAN;
        if (VGA)
            bkground = _LCYAN;

        Scroll.hide ();         // open the window hidden
        Scroll.open (2, 56, 8, 78, W_DOUSIN, bkground|BLACK, bkground|BLUE);
        Scroll.shadow ();
        Scroll.title (" Slow Scroll ");

        if (VGA)
            bkground = _YELLOW;
        else
            bkground = _BLUE;

        Scroll2.hide ();
		Scroll2.open (11, 56, 16, 78, W_DOUSIN, bkground|RED, bkground|BLACK);
		Scroll2.shadow ();
		Scroll2.title (" Fast Scroll ");
        }

    /*
     * Now just hide or unhide the windows
     */
    static int hidden = 1;

    if (hidden)
        {
        Scroll.unhide ();
        Scroll2.unhide ();
        hidden = 0;
        }
    else
        {
        Scroll.hide ();
        Scroll2.hide ();
        hidden = 1;
        }
}

void random_message (WinObj &w)
/*
 * All the print messages here accomplish the same results,
 * a cr/lf followed by some text.
 */
{
	switch (random (6))
		{
	case 0:
		w << '\n' << ' ' << w.get_version();
		break;
	case 1:
		w << '\n' << " Lake View Software";
		break;
	case 2:
		w << '\n' << " Borland C++ v2.0";
		break;
	case 3:
		w << "\n Turbo C++ v1.01";
		break;
	case 4:
		w.printf ("\n Support Shareware");
		break;
	default:
		w.puts ("\n Some Scrolling Text");
		break;
	}
}

void scroll_window ()
{
    if (!Scroll.is_open())
        return;

   	static clock_t clock1 = 0, clock2 = 0;

	if ((clock1 + 5) < clock () )
		{
		random_message (Scroll);
        clock1 = clock ();
		}

	if ((clock2+1) < clock ())
		{
		random_message (Scroll2);	// Fast scroll
		clock2 = clock ();
		}
}

//**********************Random Windows Demo***************************

void random_windows ()
{
    WinObj w[5];

    for (int i = 0; i < 5; i++)
        {
        rand_open (w[i]);
        delay (250);
        }
    w[0].clr_win ();
    w[0] << "Press any key to continue.";
	w[0].get_key (0, 10);	// wait 10 seconds for a key
}

// Function to open random windows on the screen
void rand_open (WinObj &w)
{
    static cnt = 0;
    int sr, er, sc, ec;
    int color, bcolor, btype;

    sr = random (Win_Max_y () - 14);
    sc = random (40);
    er = sr + 10 + random ((Win_Max_y () - 14)-sr);
    ec = sc + 15 + random (63-sc);

    int bk_colors = 8;
    if (VGA)
        bk_colors = 16;

    color = random (bk_colors) * 16 + random (16);
    bcolor = random (bk_colors) * 16 + random (16);
    btype = random (MAX_BOX_TYPE + 1);
    w.open (sr, sc, er, ec, btype, color, bcolor);
    w.shadow ();
    w.title (" Random Window ");
    w << "This is random window #(" << ++cnt << ")";
}

//************************Data Entry Demo********************************

void paint_data_screen (WinObj &w)
/*
 * Paint the data entry screen
 */
{
    w.puts (0, 29, "Compiler");
    w.puts (6, 2, "First letter upper:");
    w.puts (7, 4, "Force upper case:");
    w.puts (8, 1, "Picture (\"A9A 9A9\"):");
    w.puts (9, 9, "Phone style:");
    w.puts (10, 10, "SS # style:");
    w.puts (11, 5, "Zip code style:");
    w.puts (12, 9, "Date style:");
    w.puts (13, 6, "Double (10,2):");
    w.puts (14, 11, "Long (5):");
    w.puts (15, 16, "Int:");
    w.puts (16, 8, "Single char:");
}

int button_press (int value)
/*
 * Routine to call when the press a button in the data entry screen
 */
{
    int return_value = 0;

    switch (value)
        {
        case 1:                     /* 'Ok' Button Pressed */
            return_value = PGDN;    /* Normal data entry exit */
            break;

        case 2:                     /* 'Cancel' Button Pressed */
            return_value = ESC;     /* Data entry quit */
            break;  
        }

    return return_value;
}

int read_data (WinObj &w)
/* 
 * read data for data_entry or print for print_data
 */
{
    static char
        first[40] = "",
        upper[20] = "",
        picture[8] = "",
        phone[15] = "",
        ss[12] = "",
        zip[15] = "",
        date[9] = "";

    static double
        d = 0.0;

    static long
        l = 0;

    static int
        i = 0;

    static char
        ch = ' ';

    static 
        comp_selected = 0;

    char
        *compiler_radio[] = {"Borland C++ v3.0", "Borland C++ v2.0",
                             "Turbo C++ v1.0", "Zortech C++ v3.0"};

    /*
     * Draw/fill a box and get a radio group
     */
    int old_attr = w.set_attr (_CYAN|BLACK);
    w.set_getattr (_CYAN|WHITE);
    w.box (1, 22, 4, 50, W_SPACES, 1);
    w.get_radio (1, 25, compiler_radio, comp_selected, 4);
    w.set_attr (old_attr);

    /*
     * Get some regular gets
     */
    w.set_getattr (_LGREY|BLACK);
    w.get (6 , 22, first, 'F', sizeof(first) - 1);  // upper case first letters
    w.get (7 , 22, upper, 'U', sizeof(upper) -1);   // upper case all letters
    w.get (8 , 22, picture, "A9A 9A9");             // Canadian zip code using picture
    w.get (9 , 22, phone, 'P');                     // phone number style
    w.get (10 , 22, ss, 'S');                       // social security style
        w.valid (v_socialsecurity);                 // validate the ss number
    w.get (11, 22, zip, 'Z');                       // US zip code style
    w.get (12, 22, date, 'D');                      // date style
    w.get (13, 22, d, 10, 3);                       // double 10 long with 3 decimal places
    w.get (14, 22, l, 5);                           // long 5 digits in length
    w.get (15, 22, i);                              // integer at default length
    w.get (16, 22, ch);                             // single character get

    /*
     * Get some buttons
     */
    w.set_getattr (_BLACK|GREEN);
    w.get_button (1, 60, "   Ok   ", button_press, 1);
    w.get_button (3, 60, " Cancel ", button_press, 2);

    /*
     * Prompt the user for the input and return the results
     */
    return (w.read ());
}

void print_data ()
{
	if (!Win_Get_YN ("Printer ready"))
		return;
	
	Win_Prn p;
	if (p.open () != W_OK)
		{
		Win_Error ("Can't open printer port!");
		return;
		}

	paint_data_screen (p);		// Paint the screen in memory
	read_data (p);				// Paint the gets in memory

	//
	// Now lets change some of the print attributes.
	// These normaly would could be set before each printf or puts...
	// but since I used the same routines to print the screen and the
	// page this is being done later.
	//
	p.set_pageattr (P_NORMAL);	// Set attributes for the entire page
	p.set_attr (P_UNDERLINE, 1, 14, 15);	// Underline the last name

	p.print_page ();			// Print physical page

	p.close ();					// could let close with distructor
}

void data_entry()
{
    WinObj  w(40,75);                   // Create the main entry window
    w.open (3, 4, 18, 75, W_DOUBLE, _BLUE|WHITE, _BLUE|YELLOW);
    w.shadow ();
    w.title(" Data Entry ");

	paint_data_screen (w);		        // Paint the screen

    if (read_data (w) != ESC)			// Get the data
    	if (Win_Get_YN ("Do you wish to print the data"))
	    	print_data ();
}

int v_socialsecurity(void *num) 
/*
 * Valid function for ss number
 */
{
    char *ss = (char *) num;
    if (strchr (ss, ' '))
        {
        Win_Error ("No spaces in SS number!");
        return 0;       // fail valid, make user correct this get
        }

    return 1;  // pass valid
}

//*************************Paradox Entry*********************************
#ifdef __TURBOC__
char *Text[] = {
    "Entering text in a Paradox Table is one of the many features of LVS",
    "Windows.  It allows you to enter directly into the Paradox record",
    "buffer, with no temporary variables.",
    "",
    "I'd like to show you how to enter text in a Paradox Table using LVS",
    "Windows, but I would have to write this in the large model and I've",
    "only supplied the small model here.  So here's what the code would",
    "look like.",
    "",
    "To view the code use the Up and Down arrows keys.",
    "                   Esc to exit",
    "",
    "",
    "#include <pxengine.h>",
    "#include <LVSwin.hpp>",
    "",
    "main ()  {",
    "   TABLEHANDLE TblHandle;",
    "   RECORDHANDLE RecHandle;",
    "",
    "   PXInit ();                              // Init the PX engine",
    "   PXTblOpen (\"SALES\", &TblHandle, 0, 0);  // Open the table",
    "   PXRecBufOpen (TblHandle, &RecHandle);   // Open a record buffer",
	"   PXRecFirst (TblHandle);                 // Point to the first record",
    "   PXRecGet (TblHandle, RecHandle);        // Read the record.",
    "",
    "   WinObj w;                               // my window object",
    "   w.open (0, 0, 24, 79);                  // Open the window",
    "   w.PXrecord (TblHandle, RecHandle);      // give winobj the PX info",
    "   w.PXget (1, 1, 1, 'F');                 // Get the first field, style 'F'",
    "   w.PXget (3, 1, 2, 'F');",
    "   w.PXget (5, 1, 11, 'P');                // Get the 11 field, style Phone",
    "   w.PXget (7, 1, 17, 10, 2);",
    "   w.PXget (9, 1, 18, 3, 0);",
    "   w.PXread ();                            // Read the user input",
    "   PXRecUpdate (TblHandle, RecHandle);     // update the PX record",
    "   PXExit ();                              // Stop the PX engine",
    "}",
    "",
    "",
    "Paradox in a Trademark of Borland",
    0 };

void paradox_entry ()
{
    WinObj w (43, 78);

    w.open (1, 0, 23, 79, W_SINGLE, _BLUE|WHITE, _BLUE|CYAN);
    w.title (" Paradox Entry ");
    int i = -1;
    while (Text [++i])
        w.puts (i+1, 2, Text [i]);

    w.gotoxy ();

    int key = 0;
    do {
        key = w.get_key (0, 60);      // wait 1 minute for a key press

        switch (key)
            {
            case UP:
                w.gotoxy (w.wherey () - 1, w.wherex ());
                break;
            case DOWN:
                if (w.wherey () < w.max_y ())
                    w.gotoxy (w.wherey () + 1, w.wherex ());
                break;
            case LEFT:
                w.gotoxy (w.wherey (), w.wherex () - 1);
                break;
            case RIGHT:
                w.gotoxy (w.wherey (), w.wherex () + 1);
                break;
            }

        } while (key && (key != ESC));
}
#endif

//**************************Clock function*******************************

static WinObj clock_win;        // create a static window object

void show_time ()                   // Show time in upper left corner of screen
{
    static struct Win_time_s t;
    static unsigned char hold;

    if (!clock_win.is_open())       // open small clock window once
		{
        int color = _LGREY|BLUE;
        if (VGA)
            color = _WHITE|BLUE;
            
        clock_win.open (0, 0, 0, 79, W_NOBORDER, color);
		clock_win.center (0, "Lake View Software");
		}

    /*
     * First show the clock
     */
    Win_gettime (&t);

    if (hold != t.sec) 
        {
        hold = t.sec;
        clock_win.printf (0, 1, "%02d:%02d:%02d", t.hour, t.min, t.sec);
        #ifndef DOS386
        clock_win.printf (0, 73, "%6ld", (long )coreleft ());  // show free mem
        #endif
        }

    /*
     * Move the random windows
     */
    move_windows (t);

    /*
     * scroll text in window
     */
	scroll_window ();

}

//**********************Help Function***********************************
void help()
{
    static int is_active=0;
    int old_x, old_y;

    if (is_active++)
        return;

    /*
     * Save current cursor position
     */
    Win_getxy (&old_y, &old_x);

    WinObj help;

    int bkground = _LGREY;
    if (VGA)
        bkground = _LBLUE;

    help.open (2, 11, 22, 67, W_SINGLE, bkground|BLACK, bkground|WHITE);
    help.shadow ();
    help.title (" Help Window ");
    help.center (1, "Data Entry Keys");
    help.gotoxy (3, 1) << "/ arrows        Move cursor to next/prev field.";
    help.printf (4, 1, "%c/%c arrows        Move cursor to next/prev column.",26,27);
    help.printf (5, 1, "Crtl_%c/%c          Move cursor to next/prev word.", 26, 27);
    help.puts (6, 1, "Ctrl_R/L arrows   Pan window right/left one column.");
    help.puts (7, 1, "Ctrl_D/U          Pan window down/up one row.");
    help.puts (8, 1, "PgDn              Exit read mode.");
    help.puts (9, 1, "Esc               Quit read mode.");
    int hold_attr = help.set_attr (bkground|WHITE);
    help.center (11, "Non Picture Gets Only");
    help.set_attr (hold_attr);
    help.puts (12, 1, "Insert            Toggle insert/overtype mode.");
    help.puts (13, 1, "Delete            Delete character under cursor.");
    help.puts (14, 1, "Backspace         Delete previous character.");
    hold_attr = help.set_attr (bkground|RED);
    help.center (17, "Copyright (c) 1992, Lake View Software");
    help.set_attr (hold_attr);
    help.center (18, "Press any key to exit.");
	Win_getkey (15);				    // wait 15 seconds for a key 

    Win_gotoxy (old_y, old_x);          // Restore cursor position
    is_active = 0;                      // turn off active flag
}


//*****************************Logo*****************************************

void function_key_mouse_routine (int y, int x)
/*
 * Check mouse clicks for function keys
 * This routine will be attached to the footer
 * window.
 */
{
    if (y != 0)
        return;

    if (x >=21 && x <= 27)
        Win_keystuf (F1);

    if (x >= 30 && x <= 40)
        Win_keystuf (F5);

    if (x >= 43 && x <= 56)
        Win_keystuf (F10);
}

static WinObj Main;         // the main screen window
static WinObj Footer;       // window for the footer
static WinObj logo_w;         // window for our logo

void logo ()
{
    int max_y = Win_Max_y ();           // Get the max y coordinate

    if (Use_VGA)
        {
        if (VGA_videotype () == V_VGA)
            {
            /*
             * Turn blink off to allow highlight backgrounds
             */
            VGA_setblink (W_OFF);

            /*
             * load special fonts
             */

            VGA_fontload ();

            VGA++;      // set vga flag
            }
        }

    /*
     * Open a window to cover the screen
     */
    int bkground = _BLACK;
    if (VGA)
        bkground = _DGREY;
	Main.open (0, 0, max_y, 79, W_NOBORDER, bkground|LGREY);

	for (int x = 0; x < max_y * 2 + max_y / 5; x++)
		Main.printf ("- LVS Windows -- Lake View Software -");
	

    /*
     * Display the footer
     */
    int color = _LGREY|BLACK;
    if (VGA)
        color = _WHITE|BLACK;

	Footer.open (max_y, 0, max_y, 79, W_NOBORDER, color);
	Footer.puts (0, 21, "F1=Help, F5=Calendar, F10=Calculator");
    Footer.set_mouseroutine (function_key_mouse_routine);

    /*
     * Display the logo
     */
    color = _BLACK;
    if (VGA)
        color = _DGREY;

    logo_w.open (max_y - 5, 19, max_y - 2, 59, W_DOUSIN, 
               color|WHITE, color|YELLOW);
    logo_w.shadow ();

    logo_w.title (logo_w.get_version ());
    logo_w.center (0, "The C++ window class system");
    logo_w.center (1,"Copyright (c) 1992");

    // start random number generator
    srand (1);

    show_time ();   // displays the title bar and time for the first time
}
