/*
 *            LVS Windows
 *      The Window Class System
 *
 *        Copyright 1991 (c), Lake View Software
 *                            4321 Harborough Rd.
 *                            Columbus, OH 43220
 *        All rights reserved.
 */
// LVSwin.HPP

#ifndef LVSWIN_HPP
#define LVSWIN_HPP

#include <stdio.h>
#include "lvswin.h"

typedef int (*valid_func)(void *);
typedef int (*valid2_func)(void *, void *);
typedef void (*before_func)(void *);
typedef int (*button_func_t)(int);
typedef void (*mouse_routine_t)(int, int);

class GetObj {
// Base Get Object
        friend class WinObj;
    protected:
        GetObj
            *Prev_get,
            *Next_get;
        WinObj
            *w;                 // window the get object is in
        int 
            y, x,               // window coordinates
            attr,               // its get attribute
            _attr,              // windows current attribute
            mouse_positioner;   // mouse location
        valid_func 
            valid;              // Call after read to get
        valid2_func 
            valid2;             // Call after read to get with 2 params
        void *valid2_pass;      // second param to pass to valid2 func
        before_func 
            before;             // Call before read to get
        int add_to_list ();     // add to a windows linked list
        #ifdef __LARGE__
            /*
             * Paradox stuf
             */
            void *PX_buf;
            char PX_type [11];
            unsigned
                PX_fld,
                PX_tbl,
                PX_dec,
                PX_rec;
        #endif      // defined large
    public:
        GetObj ();
        ~GetObj ();
        virtual int input ();               // read from the user
        virtual void display ();            // display the get
        virtual int is_on (int y, int x);   // test coordinate
};

class GetObj_L:public GetObj
/*
 * Long get class
 */
{
    private:
        long *obj;
        int length;
    public:
        GetObj_L (WinObj *w);
        int get (int y, int x, long &L, int len);
        int input ();               // read from the user
        void display ();            // display the get
        int is_on (int y, int x);   // test coordinate
};

class GetObj_R:public GetObj
/*
 * Radio button class
 */
{
    private:
        int *obj;               // will contain the button value
        char **string_list;
        int count;
        int length;             // length of string.
        void select_button (int button);
        void display_button (int button);
    public:
        GetObj_R (WinObj *w);
        int get (int y1, int x1, char *str[], int &value, int cnt);
        int input ();               // read from the user
        void display ();            // display the get
        int is_on (int y, int x);   // test coordinate
};

class GetObj_S:public GetObj
/*
 * String get class
 */
{
    private:
        char *obj;
        char *picture;
        int length;
        char style;
    public:
        GetObj_S (WinObj *w);
        int get (int y, int x, char *str, char s, int len);
        int get (int y, int x, char *str, char *pict);
        int input ();               // read from the user
        void display ();            // display the get
        int is_on (int y, int x);   // test coordinate
};

class GetObj_X:public GetObj
/*
 * Check box class
 */
{
    private:
        int *obj;
        char *check_str;
        int length;
    public:
        GetObj_X (WinObj *w);
        int get (int y1, int x1, char *str, int &value);
        int input ();               // read from the user
        void display ();            // display the get
        int is_on (int y, int x);   // test coordinate
};

class GetObj_P:public GetObj
/*
 * Pick list class
 */
{
    private:
        int *obj;               // selected item
        int sr, sc, er, ec;
        char **picklist;
        int count;              // adjustable count
        int start;              // first showing in box
        int max;                // max displayed in list at a time
        int width;              // width of the list items
        int scroll_flag;        // show scroll flag
        int adjust ();          // adjust the list window
        void display_scroll (); // display the scroll bars
        void remove_scroll ();  // remove the scroll bars
        int calc_elev_row ();   // calc the elevator column
    public:
        GetObj_P (WinObj *w);
        int get (int sr1, int sc1, int er1, int ec1,
                 char **list, int &cnt, int &selected);
        int input ();               // read from the user
        void display ();            // display the get
        int is_on (int y, int x);   // test coordinate
        void set_new_count (int cnt);       // adjust count while running
};

class GetObj_B:public GetObj
/*
 * Push button class
 */
{
    private:
        int obj;                // will contain the button value
        button_func_t bf;         
        char *button_str;       // string displayed for button
        int length;             // length of string.
    public:
        GetObj_B (WinObj *w);
        int get (int y1, int x1, char *s, button_func_t func, int value);
        int input ();               // read from the user
        void display ();            // display the get
        int is_on (int y, int x);   // test coordinate
};

class GetObj_D:public GetObj
/*
 * Double class
 */
{
    private:
        double *obj;
        int length;
        int decimals;
    public:
        GetObj_D (WinObj *w);
        int get (int y1, int x1, double &d, int l, int dec);
        int input ();               // read from the user
        void display ();            // display the get
        int is_on (int y, int x);   // test coordinate
};

class GetObj_C:public GetObj
/*
 * Char get class
 */
{
    private:
        char *obj;
    public:
        GetObj_C (WinObj *w);
        int get (int y, int x, char &ch);
        int input ();               // read from the user
        void display ();            // display the get
        int is_on (int y, int x);   // test coordinate
};

class GetObj_I:public GetObj
/*
 * Integer class
 */
{
    private:
        int *obj;
        int len;
    public:
        GetObj_I (WinObj *w);
        int get (int y, int x, int &i, int len);
        int input ();               // read from the user
        void display ();            // display the get
        int is_on (int y, int x);   // test coordinate
};


class WinObj  {
/*
 * Window Class
 */
    friend class WinMouse;
    friend class GetObj;
    friend WinObj *Win_whos_active ();
    friend void Win_close_all ();
    protected:
        static WinObj *w_active;        // Current active window object
        static int w_count;             // number of window objects
        static char *buffer;            // working buffer
        WinObj *next_win;               // Next window object
        WinObj *prev_win;               // Previous window object
        unsigned wsc,wsr,wec,wer;       // Screen coordinates
        unsigned width,height;          // Actual screen space available
        int get_attr;                   // Get attribute
        int win_attr;                   // Window attribute
        int bor_attr;                   // Border attribute
        int bor_type;                   // Border type
        int win_type;                   // type of window
        unsigned char fill_char;        // window fill character
        int title_pos;                  // Title position
        char *title_str;                // Pointer to title string
        char *wdata_buf;                // Data buffer
        char *wattr_buf;                // attribute buffer
        GetObj *Current_get;            // Current get object
        GetObj *Last_get;               // Last get object in list
        char opened;                    // Opened flag
        char hidden;                    // Hidden flag
        char needs_display;             // Refresh flag
        char has_border;                // border flag
        char has_shadow;                // shadow flag
        char user_move;                 // user movement flag
        char insert;                    // insert mode flag
        char scroll_h,scroll_v;         // scroll arrows flag
        char read_change_flag;          // flag for read changes
        char read_in_progress;          // read in progress flag
        unsigned vh,vw;                 // Virtual height and width
        unsigned buf_size;              // Window data and attr buf size
        unsigned sx,sy;                 // Start x and y for virtual display
        unsigned cur_pos;               // Cursor x and y
        void reset_window ();           // reset all flags
        int get_titlestart (int &len);  // get start x of title and length
        int input (GetObj *Obj);        // Get a read from the screen
        int create_get (int y, int x);  // create a new get object
        void draw_border ();            // draw the window border
        virtual unsigned char bor_char (int, int, unsigned char &);// calculate the border char/attr
        void update_scroll ();          // update scroll bars
        virtual void display ();        // Display window contents on top
        virtual void update (int start_pos,int len);  // Update a portion of window
        void show_shadow ();		    // Display the windows shadow.
        virtual void mouse_routine (int y, int x); // mouse click routine 
        mouse_routine_t mouse_user_routine; // programmers mouse routine

        /*  Paradox Stuf */
        unsigned PX_tbl,                // Paradox table handle
                 PX_rec;                // Paradox record handle
public:
        WinObj (int v_h, int v_w=0);
        WinObj ();                      // allows init of arrays
        ~WinObj ();

        char *get_version ();
        int set_virtual (int y,int x);      // set virtual size
        virtual int open (int sr, int sc, int er, int ec,
            int btype=W_DOUBLE, int wattr=_BLACK|LGREY,
            int battr=_BLACK|LGREY);        // Open the window object

        /* Mouse related */
        mouse_routine_t set_mouseroutine (mouse_routine_t); // programmers mouse routine
        void allow_user_moves (int true_flase);  // allow user to move or size window

        /* Attributes */
        int set_attr (int color);           // Returns pervios attribute
        void set_attr (int color, int y,
                int x, int cnt=1);          // change attr
        void set_fill (char fill); // set window fill character.
        void change_border (int type,
                int color=-1);              // Set new border style/color
        void title (char *str,
                int position=W_CENTER);     // Change the window title
        virtual void shadow (int on_off=W_ON);      // Turn window shadow on/off
        void set_insert (int on_off);       // switch insert mode

        /* Display routines */
        void box (int sr, int sc, int er, 
                int ec, int type = W_SINGLE,
                int fill = (1!=1));       // Draw a box in the window
        void scroll_box (int sr, int sc, int er, 
                int ec, int type = W_SINGLE,
                int fill = (1!=1));       // Draw a scroll box in the window
        virtual void update ();             // Update but don't set current
        void update_all ();                 // update all open windows
        virtual void show_cursor ();        // Show cursor in window
        virtual void close ();              // Close the window object.
        virtual void set_active ();         // makes window current window
        void bprintf (char *,...);          // Print f in window
        void bprintf (int y, int x, char *,...);  // xy bprintf
        void printf (char *,...);           // Print f in window
        void printf (int y,int x,char *,...);    // xy printf
        void puts (char *,int translate=W_ON);    // Display a string
        void puts (int y, int x, char *, int translate=W_ON);
        void putch (char ch, int translate=W_OFF); // display a character
        void putch (int y, int x, char ch, int translate=W_OFF);
        int center (int y, char *);         // center in virtual window
        void clr_win ();                    // Clear window
        void clr_eol ();                    // Clear to end of current line
        void clr_eow ();			        // Clear to end of window
        void del_line (int line_no);        // Delete current, line pull up
        void ins_line (int line_no);        // Ins new line, push down

        /* Get routines */
        int get (int y, int x, char *str, char *picture=NULL);
        int get (int y, int x, char *str, char style, int len = 0);
        int get (int y, int x, char &ch);
        int get (int y, int x, int &geti, int len=4);
        int get (int y, int x, long int &getl,int len=5);
        int get (int y, int x, double &getd, int len=10, int dec=2);
        int get_button (int y, int x, char *str, button_func_t bf, int value);
        int get_checkbox (int y, int x, char *str, int &value);
        int get_radio (int y, int x, char *str[], int &value, int count);
        int get_picklist (int sr, int sc, int er, int ec, char *list[],
                          int cnt, int &selected);
        void *get_object_ptr ();              // get pointer to last get object
        int set_getattr (int new_attr = -1);  // Change the get attribute
        int valid (valid_func func);    // Valid function with one param
        int valid (valid2_func func, void *); // valid function with two params
        int before (before_func func);	// Before get function
        virtual int get_key (int echo=W_NOECHO, int seconds = 0);  // Get single key from keyboard  do not echo, wait forever
        virtual int read (int clear = 1);           // Read all defined gets
        int any_read_change ();                     // any change after last read
        void set_read_change ();                    // set read change flag
        int update_gets (); 		                // Update gets on screen.
        void clear_gets ();                         // Clear all defined gets

        /* Window Movement */
        virtual void hide ();                       // Hide window
        virtual void unhide ();                     // Show window
        virtual int move (int new_y, int new_x);    // Move the window
        virtual int size (int new_height, int new_width);    // Resize the window
        WinObj& gotoxy (unsigned y=0, unsigned x=0);  // Move cursor in window
        int  pan (int delta_y, int delta_x);        // change pan location
        int set_pan (int y, int x);                 // set pan location

        /* Information routines */
        int do_youown (int y, int x, unsigned char &ch,unsigned char &attr);        // Do you own screen position
        WinObj *who_owns (int y, int x, unsigned char &ch,unsigned char &attr);
        WinObj *whos_below (int y, int x, unsigned char &ch, unsigned char &attr);
        unsigned max_x(), max_y();                   // return maximum virtual x/y coordinates
        int get_scr (int &sr, int &sc, int &er, int &ec);  // get coordinates
        int get_pan (int &y, int &x);               // return current pan coordinates
        int wherexy (int &y, int &x);               // return current cursor pos
        int wherex ();                              // return current col
        int wherey ();                              // return current row
        int get_insert ();                          // return insert mode
        int is_open ();                             // open status
        int is_hidden ();                           // hidden status
        int ret_char (int y, int x);                // get window char at window location
        int ret_attr (int y, int x);                // get window attr at window location
        int text_save (FILE *fp);                   // save window text
        int text_retrieve (FILE *fp);               // retrieve window text

        /*   Paradox get / read routines  */
        int PXrecord (unsigned tbl_handle, unsigned rec_handle);
        int PXget (int y, int x, unsigned fld_handle);
        int PXget (int y, int x, unsigned fld_handle, int len, int dec);
        int PXget (int y, int x, unsigned fld_handle, char style);
        int PXget (int y, int x, unsigned fld_handle, char *picture);
        int PXread (int clear=1);             // use this read with PX

        /* Overloaded operators */
        WinObj& operator << (int i);
        WinObj& operator << (char *str);
        WinObj& operator << (char ch);
        WinObj& operator << (long l);
        WinObj& operator << (double d);
        WinObj& operator << (float f);
        WinObj& operator << (unsigned ui);
        WinObj& operator << (unsigned long ul);
};

/*
 * Global functions
 */
extern WinObj *Win_whos_active ();
extern int printf_translate (int mode);

/*
 * Mouse Routines/Class
 */

#define     M_NONE        0         /* No mouse support */
#define     M_SIMPLE      1         /* Simple cursor replacement Mode */
#define     M_FULL        2         /* Full function mouse support */

#define     DELTAX       16         /* amount of change to cause an arrow */
#define     DELTAY       16         /* key when in simple mode */
#define     PIXELS        8         /* Pixels / screen coordinate */

/*
 * Global routines
 */
extern WinMouse Win_mouse;
int Win_mouse_mode (int mode = M_SIMPLE);

class WinMouse {
    private:
        int Mouse_Mode;             /* Mouse Init flag / mode */
        int Mouse_Buttons;          /* Number of mouse button */
        int Mouse_Hidden;           /* Mouse hidden flag */
        void scan_full ();          /* Scan full mouse support */
    public:
        void clear_counters ();     /* clear counters for mouse_scan */
        void scan ();               /* translate clicks to keys */
        WinMouse (int mode = M_SIMPLE);
        ~WinMouse ();

        void close ();                  /* close the mouse */
        int init (int mode = M_SIMPLE); /* Mouse init function */
        int get_mode ();                /* Get current mouse mode */
        void motion (int &y, int &x);   /* Return micky motion in char */
        void position (int y, int x);   /* Position the mouse cursor */
        int clicks (int button, int &y, int &x); /* get click count  returns 
                                                    position of last click */
        int releases (int button, int &y, int &x); /* get click count  returns 
                                                    position of last release */
        void show ();                   /* Display the mouse cursor */
        void hide ();                   /* Hide the cursor */
        int status (int &y, int &x);    /* mouse status */
        int x ();                       /* return current x coordinate */
        int y ();                       /* return y coordinate */
        void limit_x (int min, int max); /* limit mouse x coordinates */
        void limit_y (int min, int max); /* limit mouse y coordinates */
        int protect (int sr, int sc, int er, int ec);  /* protect cursor */
};

/*
 * Low level routines in MOU_FUN.ASM & MOU_FUN2.ASM
 */

extern "C" {
    void far Mouse_Hide ();
    void far Mouse_Show ();
    int far Mouse_Init (int far *Buttons);
    void far Mouse_Motion (int far *y, int far *x);
    void far Mouse_Location (int far *y, int far *x);
    int far Mouse_Status (int far *y, int far *x);
    int far Mouse_Clicks (int key, int far *y, int far *x);
    int far Mouse_Releases (int key, int far *y, int far *x);
    void far Mouse_Position (int y, int x);
    void far Mouse_Limit_X (int min, int max);
    void far Mouse_Limit_Y (int min, int max);
    int far Mouse_Y ();
    int far Mouse_X ();
};


/*
 * Some macros for internal use
 */

#define SHADOW_ATTR	DGREY
#define BUFFER_OFFSET(y,x) (y * vw + x)
#define GET_REAL_X(x) ((x - sx) + wsc + has_border)
#define GET_REAL_Y(y) ((y - sy) + wsr + has_border)
#define CALC_SCROLL_POSITION(s,x,a_rng,b_rng) ((a_rng) ? (s + 2 + (int)((long) (x) * (long)(b_rng) / (long)(a_rng))): 0)

/*
 * Class to save the current screen state to restore it when the
 * program is finished.
 */

class ScreenState {
    private:
        int restore;        // restore state on exit flag
        int page;           // previous screen page
        int *scr_buf;       // screen buffer
        int y, x;           // cursor location
        int rows, cols;     // row/col count
        int mode;
    public:
        ScreenState ();
        ~ScreenState ();
};


/*
 * Some tools Previously in WinTools.hpp
 */

void Win_Calculator ();

void Win_Calc_colors (int win_attr = _GREEN|BLACK, int bor_attr = _GREEN|WHITE);

void Win_Calendar ();

char *Win_File_Pick (char *file_spec, int win_attr = _CYAN|WHITE,
		int bor_attr = _CYAN|BLACK );

void Win_Error (char *msg = "Error", int win_attr = _RED|BLACK,
		int bor_attr = _RED|WHITE);

void Win_Msg (char *msg = "Hello", int win_attr = _BLUE|WHITE,
		int bor_attr = _BLUE|BLACK);

char Win_Get_Choice (char *msg, char *choices, int win_attr = _GREEN|BLACK,
		int bor_attr = _GREEN|WHITE);

int Win_Get_YN (char *msg = "Yes or No", int winattr = _GREEN|BLACK, 
	int borattr = _GREEN|BLACK);

class Win_File_List {
    friend int File_Spec_Valid (void *obj, void *file_list);
    friend int File_List_Valid (void *obj, void *file_list);

    private:
        enum { GETSIZE  = 28,
               MAXPFILES = 150 };

        char 
            *Title,
            Input_Str[GETSIZE + 1],
            Old_Spec[81],
            *File_List[MAXPFILES],
            *choice;
        int 
            Count,
            Selected,
            Win_Attr,
            Bor_Attr,
            Bor_Type,
            Get_Attr,
            Button_Attr,
            start_y,
            start_x;
        GetObj_P *PL;
        WinObj *W;

        void reset ();
        int Build_List ();
        void Free_List ();
        
    public:
        Win_File_List ();
        ~Win_File_List ();
        int set_attr (int newattr);
        int set_getattr (int newattr);
        int set_butattr (int newattr);
        int position (int y, int x);
        int change_border (int type, int newattr);
        char *read (char *spec = "*.*");
};


#endif  //  #ifndef LVSWIN_HPP
