/*
 *            LVS Windows
 *      The Window Class System
 *
 *        Copyright 1992 (c), Lake View Software
 *                            4321 Harborough Rd.
 *                            Columbus, OH 43220
 *        All rights reserved.
 *
 * DEMO2.CPP
 */

#ifdef __TURBOC__
    #include <alloc.h>
#endif
#include "LVSwin.hpp"
#include "LVSmenu.hpp"
#include "DEMO2.HPP"

/*
 * Local functions
 */

void Compiler_Menu ();
void Linker (Options_s *opt);
void Code_Generation (Options_s *opt);
void Advanced_Code (Options_s *opt);
int button_press (int value);
void Directories (Options_s *opt);
void Screen_Open ();
void Debugger (Options_s *opt);
void show_time ();

/*
 * Global data
 */
Options_s options = {
    0,      // map file
    0,      // output exe
    0,      // init segments
    1,      // default libraries
    0,      // graphics lib
    1,      // dup symbols
    1,      // no stack
    1,      // case sensitive link
    0,      // case sensitive exports
    0,      // pack code
    64L,    // pack size
    32L,    // segment align
    1,      // model_selected
    0,      // ss_ds_selected
    "",     // defines
    1,      // enums as ints
    0,      // word alignment
    0,      // duplicate strings
    0,      // unsigned chars
    0,      // pre-compiled headers
    1,      // float_selected
    0,      // inst_set
    1,      // under bars
    0,      // line number
    1,      // debug info in objects
    1,      // fast floating point
    0,      // fast huge
    0,      // comdefs
    0,      // far_data
    32767L, // data threshold
    "C:\\BC\\INCLUDE",   // Include
    "C:\\BC\\LIB",       // Library
    "",                // output
    2,      //    source_debug_selected,
    1,      //    swapping_selected,
    1,      //    show_inherited,
    1,      //    show_methods,
    2,      //    decimal_hex_selected;
    64,     //    program heap size
};

void main ()
{
	VGA_fontload ();                // load vga fonts
	VGA_setblink (W_OFF);           // allow highlighted backgrounds
	Win_mouse_mode (M_FULL);        // turn mouse on
    Win_setbkloop (show_time);      // Set background keyboard loop

    /*
     * Open the main screen
     */
    Screen_Open ();

    /*
     * Create the main menu
     */
	WinMenu m;

	m.open (3, 31, 14, 47, W_SINGLE, _BLUE|CYAN, _BLUE|WHITE);
	m.set_keyattr (_BLUE|RED);
	m.title (" Options ");
	m.shadow ();

	m.prompt (1, 1, 1, " Compiler    ", "", 'C');
	m.prompt (3, 1, 2, " Linker      ", "", 'L');
	m.prompt (5, 1, 3, " Debugger    ", "", 'D');
	m.prompt (7, 1, 4, " Directories ", "", 'r');
	m.prompt (9, 1, 0, " Quit        ", "", 'Q');

	int choice = 1;

	while (choice && choice != W_ESCAPE)
		{
		choice = m.read (choice);
		switch (choice)
			{
			case 1:
				Compiler_Menu ();
				break;

            case 2:
                Linker (&options);
                break;

            case 3:
                Debugger (&options);
                break;

            case 4:
                Directories (&options);
                break;
			}
		}
}

void Compiler_Menu ()
/*
 * Compiler options menu
 */
{
	WinMenu m;

	m.open (5, 28, 16, 48, W_SINGLE, _CYAN|BLUE, _CYAN|WHITE);
	m.set_keyattr (_CYAN|RED);
	m.title (" Compiler ");
	m.shadow ();

	m.prompt (1, 1, 1, " Code generation ", "", 'C');
	m.prompt (3, 1, 2, " Entry/Exit code ", "", 'E');
	m.prompt (5, 1, 3, " C++ options     ", "", '+');
	m.prompt (7, 1, 4, " Optimizations   ", "", 'O');
	m.prompt (9, 1, 0, " Quit            ", "", 'Q');

	int choice = 1;

	while (choice && choice != W_ESCAPE)
		{
		choice = m.read (choice);
		switch (choice)
			{
			case 1:
                Code_Generation (&options);
				break;

            case 2:
                Win_Msg ("Entry/Exit code not available");
                break;

            case 3:
                Win_Msg ("C++ options not available");
                break;

            case 4:
                Win_Msg ("Optimizations not available");
                break;
			}
		}
}

int button_press (int value)
/*
 * called when the user press a button in the code_generation menu
 * Same routine is used for all buttons, in this demo
 */
{
    switch (value)
        {
        case 1:     // more
            Advanced_Code (&options);
            return 0;

        case 2:     // ok
            return PGDN;

        case 3:
            return ESC;

        case 4:
            Win_Msg ("Sorry no help available!");
            return 0;

        default:
            return 0;
        }
}

void Directories (Options_s *opt)
/*
 * Read the directory options from the user
 */
{
    WinObj w;
    w.open (4, 12, 17, 67, W_SINGLE, _LGREY|BLACK, _LGREY|WHITE);
    w.title ("Directories");
    w.shadow ();

    w.puts (1, 1, "Include Directories");
    w.puts (4, 1, "Library Directories");
    w.puts (7, 1, "Output Directory");

    w.set_getattr (_GREEN|BLACK);
    w.get (2, 1, opt->Include, 'U', sizeof (opt->Include) - 1);
    w.get (5, 1, opt->Library, 'U', sizeof (opt->Library) - 1);
    w.get (8, 1, opt->Output, 'U', sizeof (opt->Output) - 1);

    w.set_getattr (_BLUE|YELLOW);
    w.get_button (11, 1, "   Ok   ", button_press, 2);
    w.get_button (11, 14, " Cancel ", button_press, 3);
    w.get_button (11, 27, "  Help  ", button_press, 4);

    w.read ();
}

void Code_Generation (Options_s *opt)
/*
 * Prompt the user for code generation information
 */
{
    char
        *model_radio[] = {"Tiny   ", "Small  ", "Medium ", 
                          "Compact", "Large  ", "Huge   " },
        *assume_radio[] = {"Default Memory Model", 
                           "Never               ",
                           "Always              "};

    WinObj w;
    w.open (3, 14, 21, 64, W_SINGLE, _LGREY|BLACK, _LGREY|WHITE);
    w.title ("Code Generation");
    w.shadow ();
    w.puts (1, 1, "Model");
    w.puts (1, 17, "Options");
    w.puts (9, 1, "Assume SS equals DS");
    w.puts (14, 1, "Defines");

    w.set_attr (_CYAN|BLACK);
    w.box (2, 1, 7, 14, W_SPACES, 1);
    w.box (10, 1, 12, 28, W_SPACES, 1);
    w.box (2, 17, 6, 47, W_SPACES, 1);

    w.set_getattr (_CYAN|WHITE);
    w.get_radio (2, 2, model_radio, opt->model_selected, 6);

    w.get_checkbox (2, 18, "Treat enums as ints     ", opt->enums);
    w.get_checkbox (3, 18, "Word alignment          ", opt->word_align);
    w.get_checkbox (4, 18, "Duplicate strings merged", opt->dup_strings);
    w.get_checkbox (5, 18, "Unsigned characters     ", opt->unsigned_chars);
    w.get_checkbox (6, 18, "Pre-compiled headers    ", opt->pre_headers);

    w.get_radio (10, 2, assume_radio, opt->ss_ds_selected, 3);
    w.set_getattr (_GREEN|BLACK);
    w.get (14, 9, opt->defines, 'A', sizeof (opt->defines) - 1);

    w.set_getattr (_BLUE|YELLOW);
    w.get_button (16, 1,  " More...", button_press, 1);
    w.get_button (16, 13, "   Ok   ", button_press, 2);
    w.get_button (16, 25, " Cancel ", button_press, 3);
    w.get_button (16, 37, "  Help  ", button_press, 4);

    w.read ();
}

void Advanced_Code (Options_s *opt)
/*
 * Prompt the user for advanced code options
 */
{
    char
        *float_radio[] = {"None     ",
                          "Emulation",
                          "8087     ",
                          "80287    "},
        *inst_radio[]  = {"8088/8086",
                          "80186    ",
                          "80286    "};



    WinObj w;
    w.open (5, 14, 19, 65, W_SINGLE, _LGREY|BLACK, _LGREY|WHITE);
    w.title ("Advanced Code Generation");
    w.shadow ();
    w.puts (1, 1, "Floating Point");
    w.puts (7, 1, "Instruction Set");
    w.puts (1, 19, "Options");
    w.puts (10, 20, "Far Data Threshold");

    w.set_attr (_CYAN|BLACK);
    w.box (2, 1, 5, 16, W_SPACES, 1);
    w.box (8, 1, 10, 16, W_SPACES, 1);
    w.box (2, 19, 8, 48, W_SPACES, 1);

    w.set_getattr (_CYAN|WHITE);
    w.get_radio (2, 2, float_radio, opt->float_selected, 4);
    w.get_checkbox (2, 20, "Generate underbars     ", opt->under_bars);
    w.get_checkbox (3, 20, "Line numbers debug info", opt->line_numbers);
    w.get_checkbox (4, 20, "Debug info in OBJs     ", opt->debug_in_obj);
    w.get_checkbox (5, 20, "Fast floating point    ", opt->fast_float);
    w.get_checkbox (6, 20, "Fast huge pointers     ", opt->fast_huge);
    w.get_checkbox (7, 20, "Generate COMDEFs       ", opt->comdefs);
    w.get_checkbox (8, 20, "Automatic far data     ", opt->far_data);
    w.get_radio (8, 2, inst_radio, opt->inst_set, 3);

    w.set_getattr (_GREEN|BLACK);
    w.get (10, 40, opt->data_threshold, 5);

    w.set_getattr (_BLUE|YELLOW);
    w.get_button (12, 13, "   Ok   ", button_press, 2);
    w.get_button (12, 25, " Cancel ", button_press, 3);
    w.get_button (12, 37, "  Help  ", button_press, 4);

    w.read ();
}


void Linker (Options_s *opt)
/*
 * Get linker options from the user
 */
{
    char
        *map_file_radio[] = { "Off     ", 
                              "Segments", 
                              "Publics ", 
                              "Detailed"},
        *output_radio[] = { "Standard DOS EXE", 
                            "Overlaid DOS EXE", 
                            "Windows EXE     ",
                            "Windows DLL     "};

    WinObj w;
    w.open (3, 11, 20, 68, W_SINGLE, _LGREY|BLACK, _LGREY|WHITE);
    w.title ("Linker");
    w.shadow ();
    w.puts (1, 1, "Map File");
    w.puts (7, 1, "Output");
    w.puts (1, 27, "Options");
    w.puts (12, 28, "Code Pack Size");
    w.puts (13, 28, "Segment Alignment");
    w.set_attr (_CYAN|BLACK);
    w.box (2, 1, 5, 17, W_SPACES, 1);
    w.box (8, 1, 11, 22, W_SPACES, 1);
    w.box (2, 27, 9, 54, W_SPACES, 1);

    w.set_getattr (_CYAN|WHITE);
    w.get_radio (2, 2, map_file_radio, opt->map_file_selected, 4);
    w.get_radio (8, 2, output_radio, opt->lnk_output_selected, 4);

    w.get_checkbox (2, 28, "Initialize Segments   ", opt->init_segments);
    w.get_checkbox (3, 28, "Default Libraries     ", opt->default_libs);
    w.get_checkbox (4, 28, "Graphics Library      ", opt->graphics_lib);
    w.get_checkbox (5, 28, "Warn duplicate symbols", opt->dup_symbols);
    w.get_checkbox (6, 28, "no Stack warning      ", opt->no_stack);
    w.get_checkbox (7, 28, "Case Sensitive Link   ", opt->case_link);
    w.get_checkbox (8, 28, "Case Sensitive Exports", opt->case_exports);
    w.get_checkbox (9, 28, "Pack code segments    ", opt->pack_code);

    w.set_getattr (_GREEN|BLACK);
    w.get (12, 46, opt->pack_size, 5);
    w.get (13, 46, opt->segment_align, 5);

    w.set_getattr (_BLUE|YELLOW);
    w.get_button (15, 1, "   Ok   ", button_press, 2);
    w.get_button (15, 14, " Cancel ", button_press, 3);
    w.get_button (15, 27, "  Help  ", button_press, 4);

    w.read ();
}

void Debugger (Options_s *opt)
/*
 * Get debuger options from the user
 */
{
    char
        *source_radio[] =   { "On        ",
                              "Standalone",
                              "None      "},
        *display_radio[]=   { "None  ",
                              "Smart ",
                              "Always"},
        *decimal_radio[] =  { "Show decimal",
                              "Show hex    ",
                              "Show both   "};

    WinObj w;
    w.open (3, 14, 16, 66, W_SINGLE, _LGREY|BLACK, _LGREY|WHITE);
    w.title ("Debugger");
    w.shadow ();
    w.puts (1, 1, "Source Debugging");
    w.puts (6, 1, "Display Swapping");
    w.puts (1, 19, "Inspectors");
    w.puts (9, 19, "Program Heap Size");
    w.puts (10,27, "K bytes");

    w.set_attr (_CYAN|BLACK);
    w.box (2, 1, 4, 16, W_SPACES, 1);
    w.box (7, 1, 9, 16, W_SPACES, 1);
    w.box (2, 19, 3, 38, W_SPACES, 1);
    w.box (5, 19, 7, 38, W_SPACES, 1);

    w.set_getattr (_CYAN|WHITE);
    w.get_radio (2, 2, source_radio, opt->source_debug_selected, 3);
    w.get_radio (7, 2, display_radio, opt->swapping_selected, 3);

    w.get_checkbox (2, 20, "Show inherited", opt->show_inherited);
    w.get_checkbox (3, 20, "Show methods", opt->show_methods);

    w.get_radio (5, 20, decimal_radio, opt->decimal_hex_selected, 3);

    w.set_getattr (_GREEN|BLACK);
    w.get (10, 19, opt->program_heap, 4);

    w.set_getattr (_BLUE|YELLOW);
    w.get_button (2, 42, "   Ok   ", button_press, 2);
    w.get_button (5, 42, " Cancel ", button_press, 3);
    w.get_button (8, 42, "  Help  ", button_press, 4);

    w.read ();
}

void Screen_Open ()
{
    /*
     * Open a window to cover the screen
     */
	static WinObj Main;
    int bkground = _BLACK;

    if (!VGA_blinkstate ())
        bkground = _DGREY;

	Main.open (0, 0, 24, 79, W_NOBORDER, bkground|LGREY);

	for (int x = 0; x < 54; x++)
		Main.printf ("- LVS Windows -- Lake View Software -");

    /*
     * Title the top of the screen
     */

    static WinObj title_win;

    bkground = _LGREY|BLUE;
    if (!VGA_blinkstate ())
        bkground = _WHITE|BLUE;
        
    title_win.open (0, 0, 0, 79, W_NOBORDER, bkground);
	title_win.center (0, "Lake View Software Demo2");


    /*
     * Display the logo
     */
    static WinObj logo;

    bkground = _BLACK;

    if (!VGA_blinkstate ())
        bkground = _DGREY;

    logo.open (19, 19, 22, 59, W_DOUSIN, 
               bkground|WHITE, bkground|YELLOW);
    logo.shadow ();

    logo.title (logo.get_version ());
    logo.center (0, "The C++ window class system");
    logo.center (1,"Copyright (c) 1992");
}

static WinObj clock_win;

void show_time ()
{
    struct Win_time_s t;
    static unsigned char hold;

    if (!clock_win.is_open())       // open clock window once
		{
        clock_win.open (0, 0, 0, 79, W_NOBORDER, _LGREY|BLUE);
		clock_win.center (0, "Lake View Software");
		}

    /*
     * First show the clock
     */

    Win_gettime (&t);

    if (hold != t.sec) 
        {
        hold = t.sec;
        clock_win.printf (0, 1, "%02d:%02d:%02d", t.hour, t.min, t.sec);
        #ifdef __TURBOC__
        clock_win.printf (0, 73, "%6ld", (long )coreleft ());  // show free mem
        #endif
        }
}

