//========================================================================
//  The following example routines have been provided by the Technical
//  Support staff at Borland International.  They are provided as a
//  courtesy and not as part of a Borland product, and as such, are
//  provided without the assurance of technical support or any specific
//  guarantees.
//========================================================================
//  Turbo Vision - Creating a TListBox
//
//  - This sample code demonstrates one method of creating a simple list
//  box which is inserted into a dialog box.
//
//  - Creating a simple list box is requires an associated scroll bar
//  and a list to display.  This example uses a list of the Turbo Vision
//  classes to display.
//  - Also demostrating how to use the double click message.
//------------------------------------------------------------------------
#define Uses_TApplication
#define Uses_TBackground
#define Uses_TButton
#define Uses_TKeys
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TListBox
#define Uses_TMenu
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TRect
#define Uses_TScrollBar
#define Uses_TStaticText
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TStringCollection
#define Uses_MsgBox
#define Uses_TEventQueue
#include <tv.h>
#include <stdlib.h>
#include <strstrea.h>

const cmAboutCmd = 100;  // User selected menu item 'About'
const cmListCmd  = 101;  // User selected menu item 'List'

char *theList[] =
{
    "fpbase",             "fpstream",           "ifpstream",
    "Int11trap",          "iopstream",          "ipstream",
    "MsgBoxText",         "ofpstream",          "opstream",
    "otstream",           "pstream",            "TApplication",
    "TBackground",        "TBufListEntry",      "TButton",
    "TChDirDialog",       "TCheckBoxes",        "TCluster",
    "TCollection",        "TColorDialog",       "TColorDisplay",
    "TColorGroup",        "TColorGroupList",    "TColorItem",
    "TColorItemList",     "TColorSelector",     "TCommandSet",
    "TCrossRef",          "TDeskInit",          "TDeskTop",
    "TDialog",            "TDirCollection",     "TDirEntry",
    "TDirListBox",        "TDisplay",           "TDrawBuffer",
    "TEditor",            "TEditWindow",        "TEventQueue",
    "TFileCollection",    "TFileDialog",        "TFileEditor",
    "TFileInfoPane",      "TFileInputLine",     "TFileList",
    "TFrame",             "TGroup",             "THelpFile",
    "THelpIndex",         "THelpTopic",         "THelpViewer",
    "THelpWindow",        "THistInit",          "THistory",
    "THistoryViewer",     "THistoryWindow",     "THWMouse",
    "TIndicator",         "TInputLine",         "TLabel",
    "TListBox",           "TListViewer",        "TMemo",
    "TMenu",              "TMenuBar",           "TMenuBox",
    "TMenuItem",          "TMenuView",          "TMonoSelector",
    "TMouse",             "TNSCollection",      "TNSSortedCollection",
    "TObject",            "TPalette",           "TParagraph",
    "TParamText",         "TPoint",             "TPReadObjects",
    "TProgInit",          "TProgram",           "TPWObj",
    "TPWrittenObjects",   "TRadioButtons",      "TRect",
    "TResourceCollection","TResourceFile",      "TScreen",
    "TScrollBar",         "TScroller",          "TSItem",
    "TSortedCollection",  "TSortedListBox",     "TStaticText",
    "TStatusDef",         "TStatusItem",        "TStatusLine",
    "TStreamable",        "TStreamableClass",   "TStreamableTypes",
    "TStrIndexRec",       "TStringCollection",  "TStringList",
    "TStrListMaker",      "TSubMenu",           "TSystemError",
    "TTerminal",          "TTextDevice",        "TView",
    "TVMemMgr",           "TWindow",            "TWindowInit"
};

int numStrings = sizeof(theList) / sizeof(theList[0]);

class TMyApplication : public TApplication
{
public:
    TMyApplication();
    static TMenuBar *initMenuBar(TRect);
    void handleEvent(TEvent &);
private:
    void aboutDlg();
    void listDlg();
};


//
// TMyApplication - Constructor.
//

TMyApplication::TMyApplication() :
    TProgInit(&TApplication::initStatusLine,&TMyApplication::initMenuBar,
              &TApplication::initDeskTop)
{
}


//
// initMenuBar - Initialize the menu bar.
//

TMenuBar *TMyApplication::initMenuBar(TRect bounds)
{
    bounds.b.y = bounds.a.y + 1;
    return(new TMenuBar(bounds,
        new TMenu(
            *new TMenuItem("~A~bout",cmAboutCmd,kbAltA,hcNoContext,0,
             new TMenuItem("~L~ist",cmListCmd,kbAltL,hcNoContext,0)))));
}


//
// handleEvent - Handle various events for TApp (menu commands).
//

void TMyApplication::handleEvent(TEvent &event)
{
    TApplication::handleEvent(event);

    if (event.what == evCommand)
    {
        switch (event.message.command)
        {
            case cmAboutCmd:
            {
                aboutDlg();
                clearEvent(event);
                break;
            }
            case cmListCmd:
            {
                listDlg();
                clearEvent(event);
                break;
            }
        }
    }
}


//
// aboutDlg - The about dialog box for TApplication. (Who, When, and What).
//

void TMyApplication::aboutDlg()
{
    TDialog *pd = new TDialog(TRect(0,0,35,12),"About");
    if (pd)
    {
        pd->options |= ofCentered;
        pd->insert(new TStaticText(TRect(1,2,34,7),
                   "\003Turbo Vision Example\n\003\n"
                   "\003Creating a TListBox\n\003\n"
                   "\003Borland Technical Support"));
        pd->insert(new TButton(TRect(3,9,32,11),"~O~k",cmOK,bfDefault));

        if (validView(pd) != 0)
        {
            deskTop->execView(pd);

            destroy(pd);
        }
    }
}

class TMyListBox : public TListBox
{
public:
    TMyListBox(TRect& bounds,ushort num,TScrollBar *bar) :
        TListBox(bounds,num,bar) {};
    void handleEvent(TEvent&);
};

void TMyListBox::handleEvent(TEvent& event)
{
    if ((event.what == evMouseDown) && (event.mouse.doubleClick))
    {
        message(owner,evBroadcast,cmListItemSelected,this);
        clearEvent(event);
    }
    TListBox::handleEvent(event);
}

class TListDlg : public TDialog
{
public:
    TListDlg(TRect&,char *);
    void handleEvent(TEvent&);
    TMyListBox *listBox;
};

TListDlg::TListDlg(TRect& bounds,char *aTitle) :
        TDialog(bounds,aTitle),
        TWindowInit(&TListDlg::initFrame)
{
    TStringCollection *theCollection = new TStringCollection(100,10);

    for(int i=0;i < numStrings;i++)
    {
        theCollection->insert(newStr(theList[i]));
    }


    options |= ofCentered;
    eventMask |= evBroadcast;

    TScrollBar *listScroller = new TScrollBar(TRect(47,2,48,17));

    listBox = new TMyListBox(TRect(3,2,47,17),2,listScroller);

    listBox->newList(theCollection);

    insert(listBox);
    insert(listScroller);

    insert(new TButton(TRect(22,19,30,21),"~O~K",cmOK,bfDefault));

    selectNext(False);
}


void TListDlg::handleEvent(TEvent& event)
{
    if ((event.what == evBroadcast) && (event.message.command == cmListItemSelected))
    {
        char selItem[81];
        char message[201];

        listBox->getText(selItem,listBox->focused,80);

        ostrstream(message,200) << "\003The item selected was " << selItem
                                << ends;

        messageBox(message,mfOKButton | mfInformation);
    }
    TDialog::handleEvent(event);
}


//
// listDlg - A dialog box to demostrate a list box.
//

void TMyApplication::listDlg()
{
    TListDlg *pd = new TListDlg(TRect(0,0,50,23),"TV Classes");

    if (validView(pd) != 0)
    {
        deskTop->execView(pd);

        destroy(pd);
    }
}


//
// main:
//      Here we declare an instance of the application object and call the
//      run() member function to start of the program.  Usually, this will be
//      all that is done here.  (Certain other initializations, like getting
//      EMS memory for the overlay manager would also go here.)
//

int main(void)
{
    TMyApplication myApplication;

    myApplication.run();

    return 0;
}
