#include <stream.hpp>
#include <string.h>
#include "lookup.hpp"

extern RET_TYPE
	a(ARG_TYPE),
	b(ARG_TYPE),
	c(ARG_TYPE),
	help(ARG_TYPE),
	oops(ARG_TYPE);

entry list[] = {
  (char *)4, &oops,
  "acmd", &a,
  "bcmd", &b,
  "c", &c,
  "help", &help,
  };

int main(int argc, char *argv[])
  {
  char *progname = argv[0];
  lookup command(list);
  char word[200]; // of type ARG_TYPE
  int i;

  argc--; // to shut up CC

  while(cout << "% ", cin >> word && strcmp(word, "quit"))
    {

    // Note that in the next statement, we are in
    // fact saying command[const char *](ARG_TYPE)
    // In this case, ARG_TYPE *is* const char *, so we 
    // are just passing the same thing to both [] and ().

    if(i = command[word](word))
      {
      // the function returned a non-zero result
      cerr << form("%s: %s returned %d\n", progname, word, i);
      }
    }
  return 0;
  }
