/*************************** 08/21/90 01:55pm ********************************
 *
 * PROGRAM:	LOCATENV.C
 * PURPOSE: LOCATE MASTER ENVIRONMENT
 * BY:	PETER A. HYMAN (71270,1405)
 *
 * STRATEGY: LOCATE MASTER PSP, THEN FOR DOS < 3.3
 *           DETERMINE LOCATION OF NEXT MEMORY BLOCK OR FOR DOS >= 3.3
 *           READ OFFSET 0X2C IN PSP
 * 					 TO GET LOCATION OF MASTER ENVIRONMENT
 *
 * I LOCATE THE MASTER PSP BY REFERENCING A VECTOR AT MEMORY LOCATION 0XBA
 * OTHERS USE AN UNDOCUMENTED DOS FUNCTION (0X52) TO LOCATE THE FIRST MEMORY
 * CONTROL BLOCK (MCB) WHICH OCCURS JUST BEFORE ANY DEVICE DRIVERS ARE LOADED.
 * COMPUTING THE OFFSET FROM THIS MCB WILL LEAVE YOU 2 PARAGRAPHS BEFORE THE
 * MCB BEFORE THE MASTER PSP.
 * 
 * 
 * COMPILER USED LATTICE 6.05
 *****************************************************************************/

#include <stdio.h>
#include <dos.h>

/*****************************************************************************
 *                               --- main ---
 *
 *****************************************************************************/
main()
{
	unsigned char DOSVER[2];                       /* array for DOS version */
	unsigned char buffer[2];                       /* holding pen for peeks */
	unsigned psp_seg, env_seg, env_size;           /* segment locations of PSP and environment */
																								 /* and environment size */
	unsigned tseg;                                 /* temporary work variable */
	union REGSS regs;                              /* registers for DOS function calls */

	/* first get DOS version */
	regs.h.ah = 0x30;

	/* LATTICE FUNCTION TO CALL DOS */
	intdoss( &regs, &regs );                       /* DOS version returned in AX */

	DOSVER[0] = regs.h.al;                         /* DOS Major Version */
	DOSVER[1] = regs.h.ah;                         /* DOS Minor Version */

	printf( "DOS Version = %1d.%2d\n", DOSVER[0], DOSVER[1] );

	/* GET MASTER PSP LOCATION VECTOR AT 0000:00BA */

	peek( 0, 0xba, buffer, 2 );                    /* peek into buffer */
	psp_seg = ( buffer[1] * 0x100 ) + buffer[0];   /* compute PSP */

  /***************************************************************************
	 * OR USE THIS CODE TO GET MASTER PSP LOCATION VIA INT 0X21 FUNCTION 0X52
	 * 
	 * regs.h.ah = 0x52;
	 * intdoss( &regs, &regs );                    /* es:bx points to internal DOS table */                      
	 *                                             /* two bytes before is location of first MCB */                                                                                       
	 * peek( regs.x.es, regs.x.bx-2, buffer, 2 );
	 * tseg = ( buffer[1] * 0x100 ) + buffer[0];
	 * peek( tseg, 3, buffer, 2 );                 /* offset of next MCB - 32 */                
	 * psp_seg = tseg + (buffer[1] * 0x100) + buffer[0] + 2;
	 *                                             /* AT THIS POINT tseg = psp_seg BELOW */ 
	 *
   ***************************************************************************/
	printf( "Master PSP Location = %04X:0000\n", psp_seg );

	/* LOCATE ENVIRONMENT IF DOS < 3.30 */

	if ( ( DOSVER[0] == 3 && DOSVER[1] < 30 ) || DOSVER[0] < 3 )
	{
		/* LOCATE MCB AND COMPUTE OFFSET OF NEXT MEMORY BLOCK WHICH
		 *  WILL BE THE ENVIRONMENT LOCATION */
		tseg = psp_seg - 1;
		peek( tseg, 3, buffer, 1 );                  /* get location of next MCB */
		tseg += buffer[0];
	}
	else                                           /* we have DOS 3.3 and over */
	{
		peek( psp_seg, 0x2c, buffer, 2 );            /* load Environment segment MCB */
		tseg = ( buffer[1] * 0x100 ) + buffer[0] - 1;
	}
	env_seg = tseg+1;

	/* COMPUTE ENVIRONMENT SIZE */

	peek( tseg, 3, buffer, 2 );
	env_size = ( buffer[1] * 0x100 ) + ( buffer[0] * 0x10 );

	printf( "Master Environment Location = %04X:0000\n", env_seg );
	printf( "Maximum Environment Length = %u\n", env_size );

/*****************************************************************************
 * AT THIS POINT, YOU COULD MAKE A DATA VECTOR POINTING TO THE ENV SEGMENT
 * AND MANIPULATE THE VARIABLES DIRECTLY.  BE SURE THAT EACH ENV STRING IS
 * NULL TERMINATED AND THAT TWO NULL BYTES ARE AT THE END OF THE ARRAY OF
 * ENVIRONMENT STRINGS
******************************************************************************/
}




