
/**

     tree.h -- tree function header file

**/

#define BOOLEAN int
#define TRUE 1
#define FALSE 0

#define MALLOC(x)   ((x *) malloc(sizeof(x)))
#define CALLOC(n,x) ((x *) calloc(n,sizeof(x)))

/*
 * the calling program must declare a structure of type "T_DATA"
 * that serves as the data for each node of the tree.  Note also
 * that the traversal functions (preorder, inorder, postorder)
 * expect to be passed a pointer to a function that will be
 * executed each pass through the ordering function.
 */

struct NODE
     { struct T_DATA *N_DATA;
       struct NODE *L_CHILD;
       struct NODE *R_CHILD;
       struct NODE *PARENT;
     };
typedef struct NODE NODE_T;

#ifndef NARGS
extern char *malloc(unsigned);
extern char *calloc(unsigned,unsigned);
extern NODE_T *inst_node(struct T_DATA *,NODE_T *);
extern NODE_T *inst_tree(struct T_DATA *);
extern int add_child(NODE_T *, struct T_DATA *);
extern int adopt(NODE_T *, NODE_T *);
extern NODE_T *find_root(NODE_T *);
BOOLEAN is_leaf(NODE_T *);
BOOLEAN is_root(NODE_T *);
void preorder(NODE_T *, void (*)(NODE_T *));
void inorder(NODE_T *, void (*)(NODE_T *));
void postorder(NODE_T *, void (*)(NODE_T *));
#else
extern char *malloc();
extern char *calloc();
extern NODE_T *inst_node();
extern NODE_T *inst_tree();
extern int add_child();
extern int adopt();
extern NODE_T *find_root();
BOOLEAN is_leaf();
BOOLEAN is_root();
void preorder();
void inorder();
void postorder();
#endif
