/**

     llist.h -- header file for doubly linked list functions

     version 1.0, 11/86, B. DuBose

**/

#define BOOLEAN int
#define TRUE 1
#define FALSE 0
#define L_ERROR -1

/*
 * Define NULL if it's not already defined
 */
#ifndef NULL
#if SPTR
#define NULL 0           /* null pointer value */
#else
#define NULL 0L
#endif
#endif

#ifndef NARGS
extern char *malloc(unsigned);
extern char *calloc(unsigned,unsigned);
extern int free(char *);
#else
extern char *malloc();
extern char *calloc();
extern int free();
#endif

#define MALLOC(x)   ((x *) malloc(sizeof(x)))
#define CALLOC(n,x) ((x *) calloc(n,sizeof(x)))

struct HEAD                             /* header of list */
     { int L_LENGTH;                    /* number of links */
       struct LINK *L_FIRST, *L_LAST;   /* pointers to first, last links */
     };
typedef struct HEAD HEAD_T;

struct LINK                             /* element of list */
     { struct LINK *L_PREV;             /* previous link */
       struct LST_DATA *L_DATA;         /* this structure user-supplied */
       struct LINK *L_NEXT;             /* next link */
     };
typedef struct LINK LINK_T;


#ifndef NARGS
extern HEAD_T *inst_list();
extern LINK_T *inst_link(struct LST_DATA *, LINK_T *, LINK_T *);
extern BOOLEAN add_first(struct LST_DATA *, HEAD_T *);
extern BOOLEAN add_last(struct LST_DATA *, HEAD_T *);
extern BOOLEAN add_after(struct LST_DATA *, HEAD_T *, int);
extern struct LST_DATA *del_first(HEAD_T *);
extern struct LST_DATA *del_last(HEAD_T *);
extern struct LST_DATA *del_link(HEAD_T *, int);
extern int del_from_to(HEAD_T *, int, int, void (*)(struct LST_DATA *));
extern void rdel_from_to(HEAD_T *, int, int, void (*)(struct LST_DATA *));
extern BOOLEAN merge_after(HEAD_T *, HEAD_T *, int);
extern HEAD_T *split_list(HEAD_T *, int, int);
extern BOOLEAN move_list(HEAD_T *, HEAD_T *, int, int, int);
extern void free_links(LINK_T *);
extern void purge_list(HEAD_T *);
#else
extern HEAD_T *inst_list();
extern LINK_T *inst_link();
extern BOOLEAN add_first();
extern BOOLEAN add_last();
extern BOOLEAN add_after();
extern struct LST_DATA *del_first();
extern struct LST_DATA *del_last();
extern struct LST_DATA *del_link();
extern int del_from_to();
extern void rdel_from_to();
extern BOOLEAN merge_after();
extern HEAD_T *split_list();
extern BOOLEAN move_list();
extern void free_links();
extern void purge_list();
#endif

