
/*
*	This program is a combination of the Comp-U-Serve files
*					SHADE.TXT
*					SPU12.ARC
*	along with modifications for printing C source code on a LaserJet Series II.
*
*	Since the source and suggestions were public domain, this file and 
*	source are released to public domain.
*
*	The source code is for Microsoft C 6.0.

*  As was said in the files used to create this program:
*					Enjoy !!!
*/


/*  ljl.c  */

#include <dos.h>
#include <stdio.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <string.h>
#include <time.h>


/*
Commands for:
   ---------------------------------------------------------------
    H P   L A S E R J E T   S E R I E S   I I   L A N D S C A P E
   ---------------------------------------------------------------
*/

#define LPP			57								/*  Lines Per Page  */
#define HMW			106							/*  Header Maximum Width  */
#define PNAME		"HPLJ II (landscape)"	/*  printer description  */
#define SEPCHAR	0xB3							/*  separates line #'s from text  */
#define TMW			88								/*  Text Maximum Width  */

char HDRFONT[]  = {0x1B, 0x28, 0x73, 0x33, 0x54,			/* courier font    */
		   0x1B, 0x26, 0x6B, 0x30, 0x53, 0x00};				/* 10 pitch        */
char NO_ULINE[] = {0x1B, 0x26, 0x64, 0x40, 0x00};			/* underline off   */
char RESET[]    = {0x1B, 0x45, 0x00};							/* reset printer   */
char SETUP[]    = {0x1B, 0x28, 0x31, 0x30, 0x55,			/* IBM PC char set */
                   0x1B, 0x26, 0x6C, 0x31, 0x4F,			/* landscape       */
                   0x1B, 0x26, 0x6C, 0x38, 0x44, 0x00};	/* 8 lines per inch*/
char TXTFONT[]  = {0x1B, 0x26, 0x6B, 0x32, 0x53, 0x00};	/* lineprinter font*/
char ULINE[]    = {0x1B, 0x26, 0x64, 0x44, 0x00};			/* underline on    */

#define FATTR     _A_ARCH|_A_HIDDEN|_A_RDONLY|_A_SYSTEM
#define MAXCHAR   512		/* Maximum number of chars per record  */
#define OFF       0
#define ON        1
#define TABVAL    3			/* Tab stops every 3 characters  */
#define VERSION   "1.3"

void detab(), heading(), blurb(), get_fdate(), prn_cmd(), usage(), shade();
void check_line_count();
char inrec[2 * MAXCHAR], date[16];
int len, line, linesout, pnum, status;
struct find_t finfo;


/***********************************************************************/
void main(argc, argv)
int argc;
char *argv[];
	{
	FILE *fpin;
	blurb();
	if (argc<2)
		{
		usage();
		exit(0);
		}
	fflush(stdprn);
	prn_cmd(RESET);
	prn_cmd(SETUP);
	while (--argc)
		{
		status = _dos_findfirst(*++argv, FATTR, &finfo);
		while (!status)
			{
			if ((fpin=fopen(finfo.name,"r")) != NULL)
				{
				fprintf (stdprn, "\033&a+0L");	/* start with zero left margin  */
				line = linesout = pnum = 0;		/* initialize counters */
				get_fdate(finfo.name, date);
				strupr(*argv);
				while (fgets(inrec,MAXCHAR,fpin)!=NULL)
					{
					line++;
					detab(inrec);
					len = strlen(inrec);
					if (pnum == 0)
						check_line_count();
					fprintf(stdprn, "%4d%c  %.*s\r",line,SEPCHAR,TMW-7, inrec);
					linesout++;
					check_line_count();
					while (len>(TMW-7))
						{
						memmove(inrec,&inrec[TMW-7],len-(TMW-8));
						len = strlen(inrec);
						if ((linesout%LPP) !=0)
							fprintf(stdprn, "\n");
						fprintf(stdprn, "    %c  %.*s\r",SEPCHAR,TMW-7, inrec);
						linesout++;
						check_line_count();
						}
					printf("%s  line %d...\r",finfo.name,line);
					}
				fprintf(stdprn,"\f");
				printf("%s done, %d page%s printed.\n",finfo.name,pnum,
					pnum>1 ? "s" : "");
				fclose(fpin);
				}
			else 
				printf("%s - unable to open.\n",finfo.name);
			status = _dos_findnext(&finfo);
			}
		}
		prn_cmd(RESET);
	}


/***********************************************************************/
void blurb()
	{
	printf("HP LaserJet II  -  Source Print Utility - version %s (%s)\n",
		VERSION, __DATE__);
	printf("<<< configured for %s >>>\n\n",PNAME);
	}


/***********************************************************************/
/*  routine to test the string for tabs and non-printing ASCII characters
    and terminate string with a NULL  */

void detab(str)
char *str;
	{
	int cntin, cntout;
	char tmpstr[2 * MAXCHAR];

	cntin = cntout = 0;
	while (cntin < (MAXCHAR+1)  &&
		str[cntin] != '\0'	&&
		str[cntin] != '\n' )
		{
		if (str[cntin] > 0x1F && str[cntin] < 0x7F)  /*  printing characters  */
			strcpy( &tmpstr[cntout++], &str[cntin++] );
		else
			{
			switch (str[cntin])
				{
				case '\t':		/*  check for tab character  */
					tmpstr[cntout++] = ' ';				/*  TAB,  fill out with spaces  */
					while (cntout % TABVAL) 
						tmpstr[cntout++] = ' ';
					cntin++;
					break;
				default:
					tmpstr[cntin++] = 0x2;		/*  print smiley face  */
					cntout++;
					break;
				}
			}
		}
	tmpstr[cntout++] = '\n'; /*	put line feed on string	*/
	tmpstr[cntout] = '\0';	/*  put NULL character on end of string	*/
	strcpy(str, tmpstr); 	/*	back copy corrected string  */
	}


/***********************************************************************/
void get_fdate(fname, dstr)
char *fname,*dstr;
	{
	struct stat fdate;
	char tmpstr[26];
	if (!stat(fname, &fdate))
		{
		strcpy(tmpstr,ctime(&fdate.st_atime));
		sprintf(dstr,"%.2s-%.3s-%.2s %.5s",&tmpstr[8],&tmpstr[4],&tmpstr[22],
			&tmpstr[11]);
		}
	else 
		*dstr = '\0';
	}


/***********************************************************************/
void heading(fname,page,dstr)
char *fname;
int page;
char *dstr;
	{
	int tmpint;
	if (page>1)
		fprintf(stdprn,"\f");
	shade();							/*  do shading  */
	tmpint = 16;
	/*	Cursor to (0,0) dots  */
	fprintf (stdprn, "\033*p0x0Y");
	prn_cmd(HDRFONT);
	prn_cmd(ULINE);
	fprintf(stdprn,"                  Page %-3d                %*s"
      "             Page  %-3d         %*s \r\n\n",
		page, tmpint, fname, page+1, tmpint, dstr);
	prn_cmd(NO_ULINE);
	prn_cmd(TXTFONT);
	}


/***********************************************************************/
void prn_cmd(cmd)
char *cmd;
	{
	fputs(cmd,stdprn);
	}


/***********************************************************************/
void usage()
	{
	puts("Usage:   LJL file1 <file2> <fileN>\n");
	}


/***********************************************************************/
void shade()
	{
	int i;
	/* move cursor to (0,0) dots	*/
	fprintf (stdprn, "\033*p0x0");
	/* define a box: 11" x 1/4", 10% shading  (300 dots/in)  */
	fprintf (stdprn, "\033&f0S\033*p0x0Y\033*c3300a187b10G");
	/* move cursor down one line	*/
	fprintf (stdprn, "\033&a+1R");
	/*	print shaded boxes	*/
	for (i=1; i <= 6; i++)
		fprintf (stdprn, "\033*c2P\033&a+10R");
	fprintf (stdprn, "\033&f1S");
	}


/***********************************************************************/
void check_line_count()
	{
	/*  Test for a mulitple of two pages  */
	if ((linesout%(LPP*2))==0)
		{
		/*  yes, a multiple of two pages  */
		fprintf (stdprn, "\033&a+0L");		/*  set left margin to zero  */
		heading(finfo.name,++pnum,date);		/*  print heading  */
		}

	/*  Test for odd page ??  */
	if (((linesout%LPP)==0) && (linesout%(LPP*2)) != 0)
		{
		/*  odd, prepare to move to right column  */
		pnum++;	    /*  increment page number  */
		/*  Cursor to (0,77) dots  */
		fprintf (stdprn, "\033*p0x77Y");
		/*  left margin to 88th column  */
		fprintf (stdprn, "\033&a+88L");
		}
	}
