#include <stdio.h>
#include <string.h>
#include <ctype.h>

FILE	*in;
char	string[240], *iptr, *jptr, fname[50];
int	j, linecnt, sloc, chead, delta, DEBUG;
double	total, source;

main(int argc, char *argv[])
{
	printf("C Source Counter (c) 1991 by E.Dong\n");
	printf("Counts compilable lines & total lines of C code\n\n");
	DEBUG = 0;			/* disabled for production version */
	argc--;argv++;
	if (argc)
		strcpy(fname,argv[0]);
		else
		{	if (DEBUG) strcpy(fname,"sloc.c");
			else
			{       printf("Syntax: LINECNT fname\n");
				exit(1);
			}
		}
	strupr(fname);
	in = fopen(fname,"rt");
	if (in==NULL)
	{	printf("Unable to access %s...aborting.\n",fname);
		exit(1);
	}
	linecnt = sloc = delta = chead = 0;
	while (!feof(in))
	{	setmem(string,sizeof(string),0);
		if (fgets(string,sizeof(string),in)==NULL) goto DONE;
		iptr = strchr(string,10); if (iptr!=NULL) *iptr = 0;
		iptr = strchr(string,13); if (iptr!=NULL) *iptr = 0;
		linecnt++;
		iptr = string;
SEARCH:		while (isspace(*iptr)&&*iptr) iptr++;	/* skip white space */
		if (*iptr==0) goto MORE;		/* if end of line */
		if (chead==0)		/* if not comment continuation */
		{       jptr = strstr(iptr,"/*");	/* find start of comment */
			if ((jptr!=iptr)&&(jptr!=NULL))	/* in-line comment */
				sloc++;
			if (jptr==NULL)			/* not found */
			{	sloc++;
				goto MORE;
			}
			else chead = 1;		/* flag start */
		}
		if (chead)
		{	jptr = strstr(iptr,"*/");	/* look for end */
			if (jptr!=NULL)
			{	chead = 0;
				jptr++; jptr++;	/* skip end */
				iptr = jptr;
				goto SEARCH;
			}
			goto MORE;
		}
		if (chead==0) continue;
		if (chead)		/* if start of a comment line found */
		{	jptr = strstr(iptr,"*/");	/* look for end */
			if (jptr == NULL)		/* if not found */
				continue;
			jptr++;	jptr++;			/* skip comment tail */

			chead = 0;			/* turn off flag */
			iptr = jptr;			/* point here */
			goto SEARCH;
		}
MORE:		if (linecnt == ((linecnt/10)*10))	/* display every 10 lines */
			printf("%s: Lines = %7d\tSLOC = %7d\r",fname,linecnt,sloc);
		if (linecnt != (sloc+delta))
		{       delta = linecnt - sloc;
			if (DEBUG)
			{	printf("\n%s\n\n",string);
				if (getch()==27) exit(0);
			}
		}
	}

DONE:	fclose(in);
	printf("%s: Lines = %7d\tSLOC = %7d\n",fname,linecnt,sloc);
	total = (linecnt);
	source = (sloc);
	printf("%4.1f%% Source/Total C Lines\n",((source/total)*100.0));
}
