/************************************************************************/
/*                  LilBook.cpp by Mike Laskie                        	*/
/*			   11/20/1993					*/
/*  This program shows how to make a dialog box	as a main window,	*/
/*  with full pulldown menus and also utilizes some custom buttons.	*/
/*  Demos use of Win 3.1 common dialog.                                 */
/*  Currently uses rudimentary data file stream access method.		*/
/*          (Paradox Engine 3.0 coming soon!)				*/
/************************************************************************/

#define	WIN31

#include "lilbkdlg.h"
#include <owl.h>
#include <bwcc.h>
#include <edit.h>
#include <dialog.h>
#include <bchkbox.h>

#include <stdio.h>
#include <share.h>
#include <string.h>
#include <commdlg.h>

FILE *hfLilfile;

// TApplication class
class TLilbookApp : public TApplication	    // Application Class to contain
   {					    // the application
   public:
      TLilbookApp(LPSTR aName, HANDLE hInstance,
   		 HANDLE hPrevInstance, LPSTR lpCmd, int nCmdShow)
   	      :TApplication(aName, hInstance,
			    hPrevInstance,lpCmd, nCmdShow) {};

      virtual void InitMainWindow(); // go override base class InitMainWindow
};


// TDialog class
_CLASSDEF(TMainWinDlg)                   // TMainWinDlg is user defined (me)
class TMainWinDlg : public TDialog 	 // processing for menu and
  {                                      // button selections
  public:				   

    // Data members
    TEdit *EdFName, *EdLName, *EdPhone, *EdBirth;
    HCURSOR hcrWait;
    TBCheckBox *EdChkBox;
    BOOL nChecked;
    int  nFlag, nFound;
    char szName[256];
    char szHoldstr[29];

    // Function Members
    TMainWinDlg(PTWindowsObject AParent, int ResourceId);
    virtual LPSTR GetClassName();
    virtual void GetWindowClass( WNDCLASS _FAR & aclass );
    void InitControls();
					// File I/O (coded at end of source)
    int  OpenLilFile();			// Open a .ldb file
    int  ReadRec(void);			// Read a record from the file
    int  WriteRec(void);		// Write a record from the file
    long GetCur(void);                  // Cursor Positioning...
    int  SetCur(long);
    void LilStepFor(void);
    void LilStepBak(void);
    void BigStepFor(void);
    void BigStepBak(void);

    int  DoSearch(void);
    void ClearMoFlags(void);
    void HitMe(void);
    void ClearPage(void);
    int  FetchData(void);

    // DDVT **

       // Menu Items
    virtual void CMFileNew(RTMessage)
      = [CM_FIRST + CM_FILENEW];

    virtual void CMUFileOpen( RTMessage )
      = [CM_FIRST + CM_U_FILEOPEN];

    virtual void HandleMenuExit(RTMessage)
      = [CM_FIRST + CM_MNU_EXIT];

    virtual void HandleMenuAbout(RTMessage Msg)
      = [CM_FIRST + CM_MNU_ABOUT];

    virtual void HandleMenuHelp(RTMessage Msg)
      = [CM_FIRST + CM_MNU_HELP];

       // Button responses
    virtual void HandleSaveButton(RTMessage Msg)
      = [ID_FIRST + ID_SAVE];

    virtual void HandleSearchButton(RTMessage Msg)
      = [ID_FIRST + ID_SEARCH];

    virtual void HandleSearchAgainButton(RTMessage Msg)
      = [ID_FIRST + ID_SEARCH_AGAIN];

    virtual void HandleWipeClearButton(RTMessage Msg)
      = [ID_FIRST + ID_WIPECLEAR];

    virtual void HandleForwardButton(RTMessage Msg)
      = [ID_FIRST + ID_FORWARD];

    virtual void HandleRewindButton(RTMessage Msg)
      = [ID_FIRST + ID_LIL_REWIND];

    virtual void HandleBackwardButton(RTMessage Msg)
      =	[ID_FIRST + ID_BACKWARD];

    virtual void HandleDeleteButton(RTMessage Msg)
      =	[ID_FIRST + ID_DELETE];

       // Check box
    void CheckUp(RTMessage)
      = [ID_FIRST + ID_UPDATE];

};

// TLilbookApp members ***

   // Init TLilbook's main window override as a dialog box
void TLilbookApp::InitMainWindow()
   {  			   		
   BWCCGetVersion();    		// Make sure BWCC.DLL gets loaded.
   MainWindow = new TMainWinDlg(NULL, LIL_DLG_MAIN);
 }


// TMainWinDlg members ***

   // Constructor **
TMainWinDlg::TMainWinDlg(PTWindowsObject AParent, int ResourceId)
	    :TDialog(AParent, ResourceId) {

   InitControls();
   nChecked = 0;
   nFound = 0;
}

   // Get Class Name **
LPSTR TMainWinDlg::GetClassName()  {
  return "bordlg_MainWinDlg";
}

   // Get Window Class **
void TMainWinDlg::GetWindowClass ( WNDCLASS _FAR & aclass ) {
   TDialog::GetWindowClass( aclass );
   aclass.lpfnWndProc = BWCCDefDlgProc;
   aclass.hIcon = LoadIcon(GetApplication()->hInstance, "LILBOOK_ICO");
}

   // InitControls **
void TMainWinDlg::InitControls() {
   // TEdit
   EdFName = new TEdit(this, LIL_FNAME, LEN_FNAME + 1);
   EdLName = new TEdit(this, LIL_LNAME, LEN_LNAME + 1);
   EdPhone = new TEdit(this, LIL_PHONE, LEN_PHONE + 1);
   EdBirth = new TEdit(this, LIL_BIRTHDAY, LEN_BIRTHDAY + 1);
   EdChkBox= new TBCheckBox(this, ID_UPDATE, NULL);
}

   // Fetch Data **
int TMainWinDlg::FetchData(void) {
   int nStartPos, nEndPos;
   int nFetchflag = 0;

   // Fetch Firstname
   if (EdFName->IsModified()) {
      nFetchflag = 1;
      memset(Book.FName, ' ', LEN_FNAME);
      EdFName->GetSelection(nStartPos, nEndPos);

      if ( nStartPos == nEndPos )
	EdFName->GetText(Book.FName, LEN_FNAME);
      else {
	EdFName->GetSubText(szHoldstr, nStartPos, nEndPos);
	nFetchflag = LIL_FNAME;
      }
   }

   // Fetch Lastname
   if (EdLName->IsModified()) {
      nFetchflag = 1;
      memset(Book.LName, ' ', LEN_LNAME);
      EdLName->GetSelection(nStartPos, nEndPos);

      if ( nStartPos == nEndPos )
	EdLName->GetText(Book.LName, LEN_LNAME);
      else {
	EdLName->GetSubText(szHoldstr, nStartPos, nEndPos);
	nFetchflag = LIL_LNAME;
      }
   }

   // Fetch Phone Number
   if (EdPhone->IsModified()) {
      nFetchflag = 1;
      memset(Book.Phone, ' ', LEN_PHONE);
      EdPhone->GetSelection(nStartPos, nEndPos);

      if ( nStartPos == nEndPos )
	EdPhone->GetText(Book.Phone, LEN_PHONE);
      else {
	EdPhone->GetSubText(szHoldstr, nStartPos, nEndPos);
	nFetchflag = LIL_PHONE;
      }
   }

   // Fetch Birthday
   if (EdBirth->IsModified()) {
      nFetchflag = 1;
      memset(Book.Birth, ' ', LEN_BIRTHDAY);
      EdBirth->GetSelection(nStartPos, nEndPos);

      if ( nStartPos == nEndPos )
	EdBirth->GetText(Book.Birth, LEN_BIRTHDAY);
      else {
	EdBirth->GetSubText(szHoldstr, nStartPos, nEndPos);
	nFetchflag = LIL_BIRTHDAY;
      }
   }

return (nFetchflag);
}

   // Hit Me **
void TMainWinDlg::HitMe(void) {
   EdFName->SetText(Book.FName);
   EdLName->SetText(Book.LName);
   EdPhone->SetText(Book.Phone);
   EdBirth->SetText(Book.Birth);
}


   // Clear Page **
void TMainWinDlg::ClearPage(void) {
   EdFName->SetText("");
   EdLName->SetText("");
   EdPhone->SetText("");
   EdBirth->SetText("");
   Book.FName[0] = NULL;
   Book.LName[0] = NULL;
   Book.Phone[0] = NULL;
   Book.Birth[0] = NULL;
   Book.DelFlag[0] = NULL;
}

   // Clear Modify Flags **
void TMainWinDlg::ClearMoFlags(void) {
   EdFName->ClearModify();
   EdLName->ClearModify();
   EdPhone->ClearModify();
   EdBirth->ClearModify();
}

  // Do Search **
int TMainWinDlg::DoSearch() {
   int len1, len2, hcrOld, nFound = 0;

   len1 = strlen(szHoldstr);
   hcrOld = SetCursor(hcrWait); // mouse cursor (hour glass on)
   char buf[80];

   while(ReadRec()) {

      switch(nFlag) {

	 case  LIL_FNAME:
		      strncpy(buf, Book.FName, len1);
		      buf[len1] = '\0';
		      len2 = stricmp(buf, szHoldstr);
		      if(len2 == 0)
			     nFound = 1;
		      break;
	 case  LIL_LNAME:
		      strncpy(buf, Book.LName, len1);
		      buf[len1] = '\0';
		      len2 = stricmp(buf, szHoldstr);
		      if(len2 == 0)
			     nFound = 1;
		      break;
	 case  LIL_PHONE:
		      strncpy(buf, Book.Phone, len1);
		      buf[len1] = '\0';
		      len2 = stricmp(buf, szHoldstr);
		      if(len2 == 0)
			     nFound = 1;
		      break;
	 case  LIL_BIRTHDAY:
		      strncpy(buf, Book.Birth, len1);
		      buf[len1] = '\0';
		      len2 = stricmp(buf, szHoldstr);
		      if(len2 == 0)
			     nFound = 1;
		      break;
	 default: break;
      }

      if(nFound)
	 if   (Book.DelFlag[0] != 'D') break;
	 else nFound = 0;

   }

   SetCursor(hcrOld); // return mouse cursor leftward pointer
   return(nFound);
}


   // DDVTs **

   // File New ** (clears Page)
void TMainWinDlg::CMFileNew(RTMessage) {
  ClearPage();
  EdChkBox->Uncheck();
  nChecked = 0;
}

   // File Open ** (Win 3.1 Common dlg Get file name)
void TMainWinDlg::CMUFileOpen(RTMessage) {
  OPENFILENAME ofnTemp;
  char szTemp[] = "Lil Book db Files (*.ldb)\0*.ldb\0All Files (*.*)\0*.*\0";
  szName[0] = NULL;

   ofnTemp.lStructSize = sizeof( OPENFILENAME );
   ofnTemp.hwndOwner = HWindow;		
   ofnTemp.hInstance = 0;
   ofnTemp.lpstrFilter = (LPSTR)szTemp;	
   ofnTemp.lpstrCustomFilter = NULL;
   ofnTemp.nMaxCustFilter = 0;
   ofnTemp.nFilterIndex = 1;
   ofnTemp.lpstrFile = (LPSTR)szName;	// Stores the result in this variable
   ofnTemp.nMaxFile = sizeof( szName );
   ofnTemp.lpstrFileTitle = NULL;
   ofnTemp.nMaxFileTitle = 0;
   ofnTemp.lpstrInitialDir = NULL;
   ofnTemp.lpstrTitle = NULL;      	// or Title; when not TDialog int resource
   ofnTemp.Flags = OFN_HIDEREADONLY | OFN_PATHMUSTEXIST; // | OFN_FILEMUSTEXIST |
   ofnTemp.nFileOffset = 0;
   ofnTemp.nFileExtension = 0;
   ofnTemp.lpstrDefExt = "ldb";
   ofnTemp.lCustData = NULL;
   ofnTemp.lpfnHook = NULL;
   ofnTemp.lpTemplateName = NULL;

   // If error
   if(GetOpenFileName( &ofnTemp ) != TRUE) {
      DWORD Errval;
      char Errstr[50]="GetOpenFileName returned Error #";
      char buf[5];

       Errval=CommDlgExtendedError();
      // 0 value means user selected Cancel
      if(Errval!=0) {
	 sprintf(buf,"%lx",Errval);
	 strcat(Errstr,buf);
	 MessageBox(HWindow,Errstr,"WARNING",MB_OK|MB_ICONSTOP);
      }
   }
   // Else open the file
   else {
      OpenLilFile();
   }
}

   // File Exit
void TMainWinDlg::HandleMenuExit(RTMessage) {
  CloseWindow(0);
}

   // Menu About
void TMainWinDlg::HandleMenuAbout(RTMessage) {
  GetApplication()->ExecDialog(new TDialog(this, LIL_DLG_ABOUT));
}


   // Help **
void TMainWinDlg::HandleMenuHelp(RTMessage) {
  GetApplication()->ExecDialog(new TDialog(this, LIL_DLG_HELP));
}

   // Handle Save Button *
void TMainWinDlg::HandleSaveButton(RTMessage) {
   if (FetchData()) {
      Book.DelFlag[0] = '\0';
      Book.crlf = 0x0A0D;
      if (!hfLilfile)
	 MessageBox(HWindow, "Open a File!", "Save",MB_OK);
      else {
	 if (nChecked)                 	// If update check box on
            // update a record
            LilStepBak();
         else 
            // write to end of file
	    BigStepFor();

	 WriteRec();
	 ClearMoFlags();
      }
   }
}

   // Button Bar ***

   // Handle Search button
void TMainWinDlg::HandleSearchButton(RTMessage) {
   long lCurpos;
   nFound = 0;				// fetch data sets flag to equal the
   if ((nFlag = FetchData()) > 1) {	// selected text's resouce ID
      if (hfLilfile == NULL)
	 MessageBox(HWindow, "Open a File!", "Search",MB_OK);
      else {
	 lCurpos = GetCur();
	 if(lCurpos < PAGE) lCurpos = PAGE; // could end up neg
	 BigStepBak();
	 nFound = DoSearch();
	 if (!nFound) {
	    SetCur(lCurpos);
	    LilStepBak();
	    ReadRec();
	    MessageBox(HWindow, "Selction not found!", "Search",MB_OK);
         }
	 HitMe();   // so good
      }

   }

}


   // Handle Search Again button
void TMainWinDlg::HandleSearchAgainButton(RTMessage) {
   long lCurpos;
   if (nFound) {
      lCurpos = GetCur();
      nFound = DoSearch();
      if (!nFound) {
	 SetCur(lCurpos);
	 LilStepBak();
	 ReadRec();
	 MessageBox(HWindow, "No more found!", "Search Again",MB_OK);
      }
      HitMe(); // HHHit me
   }

}


   // Handle Wipe Clear button *
void TMainWinDlg::HandleWipeClearButton(RTMessage) {
   ClearPage();
   EdChkBox->Uncheck();
   nChecked = 0;

}

   // Handle Read Forward button *
void TMainWinDlg::HandleForwardButton(RTMessage) {
long lCurpos;
   if (hfLilfile == NULL)
      MessageBox(HWindow, "Open a File!", "Browse",MB_OK);
   else {
      lCurpos = GetCur();
      while (ReadRec()) {
	 if (Book.DelFlag[0] != 'D') {
	     HitMe();
	     return;
         }

      }
      MessageBox(HWindow, "Have Reached End of File!", "Browse",MB_OK);
      SetCur(lCurpos);
   }

}

   // Handle Read Backward button *
void TMainWinDlg::HandleBackwardButton(RTMessage) {
   long lCurpos;

   if (hfLilfile == NULL)
      MessageBox(HWindow, "Open a File!", "Browse",MB_OK);
   else {
      lCurpos = GetCur();
      while(!feof(hfLilfile)) {
	 if ((lCurpos -= (2*PAGE)) >= 0l) {	// if can read back
	    SetCur(lCurpos);
	    ReadRec();
	    if (Book.DelFlag[0] != 'D') {
	       HitMe();
	       break;
	    }
	 }
	 else {
	    MessageBox(HWindow, "Beginning of File!", "Browse", MB_OK);
	    BigStepBak(); 	// an easy way out
	    while (ReadRec()) {
	       if (Book.DelFlag[0] != 'D') {
		   HitMe();
		   return;
	       }
            }
	 }
      }
   }
}

   // Handle Rewind Button
void TMainWinDlg::HandleRewindButton(RTMessage) {
   if (hfLilfile == NULL)
      MessageBox(HWindow, "Open a File!", "Rewind",MB_OK);
   else {
      BigStepBak();
      while (ReadRec()) {
	 if (Book.DelFlag[0] != 'D') {
	     HitMe();
	     return;
	 }

      }
      MessageBox(HWindow, "File Empty!", "Rewind",MB_OK);
   }
  
}

   // Handle Delete Button
void TMainWinDlg::HandleDeleteButton(RTMessage) {
char buf[80];
   if (hfLilfile != NULL) {
      LilStepBak();
      sprintf(buf, "%s %s", Book.FName, Book.LName);
      if (MessageBox(HWindow, buf, "Delete",MB_OKCANCEL) == IDOK) {
         Book.DelFlag[0] = 'D';
         WriteRec();
	 ClearMoFlags();
      }
      else
         LilStepFor();
   }
}


   // Respond to checkbox 
void TMainWinDlg::CheckUp(RTMessage)
{
  nChecked = ~nChecked;
}


/***********************************************************************/
// Windows Main Dispatch

int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TLilbookApp Lilbook("Lil Blue Book",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Lilbook.Run();                                  // pumpit ***
  return (Lilbook.Status);                        // exit
  }

/**********************************************************************/


/**** File I/O ****/          // Abstracted for ease when going to
			      // a different engine (The Engine).
   // Open Lil File **
int TMainWinDlg::OpenLilFile() {

   hfLilfile = _fsopen(szName, "rb+", SH_DENYNO);     
   if (hfLilfile == NULL) {
      hfLilfile = _fsopen(szName, "wb+", SH_DENYNO);  
      if (hfLilfile == NULL) {
	 MessageBox(HWindow, "Cant open new file!", "Debug",MB_OK);
	 return(1);
      }

   }
   return(0);
};

   // Read Rec **
int TMainWinDlg::ReadRec(void) {
    return(fread(&Book, PAGE, 1, hfLilfile));
}

   // Write Rec **
int TMainWinDlg::WriteRec(void) {
size_t cbWrite = 0;
long lCurpos;          
   lCurpos = GetCur();
   cbWrite = fwrite(&Book, PAGE, 1, hfLilfile);
   SetCur(lCurpos+PAGE);
   return(cbWrite);
}

// File Cursor Routines

   // Get cursor (to save)
long TMainWinDlg::GetCur(void) {
   return ftell(hfLilfile);
}

   // Set cursor (to resume)
int TMainWinDlg::SetCur(long pos) {
   return (fseek(hfLilfile, pos, 0));
}

   // Lil step Forward **
void TMainWinDlg::LilStepFor(void) {
   fseek(hfLilfile, PAGE, 1);
}

   // Lil step Backward **
void TMainWinDlg::LilStepBak(void) {
   fseek(hfLilfile, -PAGE, 1);
}

   // Big Step Forward  **
void TMainWinDlg::BigStepFor(void) {
   fseek(hfLilfile, 0L, 2);
}
   
   // Big Step Back  **
void TMainWinDlg::BigStepBak(void) {
   fseek(hfLilfile, 0L, 0);
}

/**** End File I/O ****/

/*** End of source file ***/

/*************************************************************************/

// Dumping Grounds ***

   // sprintf(buf,"%ld",Errval);
   // strcat(Errstr,buf);
   // MessageBox(HWindow,Errstr,"WARNING",MB_OK|MB_ICONSTOP);

   //  DWORD Errval;	// Error value
   //  sprintf(buf,"%ld",Errval);
   //  strcat(Errstr,buf);
   //  MessageBox(HWindow,Errstr,"WARNING",MB_OK|MB_ICONSTOP);

   //  MessageBox(HWindow, "Opened file!", "Debug",MB_OK);

    // virtual void CMFileOpen(RTMessage)
    //   = [CM_FIRST + CM_FILEOPEN];

    // virtual void CMFileSave(RTMessage)
    //   = [CM_FIRST + CM_FILESAVE];
    // void TMainWinDlg::CMFileSave(RTMessage) {

