/* LHX.H -- Definitions for LHX
 *
 * version 1.0 by Mark Armbrust, 15 April 1985   (IRS? Just say NO!)
 *
 * The code in this module is public domain -- do whatever you want with it */

#define BUFF_LEN	8192	/* buffer size for uncompressed file manipulation */

#define EXTRACT	1			/* 'mode' values */
#define LIST	2
#define SCAN	4
#define TEST	8
#define MODES	(EXTRACT | LIST | SCAN | TEST)
#define AT		0x10

#ifdef DEBUG
#define PRIVATE
#else
#define PRIVATE static
#endif

#ifdef MAIN
#define PUBLIC
#else
#define PUBLIC extern
#endif


/* special data types */

struct lzhdir {
	unsigned char	header_len;		/* length of header excluding this byte
										 and checksum byte MUST BE <= 98 */
	unsigned char	header_sum;		/* binary sum of header bytes */
	char			method[5];		/* compression method:	*/
									/*	 "-lh0-" => no compression */
									/*	 "-lh1-" => lzhuf compression */
	unsigned long	data_size;		/* size of compressed data following
										directory entry */
	unsigned long	file_size;		/* external file size */
	unsigned int  	file_time;		/* external file time; DOS format */
	unsigned int  	file_date;		/* external file date; DOS format */
	unsigned int  	file_attr;		/* external file attributes; DOS format */
	unsigned char	name_len;		/* length of file name */
	char			filename[74];	/* variable length file name ( <= 74 chars) */
	unsigned int  	file_CRC;		/* external file CRC-16 (same as zoo)
										immediately following file name. */
	};

struct fname {
	char		 *	name;
	struct fname *	next;
	};


/* public functions */

PUBLIC void		addbfcrc	(char *, int  );
PUBLIC void		Extract		(FILE * arcfile, struct fname * filenames);
PUBLIC void		List		(FILE * arcfile, struct fname * filenames);
PUBLIC void		Scan		(FILE * arcfile);
PUBLIC int		Process		(FILE * arcfile, struct fname * filenames);
PUBLIC void		main		(int, char * []);
PUBLIC int  	Decode		(void);
PUBLIC int		MatchAny	(char *, struct fname *);

/* public variables */

PUBLIC unsigned int  	crccode;
PUBLIC int  			mode;				/* program [default] operating mode */
PUBLIC char				name[100];			/* name of archive being manipulated */
PUBLIC char				buffer[BUFF_LEN];	/* buffer for uncompressed file manipulation */
PUBLIC FILE			*	infile;
PUBLIC FILE			*	outfile;
PUBLIC unsigned long	textsize;
PUBLIC long				header_start;
PUBLIC long				file_start;
PUBLIC long				file_size;
PUBLIC int  			file_type;
PUBLIC char				file_name[20];

