/*

	cbinder.hpp
	10-25-91
	Copy Binder: Loose Data Binder v 1.5

	Copyright 1991
	John W. Small
	All rights reserved

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#ifndef CBINDER_HPP
#define CBINDER_HPP

#ifndef SBINDER_HPP
#include "sbinder.hpp"
#endif

#include <string.h>

#define ID_CBinder	3

#define CBDR_STRING	0

/*
	CBinder is a SBinder that doesn't require its nodes
	to be derived from Streamable.  As a result the 
	nodes MUST not be multiply linked since they don't 
	have Streamable's built in double ownership 
	protection or multiple reference streaming 
	capabilities.  In other words the nodes must be 
	solely owned by the CBinder and appear only once 
	bound within.  The CBinder also provides for cloning
	and copying of your data on the fly.  Since every 
	LDB requires that its nodes must all be either 
	statically or dynamically allocated, allowing the 
	CBinder to clone some nodes forces the requirement 
	that all nodes be dynamically allocated.  Thus the 
	CBinder constructor always sets the BDR_OK_FREE flag.
		
	So we see that the CBinder nodes MUST be dynamically
	allocated fixed size data or C strings which the 
	CBinder defaults to.  A CBinder should only be used 
	to bind native data types and structures or classes 
	without virtual functions or suballocated memory (or
	other pointers) or otherwise requiring destructor 
	calls.  See manual for details of binding these kinds
	of structures and classes in decendents of CBinder.
*/
	
	
class CBinder : public SBinder  {
	unsigned sizeofData;
protected:
	void construct(unsigned sizeofData)
		{ this->sizeofData = sizeofData; }
	// void destruct()  {}
	virtual int  Dfree(voiD D)
		{ return (D? delete D, 1 : 0); }
	virtual int  Dattach(voiD)
		{ return 1; }
	virtual void Ddetach(voiD)
		{ return; }
		/*
			If your derived class overrides
			Dattach() and Ddetach() it is 
			likely that restream() needs
			overriding also!
		*/
	virtual ostream& store(ostream& os);
	static  StreamablE load(istream& is,
		StreamablE InstancE);
	virtual void Dstore(ostream& os, voiD D);
	virtual voiD Dload(istream& is);
	virtual voiD Dclone(const voiD D);
		/*
			Think of Dclone() as a copy
			initilizer for your data.
		*/
	virtual voiD Dcopy(voiD D, const voiD S);
		/*
			Think of Dcopy() like an assignment
			operator.  If (!D || !S || D == S)
			return voiD0 otherwise perform what
			operator=() would do on your data.
		*/
public:
	enum { ID_CLASS = ID_CBinder };
	CBinder(StreamableClassRegistry& dummy,
		unsigned id = ID_CLASS) :
		SBinder(dummy,id) {}
	CBinder(unsigned sizeofData = CBDR_STRING,
		unsigned maxNodes = BDR_MAXNODES,
		unsigned limit = BDR_LIMIT,
		unsigned delta = BDR_DELTA);
	static void registerClass(unsigned id = ID_CLASS,
		StreamablE (*loader)(istream& is,
		StreamablE InstancE) = load)
		{ Streamable :: registerClass(id,loader); }
	virtual unsigned restream()
		{ return Streamable::restream(); }
	virtual ~CBinder()  { allFree(); }
	unsigned SizeofData()  { return sizeofData; }
	voiD atInsCLN(unsigned n, const voiD D);
	voiD atFreeCPY(unsigned n, voiD D);
	voiD atPutCLN(unsigned n, const voiD D);
	voiD atPutCPY(unsigned n, const voiD D)
		{ return Dcopy(atGet(n),D); }
	voiD atGetCPY(unsigned n, voiD D)
		{ return Dcopy(D,atGet(n)); }
	voiD topCPY(voiD D)  { return Dcopy(D,atGet(0)); }
	voiD currentCPY(voiD D)
		{ return Dcopy(D,atGet(CurNode())); }
	operator char *();
	voiD bottomCPY(voiD D)
		{ return Dcopy(D,atGet(Nodes()-1)); }
	voiD pushCLN(const voiD D);
	voiD popFreeCPY(voiD D);
	voiD insQCLN(const voiD D);
	voiD rmQFreeCPY(voiD D);
	voiD unQFreeCPY(voiD D);
	voiD insCLN(const voiD D);
	voiD insSortCLN(const voiD D);
	voiD delFreeCPY(voiD D);
	voiD nextCPY(voiD D);
	voiD prevCPY(voiD D);

};

typedef CBinder * CBindeR;


#endif

