// twindow.cpp -- Test window class

#include <stdlib.h>
#include <stdio.h>
#include "window.h"

/* -- Attribute constants */

#define WA_REVERSEVIDEO  0x70
#define WA_NORMAL        0x07

/* -- Test-function prototypes */

void pause(void);
void runtest(void);
void overlayTest(void);
void scrollTest(void);

main()
{
   window::startup();
   runtest();
   window::shutDown();
   exit(0);
}

/* -- Wait for and discard keypress */

void pause(void)
{
   while (getch() != ' ') ;
}

/* -- Execute main test procedures */

void runtest(void)
{
   int i;
   window *win = new window;
   winStruct ws;

   int row;

   win->setTitle(" Press <Spacebar> to Advance Test ");
   win->showWindow();
   ws = win->getInfo();
   for (row = 0; row < ws.height - 2; row++) {
      win->gotorc(row, row);
      win->puts("This line should end here: abcdefghijklmnop");
      win->gotorc(row, 75);
      win->puts("Endoftheline");
      if (row & 1)
         win->normalVideo();
      else
         win->reverseVideo();
      pause();
   }

   win->setTitle(" Pop-Up Overlay Test ");
   overlayTest();

   win->normalVideo();
   win->setTitle(" Erase to End of Line Test ");
   pause();
   for (row = 0; row < ws.height - 2; row++) {
      win->gotorc(row, row + 26 );
      win->eeol();
      pause();
   }

   win->normalVideo();
   win->gotorc(0, 0);
   win->puts("Scroll down 4x test");
   win->eeol();
   win->setTitle(" Scroll DOWN 4x test ");
   pause();
   for (i = 1; i <= 4; i++) {
      win->scrollDown(1);
      pause();
   }

   win->gotorc(4, 0);
   win->puts(" Scroll up 4x test ");
   win->eeol();
   win->setTitle(" Scroll UP 4x test ");
   for (i = 1; i <= 4; i++) {
      pause();
      win->scrollUp(1);
   }

   win->setTitle(" Erase Window Test " );
   pause();
   win->gotorc(0, 0);
   win->eeow();
   win->setTitle(" Null Title Test ");
   pause();
   win->setTitle("");
   pause();
   win->setTitle(" Hide Window Test " );
   pause();
   win->hideWindow();
   delete win;
}

/* -- Display pop-up window over main window */

void overlayTest(void)
{
   winStruct ws = {
      6, 20, 32, 12, 
      WA_REVERSEVIDEO, WA_NORMAL, WA_NORMAL, 1
   };
   window *win = new window(ws, " Pop-Up ");

   win->showWindow();
   win->gotorc(4, 2);
   win->puts("Pop-Up window!");
   win->gotorc(6, 2);
   win->puts("Press Space twice to erase");
   pause();
   win->gotorc(0, 0);
   win->eeow();
   pause();
   delete win;
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 10/30/1990   Time: 11:03 am
