// terror.cpp -- Test ERROR Module

#include <stream.hpp>
#include "error.h"

extern int errorignore;    // Gain access to errorignore flag

void test(int n);

main()
{
   errorignore = 1;        // Do not halt on errors
   test(1);                // Test with reset in geterror
   test(0);                // Test without reset in geterror
   errorignore = 0;        // Halt on errors
   error(-154, "Internal problem. Please report at once!");
   cout << "\n\nIf you are reading these lines, there is an";
   cout << "\nerror in the ERROR module!";
}

void test(int n)
{
   int err;

   if (n == 0)
      cout << "\n\nTesting geterror without reset";
   else
      cout << "\n\nTesting geterror with reset";
   error(ERRMEM);          // Out-of-memory error
   if ((err = geterror(n)) != NOERROR)
      cout << "\nError detected. Code = " << err;
   else
      cout << "\nError in ERROR: geterror failed to return code";
   cout << "\nSecond call to geterror = " << geterror();
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 10/26/1990   Time: 03:07 pm
