// meeting.cpp -- Multidimension array demonstration

#include <stream.hpp>

#define NUMEMPLOYEES 4
#define NUMHOURS 10
#define STARTHOUR 8

#define JOE 0
#define SAM 1
#define PAULA 2
#define MARY 3

int schedule[NUMHOURS][NUMEMPLOYEES];

main()
{
   int empnum, hour;

// Enter employee appointments:

   for (;;) {
      cout << "Employee number? (-1 to quit): ";
      cin >> empnum;
      if (empnum < 0) break;
      if (empnum > NUMEMPLOYEES) {
         cout << "Employee number is out of range\n";
         continue;
      }
      for (;;) {
         cout << "Hour of appointment? (8-17, -1 to quit): ";
         cin >> hour;
         if (hour < 0) break;
         if ((STARTHOUR <= hour) && (hour < STARTHOUR + NUMHOURS))
            schedule[hour - STARTHOUR][empnum] = 1;
         else
            cout << "Hour is out of range\n";
      }
   }

// Display schedule:

   cout << "\nSchedule:\n";
   cout << "        Joe     Sam     Paula   Mary\n";
   for (hour = 0; hour < NUMHOURS; hour++) {
      cout << dec(hour + STARTHOUR, 2) << ":00";
      for (empnum = JOE; empnum < NUMEMPLOYEES; empnum++) {
         cout << '\t';
         if (schedule[hour][empnum] != 0)
            cout << 'X';
      }
      cout << '\n';
   }

// Calculate hours when all employees can meet:

   cout << "\nPossible meeting times:\n";
   for (hour = 0; hour < NUMHOURS; hour++) {
      int k = 0;
      for (empnum = 0; empnum < NUMEMPLOYEES; empnum++) {
         k += schedule[hour][empnum];
      }
      if (k == 0)
         cout << dec(hour + STARTHOUR, 2) << ":00\n";
   }
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 08/16/1990   Time: 11:32 am



