// list.h -- Header for list.cpp

#ifndef __LIST_H
#define __LIST_H     1     // Prevent multiple #includes

#include <stdlib.h>
#include "item.h"

class list: public item {
   private:
      item *anchor;        // Anchors list head
      item *cip;           // "Current item pointer"

   public:

   // -- Constructor and destructor
      list();
      virtual ~list();

   // -- Inline member functions
      int listEmpty(void) 
         { return (anchor == NULL); }
      int atHeadOfList(void)
         { return ((anchor != NULL) && (cip == anchor)); }
      int atEndOfList(void)
         { return ((anchor != NULL) && (cip == anchor->left)); }
      item *currentItem(void)
         { return cip; }
      item *firstItem(void)
         { return (cip = anchor); }
      void resetList(void)
         { cip = anchor; }
      void setCurrentItem(item *ip)
         { cip = ip; }

   // -- Other member functions
      item *insertItem(item *ip);
      item *removeItem(item *ip);
      item *prevItem(void);
      item *nextItem(void);

   // Virtual member function
      virtual void disposeList(void);
};

#endif   // __LIST_H

// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 09/03/1990   Time: 09:56 am
