// grade.cpp -- Grade average calculator

#include <stream.hpp>
#include <stdlib.h>

#define MAXGRADES 18

double grades[MAXGRADES];  // Array of grade values

main()
{
   int i, numgrades;
   double total, average;

// Prompt user for grades, and store values in array:

   for (numgrades = 0; numgrades < MAXGRADES; numgrades++) {
      cout << "Enter grade #" << (numgrades + 1) << "(-1 to quit): ";
      cin >> grades[numgrades];
      if (grades[numgrades] < 0) break;
   }
   if (numgrades <= 0) exit(0);  // No grades entered

// Display the values stored in the array:

   cout << "\n\nGrades:\n\n";
   for (i = 0; i < numgrades; i++)
      cout << dec(i + 1, 2) << ':' 
           << form("%8.2f", grades[i]) << '\n';

// Total the scores:

   total = 0.0;
   for (i = 0; i < numgrades; i++)
      total += grades[i];

// Compute and display the average:

   average = total / numgrades;
   cout << "\nTotal scores     = " << form("%8.2f", total);
   cout << "\nNumber of grades = " << dec(numgrades, 5);
   cout << "\nAverage grade    = " << form("%8.2f", average);
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 08/16/1990   Time: 09:29 am


