// getvals.cpp -- Get values in ranges

#include <stream.hpp>

void getValues(int &low, int &high, int min, int max);
void getOneValue(const char *prompt, int &v, int min, int max);

main()
{
   int low, high;
   getValues(low, high, 10, 50);
   cout << "\nlow == " << low << " high == " << high;
}

void getValues(int &low, int &high, int min, int max)
{
   int result;

   cout << "\nEnter two values between " << min << " and " << max;
   cout << "\nThe first value must be less or equal to the second.";
   do {
      getOneValue("\nLow value?  ", low, min, max);
      getOneValue("\nHigh value? ", high, min, max);
      result = (low <= high);
      if (result == 0)
         cout << "\nERROR: Low value must be <= high.";
   } while (result == 0);
}

void getOneValue(const char *prompt, int &v, int min, int max)
{
   int result;

   do {
      cout << prompt;
      cin >> v;
      result = (min <= v) && (v <= max);
      if (result == 0)
         cout << "\nERROR: value out of range";
   } while (result == 0);
}



// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 12/04/1990   Time: 05:30 pm
