// format.cpp -- Demonstrate formatted output

#include <stream.hpp>

main()
{
   int value = 0x79AF;
   long longValue = 123456789;
   double pi = 3.14159;
   double balance = 572.63;
   char *name = "Judy";

   cout << form("Plain decimal   = %d\n", value);
   cout << form("Signed decimal  = %+d\n", value);
   cout << form("Right justified = %10d\n", value);

   cout << form("\nPlain hexadecimal     = %x\n", value);
   cout << form("Prefaced hexadecimal  = %#x\n", value);
   cout << form("Uppercase hexadecimal = %#X\n", value);

   cout << form("\nBinary = %b\n", value);

   cout << form("\nUnsigned long decimal = %ld\n", longValue);
   cout << form("Signed long decimal   = %Ld\n", longValue);

   cout << form("\nFloating point      = %f\n", pi);
   cout << form("Scientific notation = %e\n", pi);
   cout << form("Default notation    = %g\n", pi);
   cout << form("FP precision 10     = %.10f\n", pi);

   cout << form("\n%s's balance = $%8.2f", name, balance);
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 07/24/1990   Time: 08:53 am




