// box.cpp -- Display text boxes

#include <stream.hpp>
#include <disp.h>

void getcoords(int &toprow, int &topcol, int &botrow, int &botcol);
void drawbox(int toprow, int topcol, int botrow, int botcol);

main()
{
   int toprow, topcol, botrow, botcol;

   disp_open();
   getcoords(toprow, topcol, botrow, botcol);
   disp_move(0, 0);
   disp_eeop();
   drawbox(toprow, topcol, botrow, botcol);
   disp_move(24, 0);
   disp_close();
}

void getcoords(int &toprow, int &topcol, int &botrow, int &botcol)
{
   cout << "\nEnter top row and column (ex: 3 7): ";
   cin >> toprow >> topcol;
   cout << "Enter bottom row and column (ex: 20 64): ";
   cin >> botrow >> botcol;
}

void drawbox(int toprow, int topcol, int botrow, int botcol)
{
   disp_box(0, DISP_NORMAL, toprow, topcol, botrow, botcol);
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 08/25/1990   Time: 10:08 am

