// wintool.cpp -- Select window attributes

#include <stream.hpp>
#include "wintool.h"

/* -- Global variables */

int attributes[6] = {1, 15, 7, 0, 7, 0};
unsigned wta = 0x1f;
unsigned wba = 0x70;
unsigned wha = 0x70;
window *mainWindow;
window *sampleWindow;

main()
{
   window::startup();
   createMainWindow();
   createSampWindow();
   performCommands();
   delete sampleWindow;
   delete mainWindow;
   window::shutDown();
   exit(0);
}

/* -- Create and display main program window */

void createMainWindow()
{
   winStruct ws = {
      0, 0, 80, 25,  // row, column, width, height
      0x07,          // text attribute
      0x0f,          // border attribute
      0x70,          // highlight attribute
      3              // border type
   };

   mainWindow = new window(
      ws, " Window Design Tool from \"Learning C++\" by Tom Swan ");
   mainWindow->showWindow();
}

/* -- Create and display sample window */

void createSampWindow()
{
   winStruct ws = {
      SAMP_ROW, SAMP_COL, SAMP_WIDTH, SAMP_HEIGHT,
      wta, wba, wha, SAMP_TYPE
   };

   sampleWindow = new window(ws, SAMP_TITLE);
   sampleWindow->showWindow();
}

/* -- Create command menu and execute command objects */

void performCommands(void)
{
   command *cp;         // Pointer to selected command
   winStruct ws = {
      MENU_ROW, MENU_COL, MENU_WIDTH, MENU_HEIGHT,
      MENU_TA, MENU_BA, MENU_HA, MENU_TYPE
   };
   selector *menu = new selector(ws, MENU_TITLE, MENU_POPUP);

   menu->insertItem(new helpCommand());
   menu->insertItem(new attrCommand(" Text Background",       CMD_TBG));
   menu->insertItem(new attrCommand(" Text Foreground",       CMD_TFG));
   menu->insertItem(new attrCommand(" Border Background",     CMD_BBG));
   menu->insertItem(new attrCommand(" Border Foreground",     CMD_BFG));
   menu->insertItem(new attrCommand(" Highlight Background",  CMD_HBG));
   menu->insertItem(new attrCommand(" Highlight Foreground",  CMD_HFG));
   showColors();
   while ((cp = (command *)(menu->getSelection())) != NULL) {
      cp->performCommand();
      showColors();
   }
}

/* -- Display current color attributes and sample window */

void showColors(void)
{
   for (int i = 0; i < 6; i++) {
      mainWindow->gotorc(MENU_ROW + i + 1, MENU_COL + MENU_WIDTH);
      mainWindow->puts(dec(attributes[i], 2));
   }
   mainWindow->gotorc(16, 4);
   mainWindow->puts("Text attribute ........ : 0x");
   mainWindow->puts(hex(wta,2));
   mainWindow->gotorc(17, 4);
   mainWindow->puts("Border attribute ...... : 0x");
   mainWindow->puts(hex(wba, 2));
   mainWindow->gotorc(18, 4);
   mainWindow->puts("Highlight attribute ... : 0x");
   mainWindow->puts(hex(wha, 2));
   showSample();
}

/* -- Display sample window using selected attributes */

void showSample(void)
{
   winStruct ws = {
      SAMP_ROW, SAMP_COL, SAMP_WIDTH, SAMP_HEIGHT,
      wta, wba, wha, SAMP_TYPE
   };

   sampleWindow->setInfo(ws);
   sampleWindow->gotorc(0, 0);
   sampleWindow->eeow();
   sampleWindow->gotorc(5, 9);
   sampleWindow->normalVideo();
   sampleWindow->puts("Normal Text");
   sampleWindow->gotorc(10, 6);
   sampleWindow->reverseVideo();
   sampleWindow->puts(" Highlighted Text ");
}

/* -- Implementation of the help command */

void helpCommand::performCommand(void)
{
   winStruct ws = {
      2, 2, 76, 21,  // row, column, width, height
      0x1f,          // text attribute
      0x70,          // border attribute
      0x70,          // highlight attribute
      0              // border type
   };
   window *helpWindow = new window(ws, " WinTool Help ");

   helpWindow->showWindow();
   helpWindow->gotorc(8, 4);
   helpWindow->puts("No help available");
   helpWindow->gotorc(10, 4);
   helpWindow->puts("(Press <Esc> from main menu to quit program)");
   while (!keyWaiting()) ;
   getKey();
   delete helpWindow;
}

/* -- Implementation of the attributes command. Increments attribute
value for selected item, identified by cmdNum. Updates global window
attribute values. */

void attrCommand::performCommand(void)
{
   attributes[cmdNum] = ++attributes[cmdNum] % 16;
   wta = attributes[0] * 16 + attributes[1];
   wba = attributes[2] * 16 + attributes[3];
   wha = attributes[4] * 16 + attributes[5];
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 09/29/1990   Time: 02:15 pm

