// upperstr.cpp -- An uppercase-string class

#include <stream.hpp>
#include <string.h>
#include <error.h>
#include <item.h>
#include <stritem.h>

class upperStr : public strItem {
   public:
      upperStr(const char *s);
      upperStr(const char *s, int maxLen);
};

main()
{
   upperStr *usp = new upperStr("An upper class string");
   cout << "String == " << usp->getString();
}

upperStr::upperStr(const char *s) : strItem(s)
{
   char *sp = strdup(s);
   if (sp == NULL) error(ERRMEM);
   putString(strupr(sp));
   delete sp;
}

upperStr::upperStr(const char *s, int maxLen) : strItem(s, maxLen)
{
   char *sp = strdup(s);
   if (sp == NULL) error(ERRMEM);
   putString(strupr(sp), maxLen);
   delete sp;
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 12/05/1990   Time: 05:21 pm
