// tcommand.cpp -- Test command class

#include <stream.hpp>
#include "key.h"
#include "selector.h"
#include "command.h"

/* -- Test-function prototypes */

void pause(void);
void runtest(void);

/* -- Derived command classes */

class openCommand : public command {
   public:
      openCommand() : command("Open") { }
      virtual void performCommand(void);
};

class closeCommand : public command {
   public:
      closeCommand() : command("Close") { }
      virtual void performCommand(void);
};

class saveCommands : public command {
   public:
      saveCommands(const char *s, int cn) : command(s) 
         { cmdNum = cn; }
      virtual void performCommand(void);
};

class quitCommand : public command {
   public:
      quitCommand() : command("Quit <Esc>") { }
      virtual void performCommand(void);
};

main()
{
   window::startup();
   runtest();
   window::shutDown();
   exit(0);
}

/* -- Wait for a <Spacebar> */

void pause(void)
{
   cout << " Press <Spacebar>...";
   while (getch() != ' ') ;
}

/* -- Perform tests */

void runtest(void)
{
   winStruct ws = {
      4, 20, 18, 7,  // row, column, width, height
      0x07,          // text attribute
      0x1e,          // border attribute
      0x70,          // highlight attribute
      1              // type, save text (yes)
   };
   selector *sel = new selector(ws, " Items ");
   command *cp;

   sel->insertItem(new openCommand());
   sel->insertItem(new closeCommand());
   sel->insertItem(new saveCommands("Save", 1));
   sel->insertItem(new saveCommands("Save-as", 2));
   sel->insertItem(new quitCommand());

   while ((cp = (command *)(sel->getSelection())) != NULL) {
      cp->performCommand();
   }

   delete sel;
}

/* -- The derived command-class implementations */

void openCommand::performCommand(void)
{
   cout << "\nOpen command.";
   pause();
}

void closeCommand::performCommand(void)
{
   cout << "\nClose command.";
   pause();
}

void saveCommands::performCommand(void)
{
   if (cmdNum == 1) 
      cout << "\nSave command.";
   else if (cmdNum == 2)
      cout << "\nSave-as command.";

   pause();
}

void quitCommand::performCommand(void)
{
   ungetKey(27);     // "Press" the <Esc> key
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 11/01/1990   Time: 07:47 am
