// fourfps.cpp -- Class with four floating point values

// To compile, enter:
//   ztc fourfps.cpp \lcpp\lib\item.obj

#include <stream.hpp>
#include <item.h>

class fourFloats : item {
   private:
      double da[3];     // Array of 4 double values
   public:
      fourFloats();
      int setFloat(int n, double x);
      double getFloat(int n);
};

void showFloats(fourFloats &ff, const char *s);

main()
{
   fourFloats *f4 = new fourFloats;

   showFloats(*f4, "\nBefore assignments:\n");
   for (int i = 0; i <= 5; i++)  // Use bad index for test
      f4->setFloat(i, 3.14159 * (i + 1));
   showFloats(*f4, "\nAfter assignments:\n");
}

void showFloats(fourFloats &ff, const char *s)
{
   cout << s;
   for (int i = 0; i <= 5; i++)  // Use bad index for test
      cout << form("value %d: %f\n", i, ff.getFloat(i));
}

fourFloats::fourFloats()
{
   for (int i = 0; i <= 3; i++)
      da[i] = 0;
}

int fourFloats::setFloat(int n, double x)
{
   if ((0 <= n) && (n <= 3)) {
      da[n] = x;
      return 0;   // no error
   } else
      return -1;  // error: n out of range
}

double fourFloats::getFloat(int n)
{
   if ((0 <= n) && (n <= 3))
      return da[n];
   else
      return 0;   // bad n values return 0
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 12/05/1990   Time: 03:50 pm
