// cr2lf.cpp -- Convert carriage returns to line feeds

#include <stream.hpp>
#include <ctype.h>
#include <stdlib.h>

#define CR 13  // ASCII carriage return
#define LF 10  // ASCII line feed

main(int argc, char *argv[])
{
   FILE *fpin, *fpout;
   unsigned char c, lf = LF;
   int nout;

   if (argc < 3) {
      cout << "ERROR: No file names";
      exit(1);
   }
   fpin = fopen(argv[1], "rb");
   if (!fpin) {
      cout << "ERROR: File not found";
      exit(2);
   }
   fpout = fopen(argv[2], "wb");
   if (!fpout) {
      cout << "ERROR: Can't create output file";
      exit(3);
   }
   while (fread(&c, 1, 1, fpin) > 0) {
      if (c == CR)
         nout = fwrite(&lf, 1, 1, fpout);
      else if (c != LF)
         nout = fwrite(&c, 1, 1, fpout);
      if (nout != 1) {
         cout << "ERROR: Writing to disk";
         exit(4);
      }
   }
   fclose(fpin);
   fclose(fpout);
   exit(0);
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 12/06/1990   Time: 10:01 am
