// words2.cpp -- Count words in standard input

#include <stream.hpp>
#include <ctype.h>

main()
{
   char c;
   int words, chars, lines, insideWord;
   
   words = chars = lines = insideWord = 0;

   while ((c = getchar()) != EOF) {
      chars++;
      if (c == '\n') {
         lines++;
         chars++;
      }
      if (!isspace(c)) {
         if (!insideWord) {
            insideWord = 1;   // True
            words++;
         }
      } else
         insideWord = 0;      // False
   }

   cout << chars << " total character(s)\n";
   cout << words << " word(s)\n";
   cout << lines << " line(s)\n";
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 10/24/1990   Time: 08:17 am
