// window.h -- Header for window.cpp

#ifndef __WINDOW_H
#define __WINDOW_H      1     // Prevent multiple #includes

#include <stdlib.h>
#include "stritem.h"
#include "item.h"

/* -- Window information structure */

struct winStruct {
   int row;             // Absolute row of top left corner
   int col;             // Absolute column of top left corner
   int width;           // Width of border
   int height;          // Height of border
   unsigned wtattr;     // Window normal text attribute
   unsigned wbattr;     // Window border attribute
   unsigned whattr;     // Window highlight text attribute
   int wtype;           // Border type (0 ... 4)
};

/* -- Window class */

class window: public item {
   private:

   // -- Static data field (shared by all objects of class)
      static int dispInitialized;  // True == display initialized

   // -- Private data fields
      int wbr;             // Window bottom row
      int wrc;             // Window right column
      int cr, cc;          // Logical cursor row, cursor column
      unsigned wca;        // Window current attribute
      strItem *wtitle;     // Pointer to window title strItem
      unsigned *save;      // If NULL, text behind not saved

   // -- Protected data fields
   protected:
      int isOpen;          // True if window is visible
      winStruct ws;        // Location, size, attributes

   // -- Private member functions
   private:
      unsigned *saveBuf(void);
      void commonInits(void);
      void showOutline(void);

   public:

   // -- Static member functions
      static void startup(void);
      static void shutDown(void);

   // -- Constructors and destructors
      window();
      window(winStruct &ws, const char *title);
      ~window();

   // -- Inline member functions
      winStruct &getInfo()
         { return ws; }
      void reverseVideo(void)
         { wca = ws.whattr; }
      void normalVideo(void)
         { wca = ws.wtattr; }

   // -- Other member functions
      void showWindow();
      void hideWindow();
      void setTitle(const char *s);
      void setInfo(winStruct &ws);
      void gotorc(int row, int col);
      void puts(char *s);
      void scrollUp(int nrows);
      void scrollDown(int nrows);
      void eeol(void);
      void eeow(void);
};

#endif   // __WINDOW_H


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 09/22/1990   Time: 11:47 am
