// tselect.cpp -- Test selector class

#include <stream.hpp>
#include <stdlib.h>
#include <string.h>
#include "selector.h"

/* -- Test function prototypes */

void pause(void);
void runtest(void);

/* -- Pointer to a selected string */

char *selection;

main()
{
   window::startup();
   runtest();
   window::shutDown();
   if (selection == NULL)
      cout << "\nNo item selected";
   else
      cout << "\nItem selected: " << selection;
   exit(0);
}

/* -- Wait for a keypress */

void pause(void)
{
   while (getch() != ' ') ;
}

/* -- Perform the test */

void runtest(void)
{
   winStruct ws = {
      4, 20, 18, 7,  // row, column, width, height
      0x07,          // text attribute
      0x1e,          // border attribute
      0x70,          // highlight attribute
      1              // type
   };
   selector *sel = new selector(ws, " Items "); 
   strItem *p;

   sel->insertItem(new strItem("Elephants"));
   sel->insertItem(new strItem("Tigers"));
   sel->insertItem(new strItem("Lions"));
   sel->insertItem(new strItem("Polar Bears"));
   sel->insertItem(new strItem("Deer"));
   sel->insertItem(new strItem("Rabbits"));
   sel->insertItem(new strItem("Loons"));
   sel->insertItem(new strItem("Eagles"));
   sel->insertItem(new strItem("Beavers"));
   sel->insertItem(new strItem("Peacocks"));
   sel->insertItem(new strItem("Quit <Esc>"));
   
   p = sel->getSelection();
   if (p) selection = strdup(p->getString());
   delete sel;
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 10/30/1990   Time: 04:58 pm
