// tlist.cpp -- Test list class

#include <stream.hpp>
#include "list.h"

class myItem : public item {
   private:
      int value;
   public:
      myItem(int n) { value = n; }
      void putValue(int n) { value = n; }
      int getValue(void) { return value; }
};

void showList(void);

list *lp = new list;

main()
{
   int i;
   myItem *mip;

   cout << "\nAfter allocating new list";
   showList();

   cout << "\n\nInsert 10 items into the list";
   for (i = 1; i <= 10; i++)
      lp->insertItem(new myItem(i));
   showList();

   cout << "\n\nAdd 100 to listed item values";
   lp->resetList();
   do {
      mip = (myItem *)lp->currentItem();
      mip->putValue(mip->getValue() + 100);
      lp->nextItem();
   } while (!lp->atHeadOfList());
   showList();

   cout << "\n\nDelete first 3 items from list";
   lp->resetList();
   for (i = 1; i <= 3; i++)
      lp->removeItem(lp->currentItem());
   showList();

   cout << "\n\nDispose of all listed items";
   lp->disposeList();
   showList();
}

void showList(void)
{
   cout << "\nITEMS IN LIST: ";
   if (lp->listEmpty()) {
      cout << "List is empty";
      return;
   }
   lp->resetList();
   do {
      cout << ((myItem *)(lp->currentItem()))->getValue();
      cout << "  ";
      lp->nextItem();
   } while (!lp->atHeadOfList());
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 10/29/1990   Time: 02:29 pm
